/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.upgrade.v1_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;

public class UpgradePortletPreferences
extends BaseUpgradePortletPreferences {
    private static final String _DDM_FIELD_NAMESPACE = "ddm";
    private static final String _DDM_FIELD_OLD_PREFIX = "ddm/";
    private static final String _DDM_FIELD_OLD_SEPARATOR = "/";
    private static final String _DDM_FIELD_PREFIX = "ddm__";
    private static final String _DDM_FIELD_SEPARATOR = "__";
    private static final String _DDM_STRUCTURE_FIELD_NAME = "ddmStructureFieldName";
    private static final String _DDM_STRUCTURE_FIELD_VALUE = "ddmStructureFieldValue";
    private static final String _DL_CLASS_TYPE = "anyClassTypeDLFileEntryAssetRendererFactory";
    private static final String _DL_FILTER_BY_FIELD_ENABLED_KEY = "subtypeFieldsFilterEnabledDLFileEntryAssetRendererFactory";
    private static final String _JOURNAL_CLASS_TYPE = "anyClassTypeJournalArticleAssetRendererFactory";
    private static final String _JOURNAL_FILTER_BY_FIELD_ENABLED_KEY = "subtypeFieldsFilterEnabledJournalArticleAssetRendererFactory";
    private static final String _ORDER_BY_COLUMN_1 = "orderByColumn1";
    private static final String _ORDER_BY_COLUMN_2 = "orderByColumn2";
    private static final Map<Long, DDMForm> _ddmSructureDDMForms = new HashMap<Long, DDMForm>();
    private final DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DateFormat _newDateFormat;
    private final DateFormat _oldDateFormat;
    private final SAXReader _saxReader;

    public UpgradePortletPreferences(DDMStructureLocalService ddmStructureLocalService, DDMStructureLinkLocalService ddmStructureLinkLocalService, SAXReader saxReader) {
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._ddmStructureLinkLocalService = ddmStructureLinkLocalService;
        this._saxReader = saxReader;
        this._newDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
        this._oldDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
    }

    protected DDMForm getDDMForm(long structureId) throws Exception {
        DDMForm ddmForm = _ddmSructureDDMForms.get(structureId);
        if (ddmForm != null) {
            return ddmForm;
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(structureId);
        ddmForm = ddmStructure.getDDMForm();
        _ddmSructureDDMForms.put(structureId, ddmForm);
        return ddmForm;
    }

    protected DDMFormField getDDMFormField(DDMForm ddmForm, String fieldName) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
        return (DDMFormField)ddmFormFieldsMap.get(fieldName);
    }

    /*
     * Exception decompiling
     */
    protected String getJournalArticleResourceUuid(String journalArticleUuid) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] getPortletIds() {
        return new String[]{"com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet_INSTANCE_%"};
    }

    protected boolean isDateField(DDMForm ddmForm, String fieldName) {
        DDMFormField ddmFormField = this.getDDMFormField(ddmForm, fieldName);
        if (ddmFormField == null) {
            return false;
        }
        return Objects.equals("ddm-date", ddmFormField.getType());
    }

    protected boolean isFilterByFieldEnable(PortletPreferences portletPreferences, String key) {
        return GetterUtil.getBoolean((String)portletPreferences.getValue(key, Boolean.FALSE.toString()));
    }

    protected boolean isOldDDMPreferenceValueFormat(String value) {
        return value.startsWith(_DDM_FIELD_OLD_PREFIX);
    }

    protected void transformDateFieldValue(PortletPreferences portletPreferences) throws Exception {
        String value = GetterUtil.getString((String)portletPreferences.getValue(_DDM_STRUCTURE_FIELD_VALUE, null));
        if (Validator.isNotNull((String)value)) {
            Date date = this._oldDateFormat.parse(value);
            portletPreferences.setValue(_DDM_STRUCTURE_FIELD_VALUE, this._newDateFormat.format(date));
        }
    }

    protected void upgradeDLDateFieldsValues(PortletPreferences portletPreferences) throws Exception {
        long fileEntryTypeId = GetterUtil.getLong((String)portletPreferences.getValue(_DL_CLASS_TYPE, "0"));
        if (fileEntryTypeId > 0L) {
            long fileEntryTypeClassNameId = PortalUtil.getClassNameId(DLFileEntryType.class);
            List ddmStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(fileEntryTypeClassNameId, fileEntryTypeId);
            String selectedFieldName = GetterUtil.getString((String)portletPreferences.getValue(_DDM_STRUCTURE_FIELD_NAME, null));
            for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
                DDMForm ddmForm = this.getDDMForm(ddmStructureLink.getStructureId());
                if (!this.isDateField(ddmForm, selectedFieldName)) continue;
                this.transformDateFieldValue(portletPreferences);
                break;
            }
        }
    }

    protected void upgradeJournalDateFieldValue(PortletPreferences portletPreferences) throws Exception {
        long structureId = GetterUtil.getLong((String)portletPreferences.getValue(_JOURNAL_CLASS_TYPE, "0"));
        if (structureId > 0L) {
            String selectedFieldName = GetterUtil.getString((String)portletPreferences.getValue(_DDM_STRUCTURE_FIELD_NAME, null));
            DDMForm ddmForm = this.getDDMForm(structureId);
            if (this.isDateField(ddmForm, selectedFieldName)) {
                this.transformDateFieldValue(portletPreferences);
            }
        }
    }

    protected void upgradeOrderByColumn(PortletPreferences portletPreferences, String column) throws Exception {
        String value = GetterUtil.getString((String)portletPreferences.getValue(column, null));
        if (Validator.isNull((String)value)) {
            return;
        }
        if (value.startsWith(_DDM_FIELD_OLD_PREFIX) || value.startsWith(_DDM_FIELD_PREFIX)) {
            String[] values = new String[]{};
            boolean oldDDMPreferenceValueFormat = this.isOldDDMPreferenceValueFormat(value);
            values = oldDDMPreferenceValueFormat ? StringUtil.split((String)value, (String)_DDM_FIELD_OLD_SEPARATOR) : StringUtil.split((String)value, (String)_DDM_FIELD_SEPARATOR);
            if (values.length == 3) {
                long structureId = GetterUtil.getLong((String)values[1]);
                DDMForm ddmForm = this.getDDMForm(structureId);
                DDMFormField ddmFormField = this.getDDMFormField(ddmForm, values[2]);
                if (ddmFormField != null && Validator.isNotNull((String)ddmFormField.getIndexType())) {
                    StringBundler sb = new StringBundler(7);
                    sb.append(values[0]);
                    sb.append(_DDM_FIELD_SEPARATOR);
                    sb.append(ddmFormField.getIndexType());
                    sb.append(_DDM_FIELD_SEPARATOR);
                    sb.append(values[1]);
                    sb.append(_DDM_FIELD_SEPARATOR);
                    sb.append(values[2]);
                    value = sb.toString();
                }
            } else if (values.length == 4 && oldDDMPreferenceValueFormat) {
                value = StringUtil.replace((String)value, (String)_DDM_FIELD_OLD_SEPARATOR, (String)_DDM_FIELD_SEPARATOR);
            }
            portletPreferences.setValue(column, value);
        }
    }

    protected void upgradeOrderByColumns(PortletPreferences portletPreferences) throws Exception {
        this.upgradeOrderByColumn(portletPreferences, _ORDER_BY_COLUMN_1);
        this.upgradeOrderByColumn(portletPreferences, _ORDER_BY_COLUMN_2);
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        boolean subtypeFieldsFilterEnabled;
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Object[] assetEntryXmls = portletPreferences.getValues("asset-entry-xml", new String[0]);
        if (ArrayUtil.isNotEmpty((Object[])assetEntryXmls)) {
            this.upgradeUuids((String[])assetEntryXmls);
            portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
        }
        if (subtypeFieldsFilterEnabled = GetterUtil.getBoolean((String)portletPreferences.getValue("subtypeFieldsFilterEnabled", Boolean.FALSE.toString()))) {
            boolean dlFilterByFieldEnable = this.isFilterByFieldEnable(portletPreferences, _DL_FILTER_BY_FIELD_ENABLED_KEY);
            boolean journalFilterByFieldEnable = this.isFilterByFieldEnable(portletPreferences, _JOURNAL_FILTER_BY_FIELD_ENABLED_KEY);
            if (dlFilterByFieldEnable) {
                this.upgradeDLDateFieldsValues(portletPreferences);
            } else if (journalFilterByFieldEnable) {
                this.upgradeJournalDateFieldValue(portletPreferences);
            }
            this.upgradeOrderByColumns(portletPreferences);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected void upgradeUuids(String[] assetEntryXmls) throws Exception {
        for (int i = 0; i < assetEntryXmls.length; ++i) {
            String journalArticleResourceUuid;
            String assetEntry = assetEntryXmls[i];
            Document document = this._saxReader.read(assetEntry);
            Element rootElement = document.getRootElement();
            Element assetTypeElementUuid = rootElement.element("asset-entry-uuid");
            if (assetTypeElementUuid == null || (journalArticleResourceUuid = this.getJournalArticleResourceUuid(assetTypeElementUuid.getStringValue())) == null) continue;
            rootElement.remove(assetTypeElementUuid);
            assetTypeElementUuid.setText(journalArticleResourceUuid);
            rootElement.add(assetTypeElementUuid);
            document.setRootElement(rootElement);
            assetEntryXmls[i] = document.formattedString("");
        }
    }
}

