/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.upgrade.v1_0_1;

import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import java.util.Objects;
import javax.portlet.PortletPreferences;

public class UpgradePortletPreferences
extends BaseUpgradePortletPreferences {
    private static final String[][] _CLASS_NAMES = new String[][]{{"com.liferay.portlet.blogs.model.BlogsEntry", "com.liferay.blogs.model.BlogsEntry"}, {"com.liferay.portlet.bookmarks.model.BookmarksEntry", "com.liferay.bookmarks.model.BookmarksEntry"}, {"com.liferay.portlet.bookmarks.model.BookmarksFolder", "com.liferay.bookmarks.model.BookmarksFolder"}, {"com.liferay.portlet.documentlibrary.model.DLFileEntry", "com.liferay.document.library.kernel.model.DLFileEntry"}, {"com.liferay.portlet.documentlibrary.model.DLFolder", "com.liferay.document.library.kernel.model.DLFolder"}, {"com.liferay.portlet.journal.model.JournalArticle", "com.liferay.journal.model.JournalArticle"}, {"com.liferay.portlet.journal.model.JournalFolder", "com.liferay.journal.model.JournalFolder"}, {"com.liferay.portlet.messageboards.model.MBMessage", "com.liferay.message.boards.model.MBMessage"}, {"com.liferay.portlet.wiki.model.WikiPage", "com.liferay.wiki.model.WikiPage"}};
    private final SAXReader _saxReader;

    public UpgradePortletPreferences(SAXReader saxReader) {
        this._saxReader = saxReader;
    }

    protected String[] getPortletIds() {
        return new String[]{"com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet_INSTANCE_%"};
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        if (ArrayUtil.isNotEmpty((Object[])assetEntryXmls)) {
            this.upgradeTypes((String[])assetEntryXmls);
            portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected void upgradeTypes(String[] assetEntryXmls) throws Exception {
        for (int i = 0; i < assetEntryXmls.length; ++i) {
            String assetEntryType;
            String assetEntry = assetEntryXmls[i];
            Document document = this._saxReader.read(assetEntry);
            Element rootElement = document.getRootElement();
            Element assetEntryTypeElement = rootElement.element("asset-entry-type");
            if (assetEntryTypeElement == null) continue;
            String newAssetEntryType = assetEntryType = assetEntryTypeElement.getText();
            for (String[] classNames : _CLASS_NAMES) {
                newAssetEntryType = StringUtil.replace((String)newAssetEntryType, (String)classNames[0], (String)classNames[1]);
            }
            if (Objects.equals(assetEntryType, newAssetEntryType)) continue;
            rootElement.remove(assetEntryTypeElement);
            assetEntryTypeElement.setText(newAssetEntryType);
            rootElement.add(assetEntryTypeElement);
            document.setRootElement(rootElement);
            assetEntryXmls[i] = document.formattedString("");
        }
    }
}

