/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.util;

import aQute.bnd.annotation.ProviderType;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.configuration.AssetPublisherPortletInstanceConfiguration;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.display.context.AssetEntryResult;
import com.liferay.asset.publisher.web.display.context.AssetPublisherDisplayContext;
import com.liferay.asset.util.AssetEntryQueryProcessor;
import com.liferay.asset.util.AssetHelper;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Deprecated
@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, service={AssetPublisherUtil.class})
@ProviderType
public class AssetPublisherUtil {
    public static final String SCOPE_ID_CHILD_GROUP_PREFIX = "ChildGroup_";
    public static final String SCOPE_ID_GROUP_PREFIX = "Group_";
    public static final String SCOPE_ID_LAYOUT_PREFIX = "Layout_";
    public static final String SCOPE_ID_LAYOUT_UUID_PREFIX = "LayoutUuid_";
    public static final String SCOPE_ID_PARENT_GROUP_PREFIX = "ParentGroup_";
    private static final Log _log = LogFactoryUtil.getLog(AssetPublisherUtil.class);
    private static AssetPublisherUtil _instance;
    private static AssetCategoryLocalService _assetCategoryLocalService;
    private static AssetEntryLocalService _assetEntryLocalService;
    private static AssetEntryService _assetEntryService;
    private static AssetHelper _assetHelper;
    private static AssetPublisherPortletInstanceConfiguration _assetPublisherPortletInstanceConfiguration;
    private static AssetPublisherWebConfiguration _assetPublisherWebConfiguration;
    private static AssetTagLocalService _assetTagLocalService;
    private static DDMIndexer _ddmIndexer;
    private static GroupLocalService _groupLocalService;
    private static LayoutLocalService _layoutLocalService;
    private static PortletPreferencesFactory _portletPreferencesFactory;
    private static PortletPreferencesLocalService _portletPreferencesLocalService;
    private static SubscriptionLocalService _subscriptionLocalService;
    private final List<AssetEntryQueryProcessor> _assetEntryQueryProcessors = new CopyOnWriteArrayList<AssetEntryQueryProcessor>();

    public static void addAndStoreSelection(PortletRequest portletRequest, String className, long classPK, int assetEntryOrder) throws Exception {
        String portletId = PortalUtil.getPortletId((PortletRequest)portletRequest);
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        if (!rootPortletId.equals("com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        javax.portlet.PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            return;
        }
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            return;
        }
        AssetEntry assetEntry = _assetEntryLocalService.getEntry(className, classPK);
        AssetPublisherUtil.addSelection(themeDisplay, portletPreferences, portletId, assetEntry.getEntryId(), assetEntryOrder, className);
        portletPreferences.store();
    }

    public static void addSelection(PortletRequest portletRequest, javax.portlet.PortletPreferences portletPreferences, String portletId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long assetEntryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"assetEntryId");
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"assetEntryOrder");
        String assetEntryType = ParamUtil.getString((PortletRequest)portletRequest, (String)"assetEntryType");
        AssetPublisherUtil.addSelection(themeDisplay, portletPreferences, portletId, assetEntryId, assetEntryOrder, assetEntryType);
    }

    public static void addSelection(ThemeDisplay themeDisplay, javax.portlet.PortletPreferences portletPreferences, String portletId, long assetEntryId, int assetEntryOrder, String assetEntryType) throws Exception {
        String assetEntryXml;
        AssetEntry assetEntry = _assetEntryLocalService.fetchEntry(assetEntryId);
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        if (!ArrayUtil.contains((Object[])assetEntryXmls, (Object)(assetEntryXml = AssetPublisherUtil._getAssetEntryXml(assetEntryType, assetEntry.getClassUuid())))) {
            if (assetEntryOrder > -1) {
                assetEntryXmls[assetEntryOrder] = assetEntryXml;
            } else {
                assetEntryXmls = (String[])ArrayUtil.append((Object[])assetEntryXmls, (Object)assetEntryXml);
            }
            portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
        }
        try {
            portletPreferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public static void addUserAttributes(User user, String[] customUserAttributeNames, AssetEntryQuery assetEntryQuery) {
        if (user == null || customUserAttributeNames.length == 0) {
            return;
        }
        Group companyGroup = _groupLocalService.fetchCompanyGroup(user.getCompanyId());
        long[] allCategoryIds = assetEntryQuery.getAllCategoryIds();
        PrimitiveLongList allCategoryIdsList = new PrimitiveLongList(allCategoryIds.length + customUserAttributeNames.length);
        allCategoryIdsList.addAll(allCategoryIds);
        for (String customUserAttributeName : customUserAttributeNames) {
            ExpandoBridge userCustomAttributes = user.getExpandoBridge();
            Serializable userCustomFieldValue = userCustomAttributes.getAttribute(customUserAttributeName);
            if (userCustomFieldValue == null) continue;
            String userCustomFieldValueString = userCustomFieldValue.toString();
            List assetCategories = _assetCategoryLocalService.search(companyGroup.getGroupId(), userCustomFieldValueString, new String[0], -1, -1);
            for (AssetCategory assetCategory : assetCategories) {
                allCategoryIdsList.add(assetCategory.getCategoryId());
            }
        }
        assetEntryQuery.setAllCategoryIds(allCategoryIdsList.getArray());
    }

    public static String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        return _ddmIndexer.encodeName(ddmStructureId, fieldName, locale);
    }

    public static String filterAssetTagNames(long groupId, String assetTagNames) {
        long[] assetTagIds;
        ArrayList<String> filteredAssetTagNames = new ArrayList<String>();
        String[] assetTagNamesArray = StringUtil.split((String)assetTagNames);
        for (long assetTagId : assetTagIds = _assetTagLocalService.getTagIds(groupId, assetTagNamesArray)) {
            AssetTag assetTag = _assetTagLocalService.fetchAssetTag(assetTagId);
            if (assetTag == null) continue;
            filteredAssetTagNames.add(assetTag.getName());
        }
        return StringUtil.merge(filteredAssetTagNames);
    }

    public static long[] getAssetCategoryIds(javax.portlet.PortletPreferences portletPreferences) {
        Object[] queryValues;
        long[] assetCategoryIds = new long[]{};
        int i = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (Objects.equals(queryName, "assetCategories") && queryContains && (queryAndOperator || queryValues.length == 1)) {
                assetCategoryIds = ArrayUtil.append((long[][])new long[][]{assetCategoryIds, GetterUtil.getLongValues((String[])queryValues)});
            }
            ++i;
        }
        return assetCategoryIds;
    }

    public static BaseModelSearchResult<AssetEntry> getAssetEntries(AssetEntryQuery assetEntryQuery, Layout layout, javax.portlet.PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, Map<String, Serializable> attributes, int start, int end) throws Exception {
        if (AssetPublisherUtil.isSearchWithIndex(portletName, assetEntryQuery)) {
            return _assetHelper.searchAssetEntries(assetEntryQuery, AssetPublisherUtil.getAssetCategoryIds(portletPreferences), AssetPublisherUtil.getAssetTagNames(portletPreferences), attributes, companyId, assetEntryQuery.getKeywords(), layout, locale, scopeGroupId, timeZone, userId, start, end);
        }
        int total = _assetEntryService.getEntriesCount(assetEntryQuery);
        assetEntryQuery.setEnd(end);
        assetEntryQuery.setStart(start);
        List results = _assetEntryService.getEntries(assetEntryQuery);
        return new BaseModelSearchResult(results, total);
    }

    @Deprecated
    public static List<AssetEntry> getAssetEntries(javax.portlet.PortletPreferences portletPreferences, Layout layout, long scopeGroupId, int max, boolean checkPermission) throws PortalException {
        return Collections.emptyList();
    }

    public static List<AssetEntry> getAssetEntries(PortletRequest portletRequest, javax.portlet.PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, boolean deleteMissingAssetEntries, boolean checkPermission) throws Exception {
        return AssetPublisherUtil.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, deleteMissingAssetEntries, checkPermission, false);
    }

    public static List<AssetEntry> getAssetEntries(PortletRequest portletRequest, javax.portlet.PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, boolean deleteMissingAssetEntries, boolean checkPermission, boolean includeNonVisibleAssets) throws Exception {
        return AssetPublisherUtil.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, deleteMissingAssetEntries, checkPermission, includeNonVisibleAssets, 1);
    }

    public static List<AssetEntry> getAssetEntries(PortletRequest portletRequest, javax.portlet.PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, boolean deleteMissingAssetEntries, boolean checkPermission, boolean includeNonVisibleAssets, int type) throws Exception {
        String[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        ArrayList<String> missingAssetEntryUuids = new ArrayList<String>();
        for (String assetEntryXml : assetEntryXmls) {
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            String assetEntryType = rootElement.elementText("asset-entry-type");
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntryType);
            String portletId = null;
            if (assetRendererFactory != null) {
                portletId = assetRendererFactory.getPortletId();
            }
            AssetEntry assetEntry = null;
            for (long groupId : groupIds) {
                Group group = _groupLocalService.fetchGroup(groupId);
                if (portletId != null && group.isStagingGroup() && !group.isStagedPortlet(portletId)) {
                    groupId = group.getLiveGroupId();
                }
                if ((assetEntry = _assetEntryLocalService.fetchEntry(groupId, assetEntryUuid)) != null) break;
            }
            if (assetEntry == null) {
                if (!deleteMissingAssetEntries) continue;
                missingAssetEntryUuids.add(assetEntryUuid);
                continue;
            }
            if (!assetEntry.isVisible() && !includeNonVisibleAssets) continue;
            assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
            if (assetRendererFactory == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No asset renderer factory associated with " + assetEntry.getClassName()));
                continue;
            }
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), type);
            if (!assetRendererFactory.isActive(permissionChecker.getCompanyId())) {
                if (!deleteMissingAssetEntries) continue;
                missingAssetEntryUuids.add(assetEntryUuid);
                continue;
            }
            if (checkPermission && (!assetRenderer.isDisplayable() && !includeNonVisibleAssets || !assetRenderer.hasViewPermission(permissionChecker) && !(assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), 1)).hasViewPermission(permissionChecker))) continue;
            assetEntries.add(assetEntry);
        }
        if (deleteMissingAssetEntries) {
            AssetPublisherUtil.removeAndStoreSelection(missingAssetEntryUuids, portletPreferences);
            if (!missingAssetEntryUuids.isEmpty()) {
                SessionMessages.add((PortletRequest)portletRequest, (String)"deletedMissingAssetEntries", missingAssetEntryUuids);
            }
        }
        return assetEntries;
    }

    public static List<AssetEntry> getAssetEntries(PortletRequest portletRequest, javax.portlet.PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, long[] allCategoryIds, String[] allTagNames, boolean deleteMissingAssetEntries, boolean checkPermission) throws Exception {
        List<AssetEntry> assetEntries = AssetPublisherUtil.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, deleteMissingAssetEntries, checkPermission);
        if (assetEntries.isEmpty() || ArrayUtil.isEmpty((long[])allCategoryIds) && ArrayUtil.isEmpty((Object[])allTagNames)) {
            return assetEntries;
        }
        if (!ArrayUtil.isEmpty((long[])allCategoryIds)) {
            assetEntries = AssetPublisherUtil._filterAssetCategoriesAssetEntries(assetEntries, allCategoryIds);
        }
        if (!ArrayUtil.isEmpty((Object[])allTagNames)) {
            assetEntries = AssetPublisherUtil._filterAssetTagNamesAssetEntries(assetEntries, allTagNames);
        }
        return assetEntries;
    }

    public static AssetEntryQuery getAssetEntryQuery(javax.portlet.PortletPreferences portletPreferences, long groupId, Layout layout, long[] overrideAllAssetCategoryIds, String[] overrideAllAssetTagNames) throws PortalException {
        long[] groupIds = AssetPublisherUtil.getGroupIds(portletPreferences, groupId, layout);
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        AssetPublisherUtil._setCategoriesAndTags(assetEntryQuery, portletPreferences, groupIds, overrideAllAssetCategoryIds, overrideAllAssetTagNames);
        assetEntryQuery.setGroupIds(groupIds);
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", null), (boolean)true);
        if (!anyAssetType) {
            long[] availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)layout.getCompanyId());
            long[] classNameIds = AssetPublisherUtil.getClassNameIds(portletPreferences, availableClassNameIds);
            assetEntryQuery.setClassNameIds(classNameIds);
        }
        long[] classTypeIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classTypeIds", null));
        assetEntryQuery.setClassTypeIds(classTypeIds);
        boolean enablePermissions = GetterUtil.getBoolean((String)portletPreferences.getValue("enablePermissions", null));
        assetEntryQuery.setEnablePermissions(enablePermissions);
        boolean excludeZeroViewCount = GetterUtil.getBoolean((String)portletPreferences.getValue("excludeZeroViewCount", null));
        assetEntryQuery.setExcludeZeroViewCount(excludeZeroViewCount);
        boolean showOnlyLayoutAssets = GetterUtil.getBoolean((String)portletPreferences.getValue("showOnlyLayoutAssets", null));
        if (showOnlyLayoutAssets) {
            assetEntryQuery.setLayout(layout);
        }
        String orderByColumn1 = GetterUtil.getString((String)portletPreferences.getValue("orderByColumn1", "modifiedDate"));
        assetEntryQuery.setOrderByCol1(orderByColumn1);
        String orderByColumn2 = GetterUtil.getString((String)portletPreferences.getValue("orderByColumn2", "title"));
        assetEntryQuery.setOrderByCol2(orderByColumn2);
        String orderByType1 = GetterUtil.getString((String)portletPreferences.getValue("orderByType1", "DESC"));
        assetEntryQuery.setOrderByType1(orderByType1);
        String orderByType2 = GetterUtil.getString((String)portletPreferences.getValue("orderByType2", "ASC"));
        assetEntryQuery.setOrderByType2(orderByType2);
        return assetEntryQuery;
    }

    public static AssetEntryQuery getAssetEntryQuery(javax.portlet.PortletPreferences portletPreferences, long[] scopeGroupIds, long[] overrideAllAssetCategoryIds, String[] overrideAllAssetTagNames) {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        AssetPublisherUtil._setCategoriesAndTags(assetEntryQuery, portletPreferences, scopeGroupIds, overrideAllAssetCategoryIds, overrideAllAssetTagNames);
        return assetEntryQuery;
    }

    public static List<AssetEntryQueryProcessor> getAssetEntryQueryProcessors() {
        return AssetPublisherUtil._instance._assetEntryQueryProcessors;
    }

    public static List<AssetEntryResult> getAssetEntryResults(AssetPublisherDisplayContext assetPublisherDisplayContext, SearchContainer searchContainer, javax.portlet.PortletPreferences portletPreferences) throws Exception {
        AssetEntryQuery assetEntryQuery = assetPublisherDisplayContext.getAssetEntryQuery();
        Layout layout = assetPublisherDisplayContext.getLayout();
        String portletName = assetPublisherDisplayContext.getPortletName();
        Locale locale = assetPublisherDisplayContext.getLocale();
        TimeZone timeZone = assetPublisherDisplayContext.getTimeZone();
        long companyId = assetPublisherDisplayContext.getCompanyId();
        long scopeGroupId = assetPublisherDisplayContext.getScopeGroupId();
        long userId = assetPublisherDisplayContext.getUserId();
        long[] classNameIds = assetPublisherDisplayContext.getClassNameIds();
        Map<String, Serializable> attributes = assetPublisherDisplayContext.getAttributes();
        attributes.put("filterExpired", Boolean.TRUE);
        return AssetPublisherUtil.getAssetEntryResults(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, attributes);
    }

    public static List<AssetEntryResult> getAssetEntryResults(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, javax.portlet.PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, Map<String, Serializable> attributes) throws Exception {
        if (!AssetPublisherUtil.isShowAssetEntryResults(portletName, assetEntryQuery)) {
            return Collections.emptyList();
        }
        long assetVocabularyId = GetterUtil.getLong((String)portletPreferences.getValue("assetVocabularyId", null));
        if (assetVocabularyId > 0L) {
            return AssetPublisherUtil.getAssetEntryResultsByVocabulary(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, assetVocabularyId, attributes);
        }
        if (assetVocabularyId <= -1L) {
            return AssetPublisherUtil.getAssetEntryResultsByClassName(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, attributes);
        }
        return AssetPublisherUtil.getAssetEntryResultsByDefault(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, attributes);
    }

    public static String[] getAssetTagNames(javax.portlet.PortletPreferences portletPreferences) {
        Object[] queryValues;
        Object[] allAssetTagNames = new String[]{};
        int i = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (!Objects.equals(queryName, "assetCategories") && queryContains && (queryAndOperator || queryValues.length == 1)) {
                allAssetTagNames = queryValues;
            }
            ++i;
        }
        return allAssetTagNames;
    }

    public static String getClassName(AssetRendererFactory<?> assetRendererFactory) {
        Class<?> clazz = assetRendererFactory.getClass();
        String className = clazz.getName();
        int pos = className.lastIndexOf(".");
        return className.substring(pos + 1);
    }

    public static long[] getClassNameIds(javax.portlet.PortletPreferences portletPreferences, long[] availableClassNameIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", Boolean.TRUE.toString()));
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (anyAssetType || selectionStyle.equals("manual")) {
            return availableClassNameIds;
        }
        long defaultClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("anyAssetType", null));
        if (defaultClassNameId > 0L) {
            return new long[]{defaultClassNameId};
        }
        long[] classNameIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classNameIds", null));
        if (ArrayUtil.isNotEmpty((long[])classNameIds)) {
            return classNameIds;
        }
        return availableClassNameIds;
    }

    public static Long[] getClassTypeIds(javax.portlet.PortletPreferences portletPreferences, String className, List<ClassType> availableClassTypes) {
        Long[] availableClassTypeIds = new Long[availableClassTypes.size()];
        for (int i = 0; i < availableClassTypeIds.length; ++i) {
            ClassType classType = availableClassTypes.get(i);
            availableClassTypeIds[i] = classType.getClassTypeId();
        }
        return AssetPublisherUtil.getClassTypeIds(portletPreferences, className, availableClassTypeIds);
    }

    public static Long[] getClassTypeIds(javax.portlet.PortletPreferences portletPreferences, String className, Long[] availableClassTypeIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyClassType" + className, Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassTypeIds;
        }
        long defaultClassTypeId = GetterUtil.getLong((String)portletPreferences.getValue("anyClassType" + className, null), (long)-1L);
        if (defaultClassTypeId > -1L) {
            return new Long[]{defaultClassTypeId};
        }
        Long[] classTypeIds = ArrayUtil.toArray((long[])StringUtil.split((String)portletPreferences.getValue("classTypeIds" + className, null), (long)0L));
        if (classTypeIds != null) {
            return classTypeIds;
        }
        return availableClassTypeIds;
    }

    public static Map<Locale, String> getEmailAssetEntryAddedBodyMap(javax.portlet.PortletPreferences portletPreferences) {
        Locale defaultLocale;
        LocalizedValuesMap emailAssetEntryAddedLocalizedBodyMap = _assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedBody();
        Map emailAssetEntryAddedBodyMap = LocalizationUtil.getLocalizationMap((javax.portlet.PortletPreferences)portletPreferences, (String)"emailAssetEntryAddedBody", (String)"", (String)"", (ClassLoader)AssetPublisherUtil.class.getClassLoader());
        if (Validator.isNull((String)((String)emailAssetEntryAddedBodyMap.get(defaultLocale = LocaleUtil.getSiteDefault())))) {
            emailAssetEntryAddedBodyMap.put(defaultLocale, emailAssetEntryAddedLocalizedBodyMap.getDefaultValue());
        }
        return emailAssetEntryAddedBodyMap;
    }

    public static boolean getEmailAssetEntryAddedEnabled(javax.portlet.PortletPreferences portletPreferences) {
        String emailAssetEntryAddedEnabled = portletPreferences.getValue("emailAssetEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailAssetEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailAssetEntryAddedEnabled);
        }
        return _assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedEnabled();
    }

    public static Map<Locale, String> getEmailAssetEntryAddedSubjectMap(javax.portlet.PortletPreferences portletPreferences) {
        Locale defaultLocale;
        LocalizedValuesMap emailAssetEntryAddedLocalizedSubjectMap = _assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedSubject();
        Map emailAssetEntryAddedSubjectMap = LocalizationUtil.getLocalizationMap((javax.portlet.PortletPreferences)portletPreferences, (String)"emailAssetEntryAddedSubject", (String)"", (String)"", (ClassLoader)AssetPublisherUtil.class.getClassLoader());
        if (Validator.isNull((String)((String)emailAssetEntryAddedSubjectMap.get(defaultLocale = LocaleUtil.getSiteDefault())))) {
            emailAssetEntryAddedSubjectMap.put(defaultLocale, emailAssetEntryAddedLocalizedSubjectMap.getDefaultValue());
        }
        return emailAssetEntryAddedSubjectMap;
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$ASSET_ENTRIES$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-list-of-assets"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-assets"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-assets"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-assets"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)PortalUtil.getPortletTitle((String)"com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", (Locale)themeDisplay.getLocale())));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_TITLE$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-assets"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static String getEmailFromAddress(javax.portlet.PortletPreferences portletPreferences, long companyId) {
        return PortalUtil.getEmailFromAddress((javax.portlet.PortletPreferences)portletPreferences, (long)companyId, (String)_assetPublisherPortletInstanceConfiguration.emailFromAddress());
    }

    public static String getEmailFromName(javax.portlet.PortletPreferences portletPreferences, long companyId) {
        return PortalUtil.getEmailFromName((javax.portlet.PortletPreferences)portletPreferences, (long)companyId, (String)_assetPublisherPortletInstanceConfiguration.emailFromName());
    }

    public static long getGroupIdFromScopeId(String scopeId, long siteGroupId, boolean privateLayout) throws PortalException {
        if (scopeId.startsWith(SCOPE_ID_CHILD_GROUP_PREFIX)) {
            String scopeIdSuffix = scopeId.substring(SCOPE_ID_CHILD_GROUP_PREFIX.length());
            long childGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group childGroup = _groupLocalService.getGroup(childGroupId);
            if (!childGroup.hasAncestor(siteGroupId)) {
                throw new PrincipalException();
            }
            return childGroupId;
        }
        if (scopeId.startsWith(SCOPE_ID_GROUP_PREFIX)) {
            String scopeIdSuffix = scopeId.substring(SCOPE_ID_GROUP_PREFIX.length());
            if (scopeIdSuffix.equals("default")) {
                return siteGroupId;
            }
            long scopeGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group scopeGroup = _groupLocalService.getGroup(scopeGroupId);
            return scopeGroup.getGroupId();
        }
        if (scopeId.startsWith(SCOPE_ID_LAYOUT_UUID_PREFIX)) {
            String layoutUuid = scopeId.substring(SCOPE_ID_LAYOUT_UUID_PREFIX.length());
            Layout scopeIdLayout = _layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, siteGroupId, privateLayout);
            Group scopeIdGroup = _groupLocalService.checkScopeGroup(scopeIdLayout, PrincipalThreadLocal.getUserId());
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith(SCOPE_ID_LAYOUT_PREFIX)) {
            String scopeIdSuffix = scopeId.substring(SCOPE_ID_LAYOUT_PREFIX.length());
            long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdSuffix);
            Layout scopeIdLayout = _layoutLocalService.getLayout(siteGroupId, privateLayout, scopeIdLayoutId);
            Group scopeIdGroup = scopeIdLayout.getScopeGroup();
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith(SCOPE_ID_PARENT_GROUP_PREFIX)) {
            String scopeIdSuffix = scopeId.substring(SCOPE_ID_PARENT_GROUP_PREFIX.length());
            long parentGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group parentGroup = _groupLocalService.getGroup(parentGroupId);
            if (!SitesUtil.isContentSharingWithChildrenEnabled((Group)parentGroup)) {
                throw new PrincipalException();
            }
            Group group = _groupLocalService.getGroup(siteGroupId);
            if (!group.hasAncestor(parentGroupId)) {
                throw new PrincipalException();
            }
            return parentGroupId;
        }
        throw new IllegalArgumentException("Invalid scope ID " + scopeId);
    }

    public static long[] getGroupIds(javax.portlet.PortletPreferences portletPreferences, long scopeGroupId, Layout layout) {
        String[] scopeIds = portletPreferences.getValues("scopeIds", new String[]{SCOPE_ID_GROUP_PREFIX + scopeGroupId});
        LinkedHashSet<Long> groupIds = new LinkedHashSet<Long>();
        for (String scopeId : scopeIds) {
            try {
                long groupId = AssetPublisherUtil.getGroupIdFromScopeId(scopeId, scopeGroupId, layout.isPrivateLayout());
                groupIds.add(groupId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ArrayUtil.toLongArray(groupIds);
    }

    public static String getScopeId(Group group, long scopeGroupId) {
        String key = null;
        if (group.isLayout()) {
            Layout layout = _layoutLocalService.fetchLayout(group.getClassPK());
            key = SCOPE_ID_LAYOUT_UUID_PREFIX + layout.getUuid();
        } else {
            Group scopeGroup;
            key = group.isLayoutPrototype() || group.getGroupId() == scopeGroupId ? "Group_default" : ((scopeGroup = _groupLocalService.fetchGroup(scopeGroupId)).hasAncestor(group.getGroupId()) && SitesUtil.isContentSharingWithChildrenEnabled((Group)group) ? SCOPE_ID_PARENT_GROUP_PREFIX + group.getGroupId() : (group.hasAncestor(scopeGroup.getGroupId()) ? SCOPE_ID_CHILD_GROUP_PREFIX + group.getGroupId() : SCOPE_ID_GROUP_PREFIX + group.getGroupId()));
        }
        return key;
    }

    public static long getSubscriptionClassPK(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        Layout layout;
        if (plid != 0L && (layout = _layoutLocalService.fetchLayout(plid)) != null) {
            long userId = 0L;
            if (PortletIdCodec.hasUserId((String)portletId)) {
                userId = PortletIdCodec.decodeUserId((String)portletId);
            }
            PortletPreferencesIds portletPreferencesIds = _portletPreferencesFactory.getPortletPreferencesIds(layout.getGroupId(), userId, layout, portletId, false);
            ownerId = portletPreferencesIds.getOwnerId();
            ownerType = portletPreferencesIds.getOwnerType();
            plid = portletPreferencesIds.getPlid();
            portletId = portletPreferencesIds.getPortletId();
        }
        if (PortletIdCodec.hasUserId((String)portletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)portletId);
            ownerType = 4;
        }
        PortletPreferences portletPreferencesModel = _portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, plid, portletId);
        return portletPreferencesModel.getPortletPreferencesId();
    }

    public static long getSubscriptionClassPK(long plid, String portletId) throws PortalException {
        return AssetPublisherUtil.getSubscriptionClassPK(0L, 3, plid, portletId);
    }

    public static boolean isScopeIdSelectable(PermissionChecker permissionChecker, String scopeId, long companyGroupId, Layout layout) throws PortalException {
        return AssetPublisherUtil.isScopeIdSelectable(permissionChecker, scopeId, companyGroupId, layout, true);
    }

    public static boolean isScopeIdSelectable(PermissionChecker permissionChecker, String scopeId, long companyGroupId, Layout layout, boolean checkPermission) throws PortalException {
        long groupId = AssetPublisherUtil.getGroupIdFromScopeId(scopeId, layout.getGroupId(), layout.isPrivateLayout());
        if (scopeId.startsWith(SCOPE_ID_CHILD_GROUP_PREFIX)) {
            Group group = _groupLocalService.getGroup(groupId);
            if (!group.hasAncestor(layout.getGroupId())) {
                return false;
            }
        } else if (scopeId.startsWith(SCOPE_ID_PARENT_GROUP_PREFIX)) {
            Group siteGroup = layout.getGroup();
            if (!siteGroup.hasAncestor(groupId)) {
                return false;
            }
            Group group = _groupLocalService.getGroup(groupId);
            if (SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) {
                return true;
            }
            if (!PrefsPropsUtil.getBoolean((long)layout.getCompanyId(), (String)"sites.content.sharing.through.administrators.enabled")) {
                return false;
            }
            if (checkPermission) {
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"UPDATE");
            }
        } else if (groupId != companyGroupId && checkPermission) {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE");
        }
        return true;
    }

    public static boolean isSubscribed(long companyId, long userId, long plid, String portletId) throws PortalException {
        return _subscriptionLocalService.isSubscribed(companyId, userId, PortletPreferences.class.getName(), AssetPublisherUtil.getSubscriptionClassPK(plid, portletId));
    }

    @Deprecated
    public static void notifySubscriber(long userId, javax.portlet.PortletPreferences portletPreferences, List<AssetEntry> assetEntries) {
    }

    @Deprecated
    public static void notifySubscribers(javax.portlet.PortletPreferences portletPreferences, long plid, String portletId, List<AssetEntry> assetEntries) throws PortalException {
    }

    public static void processAssetEntryQuery(User user, javax.portlet.PortletPreferences portletPreferences, AssetEntryQuery assetEntryQuery) throws Exception {
        for (AssetEntryQueryProcessor assetEntryQueryProcessor : AssetPublisherUtil.getAssetEntryQueryProcessors()) {
            assetEntryQueryProcessor.processAssetEntryQuery(user, portletPreferences, assetEntryQuery);
        }
    }

    @Deprecated
    public static void registerAssetQueryProcessor(String assetQueryProcessorClassName, AssetEntryQueryProcessor assetQueryProcessor) {
    }

    public static void removeAndStoreSelection(List<String> assetEntryUuids, javax.portlet.PortletPreferences portletPreferences) throws Exception {
        if (assetEntryUuids.isEmpty()) {
            return;
        }
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        List assetEntryXmlsList = ListUtil.fromArray((Object[])assetEntryXmls);
        Iterator itr = assetEntryXmlsList.iterator();
        while (itr.hasNext()) {
            String assetEntryXml = (String)itr.next();
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            if (!assetEntryUuids.contains(assetEntryUuid)) continue;
            itr.remove();
        }
        portletPreferences.setValues("assetEntryXml", assetEntryXmlsList.toArray(new String[assetEntryXmlsList.size()]));
        portletPreferences.store();
    }

    public static void subscribe(PermissionChecker permissionChecker, long groupId, long plid, String portletId) throws PortalException {
        Layout layout = _layoutLocalService.fetchLayout(plid);
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)0L, (Layout)layout, (String)portletId, (String)"SUBSCRIBE", (boolean)false, (boolean)false);
        _subscriptionLocalService.addSubscription(permissionChecker.getUserId(), groupId, PortletPreferences.class.getName(), AssetPublisherUtil.getSubscriptionClassPK(plid, portletId));
    }

    @Deprecated
    public static void unregisterAssetQueryProcessor(String assetQueryProcessorClassName) {
    }

    public static void unsubscribe(PermissionChecker permissionChecker, long plid, String portletId) throws PortalException {
        Layout layout = _layoutLocalService.fetchLayout(plid);
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)0L, (Layout)layout, (String)portletId, (String)"SUBSCRIBE", (boolean)false, (boolean)false);
        _subscriptionLocalService.deleteSubscription(permissionChecker.getUserId(), PortletPreferences.class.getName(), AssetPublisherUtil.getSubscriptionClassPK(plid, portletId));
    }

    @Deprecated
    public void checkAssetEntries() throws Exception {
    }

    protected static List<AssetEntryResult> getAssetEntryResultsByClassName(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, javax.portlet.PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, Map<String, Serializable> attributes) throws Exception {
        ArrayList<AssetEntryResult> assetEntryResults = new ArrayList<AssetEntryResult>();
        int end = searchContainer.getEnd();
        int start = searchContainer.getStart();
        int total = 0;
        for (long classNameId : classNameIds) {
            assetEntryQuery.setClassNameIds(new long[]{classNameId});
            BaseModelSearchResult<AssetEntry> baseModelSearchResult = AssetPublisherUtil.getAssetEntries(assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, attributes, start, end);
            int groupTotal = baseModelSearchResult.getLength();
            total += groupTotal;
            List assetEntries = baseModelSearchResult.getBaseModels();
            if (!assetEntries.isEmpty() && start < groupTotal) {
                AssetRendererFactory groupAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameId);
                String title = ResourceActionsUtil.getModelResource((Locale)locale, (String)groupAssetRendererFactory.getClassName());
                assetEntryResults.add(new AssetEntryResult(title, assetEntries));
            }
            if (portletName.equals("com_liferay_asset_publisher_web_portlet_RecentContentPortlet")) continue;
            if (groupTotal > 0) {
                end = end > 0 && end > groupTotal ? (end -= groupTotal) : 0;
                start = start > 0 && start > groupTotal ? (start -= groupTotal) : 0;
            }
            assetEntryQuery.setEnd(-1);
            assetEntryQuery.setStart(-1);
        }
        searchContainer.setTotal(total);
        return assetEntryResults;
    }

    protected static List<AssetEntryResult> getAssetEntryResultsByDefault(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, javax.portlet.PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, Map<String, Serializable> attributes) throws Exception {
        ArrayList<AssetEntryResult> assetEntryResults = new ArrayList<AssetEntryResult>();
        int end = searchContainer.getEnd();
        int start = searchContainer.getStart();
        assetEntryQuery.setClassNameIds(classNameIds);
        BaseModelSearchResult<AssetEntry> baseModelSearchResult = AssetPublisherUtil.getAssetEntries(assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, attributes, start, end);
        int total = baseModelSearchResult.getLength();
        searchContainer.setTotal(total);
        List assetEntries = baseModelSearchResult.getBaseModels();
        if (!assetEntries.isEmpty() && start < total) {
            assetEntryResults.add(new AssetEntryResult(assetEntries));
        }
        return assetEntryResults;
    }

    protected static List<AssetEntryResult> getAssetEntryResultsByVocabulary(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, javax.portlet.PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, long assetVocabularyId, Map<String, Serializable> attributes) throws Exception {
        ArrayList<AssetEntryResult> assetEntryResults = new ArrayList<AssetEntryResult>();
        List assetCategories = _assetCategoryLocalService.getVocabularyRootCategories(assetVocabularyId, -1, -1, null);
        assetEntryQuery.setClassNameIds(classNameIds);
        int end = searchContainer.getEnd();
        int start = searchContainer.getStart();
        int total = 0;
        for (AssetCategory assetCategory : assetCategories) {
            long[] oldAllCategoryIds = assetEntryQuery.getAllCategoryIds();
            long[] newAllAssetCategoryIds = ArrayUtil.append((long[])oldAllCategoryIds, (long)assetCategory.getCategoryId());
            assetEntryQuery.setAllCategoryIds(newAllAssetCategoryIds);
            BaseModelSearchResult<AssetEntry> baseModelSearchResult = AssetPublisherUtil.getAssetEntries(assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, attributes, start, end);
            int groupTotal = baseModelSearchResult.getLength();
            total += groupTotal;
            List assetEntries = baseModelSearchResult.getBaseModels();
            if (!assetEntries.isEmpty() && start < groupTotal) {
                String title = assetCategory.getTitle(locale);
                assetEntryResults.add(new AssetEntryResult(title, assetEntries));
            }
            if (groupTotal > 0) {
                end = end > 0 && end > groupTotal ? (end -= groupTotal) : 0;
                start = start > 0 && start > groupTotal ? (start -= groupTotal) : 0;
            }
            assetEntryQuery.setAllCategoryIds(oldAllCategoryIds);
            assetEntryQuery.setEnd(-1);
            assetEntryQuery.setStart(-1);
        }
        searchContainer.setTotal(total);
        return assetEntryResults;
    }

    protected static long[] getSiteGroupIds(long[] groupIds) {
        LinkedHashSet<Long> siteGroupIds = new LinkedHashSet<Long>();
        for (long groupId : groupIds) {
            siteGroupIds.add(PortalUtil.getSiteGroupId((long)groupId));
        }
        return ArrayUtil.toLongArray(siteGroupIds);
    }

    protected static boolean isSearchWithIndex(String portletName, AssetEntryQuery assetEntryQuery) {
        return _assetPublisherWebConfiguration.searchWithIndex() && assetEntryQuery.getLinkedAssetEntryId() == 0L && !portletName.equals("com_liferay_asset_publisher_web_portlet_HighestRatedAssetsPortlet") && !portletName.equals("com_liferay_asset_publisher_web_portlet_MostViewedAssetsPortlet");
    }

    protected static boolean isShowAssetEntryResults(String portletName, AssetEntryQuery assetEntryQuery) {
        return !portletName.equals("com_liferay_asset_publisher_web_portlet_RelatedAssetsPortlet") || assetEntryQuery.getLinkedAssetEntryId() > 0L;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) throws ConfigurationException {
        _instance = this;
        _assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)ConfigurableUtil.createConfigurable(AssetPublisherWebConfiguration.class, properties);
        _assetPublisherPortletInstanceConfiguration = (AssetPublisherPortletInstanceConfiguration)ConfigurationProviderUtil.getSystemConfiguration(AssetPublisherPortletInstanceConfiguration.class);
    }

    @Reference(unbind="-")
    protected void setAssetCategoryLocalService(AssetCategoryLocalService assetCategoryLocalService) {
        _assetCategoryLocalService = assetCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        _assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAssetEntryQueryProcessor(AssetEntryQueryProcessor assetEntryQueryProcessor) {
        this._assetEntryQueryProcessors.add(assetEntryQueryProcessor);
    }

    @Reference(unbind="-")
    protected void setAssetEntryService(AssetEntryService assetEntryService) {
        _assetEntryService = assetEntryService;
    }

    @Reference(unbind="-")
    protected void setAssetHelper(AssetHelper assetHelper) {
        _assetHelper = assetHelper;
    }

    @Reference(unbind="-")
    protected void setAssetTagLocalService(AssetTagLocalService assetTagLocalService) {
        _assetTagLocalService = assetTagLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMIndexer(DDMIndexer ddmIndexer) {
        _ddmIndexer = ddmIndexer;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        _groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        _layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesFactory(PortletPreferencesFactory portletPreferencesFactory) {
        _portletPreferencesFactory = portletPreferencesFactory;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        _portletPreferencesLocalService = portletPreferencesLocalService;
    }

    @Deprecated
    protected void setSubscriptionLocalService(com.liferay.portal.kernel.service.SubscriptionLocalService subscriptionLocalService) {
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        _subscriptionLocalService = subscriptionLocalService;
    }

    @Deprecated
    protected void setUserLocalService(UserLocalService userLocalService) {
    }

    protected void unsetAssetEntryQueryProcessor(AssetEntryQueryProcessor assetEntryQueryProcessor) {
        this._assetEntryQueryProcessors.remove(assetEntryQueryProcessor);
    }

    private static List<AssetEntry> _filterAssetCategoriesAssetEntries(List<AssetEntry> assetEntries, long[] assetCategoryIds) {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            if (!ArrayUtil.containsAll((long[])assetEntry.getCategoryIds(), (long[])assetCategoryIds)) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    private static long[] _filterAssetCategoryIds(long[] assetCategoryIds) {
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        for (long assetCategoryId : assetCategoryIds) {
            AssetCategory category = _assetCategoryLocalService.fetchAssetCategory(assetCategoryId);
            if (category == null) continue;
            assetCategoryIdsList.add(assetCategoryId);
        }
        return ArrayUtil.toArray((Long[])assetCategoryIdsList.toArray(new Long[assetCategoryIdsList.size()]));
    }

    private static List<AssetEntry> _filterAssetTagNamesAssetEntries(List<AssetEntry> assetEntries, String[] assetTagNames) {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            List assetTags = assetEntry.getTags();
            Object[] assetEntryAssetTagNames = new String[assetTags.size()];
            for (int i = 0; i < assetTags.size(); ++i) {
                AssetTag assetTag = (AssetTag)assetTags.get(i);
                assetEntryAssetTagNames[i] = assetTag.getName();
            }
            if (!ArrayUtil.containsAll((Object[])assetEntryAssetTagNames, (Object[])assetTagNames)) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    private static String _getAssetEntryXml(String assetEntryType, String assetEntryUuid) {
        String xml;
        block2: {
            xml = null;
            try {
                Document document = SAXReaderUtil.createDocument((String)"UTF-8");
                Element assetEntryElement = document.addElement("asset-entry");
                Element assetEntryTypeElement = assetEntryElement.addElement("asset-entry-type");
                assetEntryTypeElement.addText(assetEntryType);
                Element assetEntryUuidElement = assetEntryElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(assetEntryUuid);
                xml = document.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        return xml;
    }

    private static void _setCategoriesAndTags(AssetEntryQuery assetEntryQuery, javax.portlet.PortletPreferences portletPreferences, long[] scopeGroupIds, long[] overrideAllAssetCategoryIds, String[] overrideAllAssetTagNames) {
        Object[] queryValues;
        long[] allAssetCategoryIds = new long[]{};
        long[] anyAssetCategoryIds = new long[]{};
        long[] notAllAssetCategoryIds = new long[]{};
        long[] notAnyAssetCategoryIds = new long[]{};
        Object[] allAssetTagNames = new String[]{};
        Object[] anyAssetTagNames = new String[]{};
        Object[] notAllAssetTagNames = new String[]{};
        Object[] notAnyAssetTagNames = new String[]{};
        int i = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i, null)))) {
            int queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (Objects.equals(queryName, "assetCategories")) {
                long[] lArray = GetterUtil.getLongValues((String[])queryValues);
                if (queryContains != 0 && queryAndOperator) {
                    allAssetCategoryIds = lArray;
                } else if (queryContains != 0 && !queryAndOperator) {
                    anyAssetCategoryIds = lArray;
                } else if (queryContains == 0 && queryAndOperator) {
                    notAllAssetCategoryIds = lArray;
                } else {
                    notAnyAssetCategoryIds = lArray;
                }
            } else if (queryContains != 0 && queryAndOperator) {
                allAssetTagNames = queryValues;
            } else if (queryContains != 0 && !queryAndOperator) {
                anyAssetTagNames = queryValues;
            } else if (queryContains == 0 && queryAndOperator) {
                notAllAssetTagNames = queryValues;
            } else {
                notAnyAssetTagNames = queryValues;
            }
            ++i;
        }
        if (overrideAllAssetCategoryIds != null) {
            allAssetCategoryIds = overrideAllAssetCategoryIds;
        }
        allAssetCategoryIds = AssetPublisherUtil._filterAssetCategoryIds(allAssetCategoryIds);
        assetEntryQuery.setAllCategoryIds(allAssetCategoryIds);
        if (overrideAllAssetTagNames != null) {
            allAssetTagNames = overrideAllAssetTagNames;
        }
        long[] siteGroupIds = AssetPublisherUtil.getSiteGroupIds(scopeGroupIds);
        for (Object assetTagName : allAssetTagNames) {
            long[] lArray = _assetTagLocalService.getTagIds(siteGroupIds, (String)assetTagName);
            assetEntryQuery.addAllTagIdsArray(lArray);
        }
        assetEntryQuery.setAnyCategoryIds(anyAssetCategoryIds);
        long[] anyAssetTagIds = _assetTagLocalService.getTagIds(siteGroupIds, (String[])anyAssetTagNames);
        assetEntryQuery.setAnyTagIds(anyAssetTagIds);
        assetEntryQuery.setNotAllCategoryIds(notAllAssetCategoryIds);
        for (String string : notAllAssetTagNames) {
            long[] notAllAssetTagIds = _assetTagLocalService.getTagIds(siteGroupIds, string);
            assetEntryQuery.addNotAllTagIdsArray(notAllAssetTagIds);
        }
        assetEntryQuery.setNotAnyCategoryIds(notAnyAssetCategoryIds);
        long[] notAnyAssetTagIds = _assetTagLocalService.getTagIds(siteGroupIds, (String[])notAnyAssetTagNames);
        assetEntryQuery.setNotAnyTagIds(notAnyAssetTagIds);
    }
}

