/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.publisher.web.display.context.AssetEntryResult;
import com.liferay.asset.publisher.web.display.context.AssetPublisherDisplayContext;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherHelper;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.publisher.web.util.RSSExporterUtil;
import com.liferay.asset.publisher.web.util.SyndModelFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.util.RSSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class AssetRSSUtil {
    public static byte[] getRSS(ResourceRequest portletRequest, ResourceResponse portletResponse) throws Exception {
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (!selectionStyle.equals("dynamic")) {
            return new byte[0];
        }
        String assetLinkBehavior = portletPreferences.getValue("assetLinkBehavior", "showFullContent");
        String rssDisplayStyle = portletPreferences.getValue("rssDisplayStyle", "abstract");
        String rssFeedType = portletPreferences.getValue("rssFeedType", RSSUtil.FEED_TYPE_DEFAULT);
        String rssName = portletPreferences.getValue("rssName", null);
        String format = RSSUtil.getFeedTypeFormat((String)rssFeedType);
        double version = RSSUtil.getFeedTypeVersion((String)rssFeedType);
        String rss = AssetRSSUtil.exportToRSS((PortletRequest)portletRequest, (PortletResponse)portletResponse, rssName, null, format, version, rssDisplayStyle, assetLinkBehavior, AssetRSSUtil.getAssetEntries((PortletRequest)portletRequest, (PortletResponse)portletResponse, portletPreferences));
        return rss.getBytes("UTF-8");
    }

    protected static String exportToRSS(PortletRequest portletRequest, PortletResponse portletResponse, String name, String description, String format, double version, String displayStyle, String linkBehavior, List<AssetEntry> assetEntries) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SyndFeed syndFeed = SyndModelFactoryUtil.createSyndFeed();
        syndFeed.setDescription(GetterUtil.getString((String)description, (String)name));
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        for (AssetEntry assetEntry : assetEntries) {
            SyndEntry syndEntry = SyndModelFactoryUtil.createSyndEntry();
            String author = PortalUtil.getUserName((BaseModel)assetEntry);
            syndEntry.setAuthor(author);
            SyndContent syndContent = SyndModelFactoryUtil.createSyndContent();
            syndContent.setType("html");
            String value = null;
            String languageId = LanguageUtil.getLanguageId((PortletRequest)portletRequest);
            value = displayStyle.equals("title") ? "" : assetEntry.getSummary(languageId, true);
            syndContent.setValue(value);
            syndEntry.setDescription(syndContent);
            String link = AssetRSSUtil.getEntryURL(portletRequest, portletResponse, linkBehavior, assetEntry);
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(assetEntry.getPublishDate());
            syndEntry.setTitle(assetEntry.getTitle(languageId, true));
            syndEntry.setUpdatedDate(assetEntry.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)format, (double)version));
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        syndFeed.setLinks(syndLinks);
        SyndLink selfSyndLink = SyndModelFactoryUtil.createSyndLink();
        syndLinks.add(selfSyndLink);
        String feedURL = AssetRSSUtil.getFeedURL(portletRequest);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        SyndLink alternateSyndLink = SyndModelFactoryUtil.createSyndLink();
        syndLinks.add(alternateSyndLink);
        alternateSyndLink.setHref(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay));
        alternateSyndLink.setRel("alternate");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return RSSExporterUtil.export(syndFeed);
    }

    @Deprecated
    protected static List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences) throws Exception {
        throw new UnsupportedOperationException("This method is deprecated and replaced by #getAssetEntries(PortletRequest, PortletResponse, PortletPreferences)");
    }

    protected static List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletResponse portletResponse, PortletPreferences portletPreferences) throws Exception {
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        SearchContainer searchContainer = new SearchContainer();
        AssetPublisherCustomizer assetPublisherCustomizer = (AssetPublisherCustomizer)portletRequest.getAttribute("ASSET_PUBLISHER_CUSTOMIZER");
        AssetPublisherDisplayContext assetPublisherDisplayContext = new AssetPublisherDisplayContext(assetPublisherCustomizer, portletRequest, portletResponse, portletPreferences);
        searchContainer.setDelta(assetPublisherDisplayContext.getRSSDelta());
        List<AssetEntryResult> assetEntryResults = AssetPublisherUtil.getAssetEntryResults(assetPublisherDisplayContext, searchContainer, portletPreferences);
        for (AssetEntryResult assetEntryResult : assetEntryResults) {
            assetEntries.addAll(assetEntryResult.getAssetEntries());
        }
        return assetEntries;
    }

    protected static String getAssetPublisherURL(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        StringBundler sb = new StringBundler(6);
        String layoutFriendlyURL = GetterUtil.getString((String)PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay));
        if (!layoutFriendlyURL.startsWith("http://") && !layoutFriendlyURL.startsWith("https://")) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(layoutFriendlyURL);
        sb.append("/-/");
        sb.append("asset_publisher/");
        sb.append(portletDisplay.getInstanceId());
        sb.append("/");
        return sb.toString();
    }

    protected static String getEntryURL(PortletRequest portletRequest, PortletResponse portletResponse, String linkBehavior, AssetEntry assetEntry) throws Exception {
        if (linkBehavior.equals("viewInPortlet")) {
            return AssetRSSUtil.getEntryURLViewInContext(portletRequest, portletResponse, assetEntry);
        }
        return AssetRSSUtil.getEntryURLAssetPublisher(portletRequest, portletResponse, assetEntry);
    }

    protected static String getEntryURLAssetPublisher(PortletRequest portletRequest, PortletResponse portletResponse, AssetEntry assetEntry) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        StringBundler sb = new StringBundler(4);
        sb.append(AssetRSSUtil.getAssetPublisherURL(portletRequest));
        sb.append(assetRendererFactory.getType());
        sb.append("/id/");
        sb.append(assetEntry.getEntryId());
        return sb.toString();
    }

    protected static String getEntryURLViewInContext(PortletRequest portletRequest, PortletResponse portletResponse, AssetEntry assetEntry) throws Exception {
        String assetViewURL = AssetPublisherHelper.getAssetViewURL(PortalUtil.getLiferayPortletRequest((PortletRequest)portletRequest), PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse), assetEntry, true);
        if (Validator.isNotNull((String)assetViewURL) && !assetViewURL.startsWith("http://") && !assetViewURL.startsWith("https://")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            assetViewURL = themeDisplay.getPortalURL() + assetViewURL;
        }
        return assetViewURL;
    }

    protected static String getFeedURL(PortletRequest portletRequest) throws Exception {
        String feedURL = AssetRSSUtil.getAssetPublisherURL(portletRequest);
        return feedURL.concat("rss");
    }
}

