/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.util;

import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.util.AssetEntryQueryProcessor;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, service={AssetPublisherCustomizer.class})
public class DefaultAssetPublisherCustomizer
implements AssetPublisherCustomizer {
    protected AssetPublisherWebConfiguration assetPublisherWebConfiguration;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        this.assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)ConfigurableUtil.createConfigurable(AssetPublisherWebConfiguration.class, properties);
    }

    @Override
    public Integer getDelta(HttpServletRequest request) {
        PortletPreferences portletPreferences = this.getPortletPreferences(request);
        Integer delta = GetterUtil.getInteger((String)portletPreferences.getValue("delta", null), (int)SearchContainer.DEFAULT_DELTA);
        return delta;
    }

    @Override
    public String getPortletId() {
        return "com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet";
    }

    @Override
    public boolean isEnablePermissions(HttpServletRequest request) {
        if (this.assetPublisherWebConfiguration.searchWithIndex()) {
            return true;
        }
        if (!this.assetPublisherWebConfiguration.permissionCheckingConfigurable()) {
            return true;
        }
        PortletPreferences portletPreferences = this.getPortletPreferences(request);
        Boolean enablePermissions = GetterUtil.getBoolean((String)portletPreferences.getValue("enablePermissions", null), (boolean)true);
        return enablePermissions;
    }

    @Override
    public boolean isOrderingAndGroupingEnabled(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isOrderingByTitleEnabled(HttpServletRequest request) {
        return this.assetPublisherWebConfiguration.searchWithIndex();
    }

    @Override
    public boolean isSelectionStyleEnabled(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowAssetEntryQueryProcessor(AssetEntryQueryProcessor assetEntryQueryProcessor) {
        return true;
    }

    @Override
    public boolean isShowEnableAddContentButton(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowEnableRelatedAssets(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowScopeSelector(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowSubtypeFieldsFilter(HttpServletRequest request) {
        return this.assetPublisherWebConfiguration.searchWithIndex();
    }

    @Override
    public void setAssetEntryQueryOptions(AssetEntryQuery assetEntryQuery, HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletPreferences portletPreferences = this.getPortletPreferences(request);
        long[] groupIds = AssetPublisherUtil.getGroupIds(portletPreferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout());
        assetEntryQuery.setGroupIds(groupIds);
    }

    protected String getPortletName(HttpServletRequest request) {
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        if (portletConfig == null) {
            return "";
        }
        return portletConfig.getPortletName();
    }

    protected PortletPreferences getPortletPreferences(HttpServletRequest request) {
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            return portletRequest.getPreferences();
        }
        return null;
    }
}

