/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.util;

import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizerRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class DefaultAssetPublisherCustomizerRegistry
implements AssetPublisherCustomizerRegistry {
    private final Map<String, AssetPublisherCustomizer> _assetPublisherCustomizers = new ConcurrentHashMap<String, AssetPublisherCustomizer>();

    @Override
    public AssetPublisherCustomizer getAssetPublisherCustomizer(String portletId) {
        AssetPublisherCustomizer assetPublisherCustomizer = this._assetPublisherCustomizers.get(portletId);
        if (assetPublisherCustomizer == null) {
            assetPublisherCustomizer = this._assetPublisherCustomizers.get("com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet");
        }
        return assetPublisherCustomizer;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerAssetPublisherCustomizer(AssetPublisherCustomizer assetPublisherCustomizer) {
        this._assetPublisherCustomizers.put(assetPublisherCustomizer.getPortletId(), assetPublisherCustomizer);
    }

    public void unregisterAssetPublisherCustomizer(AssetPublisherCustomizer assetPublisherCustomizer) {
        this._assetPublisherCustomizers.remove(assetPublisherCustomizer.getPortletId());
    }
}

