/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.util;

import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.publisher.web.util.DefaultAssetPublisherCustomizer;
import com.liferay.asset.util.AssetEntryQueryProcessor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, service={AssetPublisherCustomizer.class})
public class RecentContentAssetPublisherCustomizer
extends DefaultAssetPublisherCustomizer {
    @Override
    public Integer getDelta(HttpServletRequest request) {
        PortletPreferences portletPreferences = this.getPortletPreferences(request);
        return GetterUtil.getInteger((String)portletPreferences.getValue("delta", null), (int)PropsValues.RECENT_CONTENT_MAX_DISPLAY_ITEMS);
    }

    @Override
    public String getPortletId() {
        return "com_liferay_asset_publisher_web_portlet_RecentContentPortlet";
    }

    @Override
    public boolean isEnablePermissions(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isOrderingAndGroupingEnabled(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isOrderingByTitleEnabled(HttpServletRequest request) {
        return this.assetPublisherWebConfiguration.searchWithIndex();
    }

    @Override
    public boolean isSelectionStyleEnabled(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowAssetEntryQueryProcessor(AssetEntryQueryProcessor assetEntryQueryProcessor) {
        return true;
    }

    @Override
    public boolean isShowEnableAddContentButton(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowEnableRelatedAssets(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowScopeSelector(HttpServletRequest request) {
        return true;
    }

    @Override
    public boolean isShowSubtypeFieldsFilter(HttpServletRequest request) {
        return true;
    }

    @Override
    public void setAssetEntryQueryOptions(AssetEntryQuery assetEntryQuery, HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletPreferences portletPreferences = this.getPortletPreferences(request);
        long[] groupIds = AssetPublisherUtil.getGroupIds(portletPreferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout());
        assetEntryQuery.setGroupIds(groupIds);
    }
}

