Liferay.Loader.define("asset-publisher-web@2.0.7/js/AutoField.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', './AutoField.soy', './CategorySelector.es', './TagSelector.es'], function (exports, _component, _Soy, _AutoField) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.AutoField = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _AutoField2 = _interopRequireDefault(_AutoField);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var DEFAULT_RULE = {
		queryContains: true,
		type: 'assetTags'
	};

	/**
  * AutoField
  *
  */

	var AutoField = function (_Component) {
		_inherits(AutoField, _Component);

		function AutoField() {
			_classCallCheck(this, AutoField);

			return _possibleConstructorReturn(this, (AutoField.__proto__ || Object.getPrototypeOf(AutoField)).apply(this, arguments));
		}

		_createClass(AutoField, [{
			key: 'created',
			value: function created() {
				this.on('rulesChanged', this.onRulesChanged_);
			}
		}, {
			key: 'addRule_',
			value: function addRule_() {
				this.rules = this.rules.concat(DEFAULT_RULE);
			}
		}, {
			key: 'changeSelector_',
			value: function changeSelector_(event) {
				var itemIndex = event.delegateTarget.getAttribute('data-item-index');
				var rules = this.rules;

				rules[itemIndex] = {
					queryAndOperator: 'all',
					queryContains: true,
					type: event.target.value
				};

				this.rules = rules;
			}
		}, {
			key: 'deleteRule_',
			value: function deleteRule_(event) {
				var itemIndex = event.delegateTarget.getAttribute('data-rule-id');
				var list = this.rules;

				list.splice(itemIndex, 1);

				this.rules = this.rules;
			}
		}, {
			key: 'onRulesChanged_',
			value: function onRulesChanged_() {
				this.queryLogicIndexes = Object.keys(this.rules).toString();
			}
		}]);

		return AutoField;
	}(_component2.default);

	AutoField.STATE = {

		/**
   * Array of rules being rendered as children. Each rule
   * represents a step on the filtering process, being either
   * a TagSelector or a CategorySelector.
   * @type {array}
   */

		rules: {
			value: [DEFAULT_RULE]
		},

		/**
   * Array of group (sites) ids where the information is going
   * to be fetched. This parementer is passed by to the child
   * components being rendered as rules.
   */

		groupIds: {
			value: []
		},

		/**
   * List of indices (rules) that must be sent to the server.
   * @see onRulesChanged_ method por more information.
   */

		queryLogicIndexes: {
			value: '0'
		}
	};

	_Soy2.default.register(AutoField, _AutoField2.default);

	exports.AutoField = AutoField;
	exports.default = AutoField;
});
//# sourceMappingURL=AutoField.es.js.map
