Liferay.Loader.define("asset-publisher-web@2.0.7/js/CategorySelector.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-state/src/all/state', './CategorySelector.soy'], function (exports, _component, _Soy, _state, _CategorySelector) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.CategorySelector = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _CategorySelector2 = _interopRequireDefault(_CategorySelector);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var CategorySelector = function (_Component) {
		_inherits(CategorySelector, _Component);

		function CategorySelector() {
			_classCallCheck(this, CategorySelector);

			return _possibleConstructorReturn(this, (CategorySelector.__proto__ || Object.getPrototypeOf(CategorySelector)).apply(this, arguments));
		}

		_createClass(CategorySelector, [{
			key: 'onEntriesChanged_',
			value: function onEntriesChanged_() {
				this.rule.categoryIdsTitles = this.categoriesSelector_.entries.values.map(function (element) {
					return element.value;
				});
				this.rule.queryValues = this.categoriesSelector_.entries.keys.join(',');
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				AUI().use('liferay-asset-taglib-categories-selector', function (A) {
					var config = {
						categoryIds: this.rule.queryValues || '',
						categoryTitles: this.rule.categoryIdsTitles || [],
						contentBox: this.element,
						eventName: this.eventName,
						groupIds: this.groupIds,
						hiddenInput: '#' + this.refs.hiddenInput.getAttribute('id'),
						portletURL: this.categorySelectorURL,
						vocabularyIds: this.vocabularyIds
					};

					this.categoriesSelector_ = new Liferay.AssetTaglibCategoriesSelector(config);

					var entries = this.categoriesSelector_.entries;

					entries.after('add', this.onEntriesChanged_, this);
					entries.after('remove', this.onEntriesChanged_, this);

					this.categoriesSelector_.render();
					this.element.parentNode.removeAttribute('tabindex');
				}.bind(this));
			}
		}]);

		return CategorySelector;
	}(_component2.default);

	CategorySelector.STATE = {

		/**
   * Number used for avoiding conflicts between different
   * instances of the component/portlet.
   */

		index: _state.Config.number().value(0),

		/**
   * String used for avoiding conflicts between different
   * instances of the component/portlet.
   */

		namespace: _state.Config.string().value(''),

		/**
   * Portlet ID used for selecting categories.
   * For this component it's required because is the only way
   * to select categories.
   */

		categorySelectorURL: _state.Config.string().value(''),

		/**
   * Name of the event that will be dispatched when the
   * category selector dialog is closed
   */

		eventName: _state.Config.string().value(''),

		/**
   * Array of group ids (sites) where categories will be searched.
   * It defaults to an empty array, which is the current site.
   */

		groupIds: _state.Config.string().value(''),

		/**
   * Id of the hidden input used to pass the selected categories
   */

		hiddenInput: _state.Config.string().value(''),

		/**
   * Existing information of the form.
   * @prop {string[]} queryValues Categories that are already selected.
   *  This property is updated as the user selects new categories.
   * @prop {string[]} categoryIdsTitles Titles of the categories that are
   * 	already selected. It is kept in sync with `queryValues`
   */

		rule: _state.Config.object().value({}),

		/**
   * Ids of the vocabularies parents of the selected categories.
   * Vocabularies are super groups which group a set of categories.
   */

		vocabularyIds: _state.Config.string().value('')
	};

	_Soy2.default.register(CategorySelector, _CategorySelector2.default);

	exports.CategorySelector = CategorySelector;
	exports.default = CategorySelector;
});
//# sourceMappingURL=CategorySelector.es.js.map
