Liferay.Loader.define("asset-publisher-web@2.0.7/js/TagSelector.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-state/src/all/state', './TagSelector.soy'], function (exports, _component, _Soy, _state, _TagSelector) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.TagSelector = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _TagSelector2 = _interopRequireDefault(_TagSelector);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var TagSelector = function (_Component) {
		_inherits(TagSelector, _Component);

		function TagSelector() {
			_classCallCheck(this, TagSelector);

			return _possibleConstructorReturn(this, (TagSelector.__proto__ || Object.getPrototypeOf(TagSelector)).apply(this, arguments));
		}

		_createClass(TagSelector, [{
			key: 'focusTagInput_',
			value: function focusTagInput_() {
				this.refs.tagInput.focus();
			}
		}, {
			key: 'onEntriesChanged_',
			value: function onEntriesChanged_() {
				this.rule.queryValues = this.tagsSelector_.entries.keys.join();
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				this.element.addEventListener('click', this.focusTagInput_.bind(this));

				AUI().use('liferay-asset-taglib-tags-selector', function (A) {
					var config = {
						allowAddEntry: true,
						contentBox: this.element,
						eventName: this.eventName,
						groupIds: this.groupIds,
						hiddenInput: '#' + this.refs.hiddenInput.getAttribute('id'),
						input: '#' + this.refs.tagInput.getAttribute('id'),
						portletURL: this.tagSelectorURL,
						tagNames: this.rule.queryValues || ''
					};

					this.tagsSelector_ = new Liferay.AssetTaglibTagsSelector(config);

					var entries = this.tagsSelector_.entries;

					entries.after('add', this.onEntriesChanged_, this);
					entries.after('remove', this.onEntriesChanged_, this);

					this.tagsSelector_.render();
					this.element.parentNode.removeAttribute('tabindex');
				}.bind(this));
			}
		}]);

		return TagSelector;
	}(_component2.default);

	TagSelector.STATE = {

		/**
   * Number used for avoiding conflicts between different
   * instances of the component/portlet.
   */

		index: _state.Config.number().value(0),

		/**
   * String used for avoiding conflicts between different
   * instances of the component/portlet.
   */

		namespace: _state.Config.string().value(''),

		/**
   * Name of the event that will be fired when the tag selector dialog
   * request being closed
   */

		eventName: _state.Config.string().value(''),

		/**
   * Array of group ids (sites) where tags will be searched.
   * It defaults to an empty array, which is the current site.
   */

		groupIds: _state.Config.string().value(''),

		/**
   * Id of the hidden input used to pass the selected tags
   */

		hiddenInput: _state.Config.string().value(''),

		/**
   * Existing information of the form.
   * Currently only rule.queryValues is present.
   * @prop {string[]} queryValues Tags that are already selected.
   *  This property is updated as the user selects new tags.
   */

		rule: _state.Config.object().value({}),

		/**
   * When specified, this porlet (found for the given ID) will
   * be used for tag selection as a popup. If no ID is given,
   * the select button will not appear.
   */

		tagSelectorURL: _state.Config.string().value('')
	};

	_Soy2.default.register(TagSelector, _TagSelector2.default);

	exports.TagSelector = TagSelector;
	exports.default = TagSelector;
});
//# sourceMappingURL=TagSelector.es.js.map
