Liferay.Loader.define("asset-publisher-web@3.0.108/js/AutoField.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './AutoField.soy', 'asset-taglib/asset_categories_selector/AssetCategoriesSelector.es', 'asset-taglib/asset_tags_selector/AssetTagsSelector.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AutoField = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _AutoField = _interopRequireDefault(require("./AutoField.soy"));

  require("asset-taglib/asset_categories_selector/AssetCategoriesSelector.es");

  require("asset-taglib/asset_tags_selector/AssetTagsSelector.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * AutoField
   *
   */
  var AutoField = /*#__PURE__*/function (_Component) {
    _inherits(AutoField, _Component);

    function AutoField() {
      _classCallCheck(this, AutoField);

      return _possibleConstructorReturn(this, _getPrototypeOf(AutoField).apply(this, arguments));
    }

    _createClass(AutoField, [{
      key: "created",

      /**
       * @inheritDoc
       */
      value: function created() {
        this.on('rulesChanged', this.onRulesChanged_);
        this.onRulesChanged_();
      }
      /**
       * Adds a new rule of type Tags (by default) to the current list of rules.
       * @protected
       */

    }, {
      key: "addRule_",
      value: function addRule_() {
        this.rules = this.rules.concat({
          queryContains: true,
          selectedItems: [],
          type: 'assetTags'
        });
      }
      /**
       * Updates a given rule when the user changes the type of selection (from Tags
       * to Categories) that wants to apply to it
       * @param {Event} event
       * @protected
       */

    }, {
      key: "changeSelector_",
      value: function changeSelector_(event) {
        var itemIndex = event.delegateTarget.getAttribute('data-item-index');
        var rules = this.rules;
        rules[itemIndex] = {
          queryAndOperator: 'all',
          queryContains: true,
          selectedItems: [],
          type: event.target.value
        };
        this.rules = rules;
      }
      /**
       * Deletes a rule from the current list. This change can not be undone. Changes
       * made to the deleted rule will be lost.
       * @param {Event} event
       * @protected
       */

    }, {
      key: "deleteRule_",
      value: function deleteRule_(event) {
        var itemIndex = event.delegateTarget.getAttribute('data-rule-id');
        var list = this.rules;
        list.splice(itemIndex, 1);
        this.rules = this.rules;
      }
      /**
       * Updates the queryLogicIndexes whenever the list of rules change. The value
       * of this property is as follow:
       * - rules: [{}, {}, {}]
       * - queryLogicIndexes: "0,1,2";
       */

    }, {
      key: "onRulesChanged_",
      value: function onRulesChanged_() {
        this.queryLogicIndexes = Object.keys(this.rules).toString();
      }
    }, {
      key: "onSelectedItemsChange_",
      value: function onSelectedItemsChange_(data, event) {
        var targetId = event.target.id;
        var itemIndex = targetId.replace(this.namespace + 'assetSelector', '');
        var rule = this.rules[itemIndex];
        rule.selectedItems = data.selectedItems;
      }
    }]);

    return AutoField;
  }(_metalComponent["default"]);

  exports.AutoField = AutoField;
  AutoField.STATE = {
    /**
     * Array of group (sites) ids where the information is going
     * to be fetched. This parementer is passed by to the child
     * components being rendered as rules.
     */
    groupIds: {
      value: []
    },

    /**
     * List of indices (rules) that must be sent to the server.
     * @see onRulesChanged_ method por more information.
     */
    queryLogicIndexes: {
      value: '0'
    },

    /**
     * Array of rules being rendered as children. Each rule
     * represents a step on the filtering process, being either
     * a TagSelector or a CategorySelector.
     * @type {array}
     */
    rules: {
      value: [{
        queryContains: true,
        selectedItems: [],
        type: 'assetTags'
      }]
    }
  };

  _metalSoy["default"].register(AutoField, _AutoField["default"]);

  var _default = AutoField;
  exports["default"] = _default;
  //# sourceMappingURL=AutoField.es.js.map
});
//# sourceMappingURL=AutoField.es.js.map