/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.service.impl;

import com.liferay.batch.planner.batch.engine.task.TaskItemUtil;
import com.liferay.batch.planner.constants.BatchPlannerPlanConstants;
import com.liferay.batch.planner.exception.BatchPlannerPlanExternalTypeException;
import com.liferay.batch.planner.exception.BatchPlannerPlanInternalClassNameException;
import com.liferay.batch.planner.exception.BatchPlannerPlanNameException;
import com.liferay.batch.planner.exception.DuplicateBatchPlannerPlanException;
import com.liferay.batch.planner.exception.RequiredBatchPlannerPlanException;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.base.BatchPlannerPlanLocalServiceBaseImpl;
import com.liferay.batch.planner.service.persistence.BatchPlannerMappingPersistence;
import com.liferay.batch.planner.service.persistence.BatchPlannerPolicyPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(property={"model.class.name=com.liferay.batch.planner.model.BatchPlannerPlan"}, service={AopService.class})
public class BatchPlannerPlanLocalServiceImpl
extends BatchPlannerPlanLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BatchPlannerPlanLocalServiceImpl.class);
    @Reference
    private BatchPlannerMappingPersistence _batchPlannerMappingPersistence;
    @Reference
    private BatchPlannerPolicyPersistence _batchPlannerPolicyPersistence;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public BatchPlannerPlan addBatchPlannerPlan(long userId, boolean export, String externalType, String externalURL, String internalClassName, String name, int size, String taskItemDelegateName, boolean template) throws PortalException {
        this._validateExternalType(externalType);
        this._validateInternalClassName(internalClassName);
        if (Validator.isNull((String)name) && !template) {
            name = this._generateName(internalClassName, taskItemDelegateName);
        }
        User user = this._userLocalService.getUser(userId);
        this._validateName(0L, user.getCompanyId(), name, template);
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.create(this.counterLocalService.increment());
        batchPlannerPlan.setCompanyId(user.getCompanyId());
        batchPlannerPlan.setUserId(userId);
        batchPlannerPlan.setUserName(user.getFullName());
        batchPlannerPlan.setActive(true);
        batchPlannerPlan.setExport(export);
        batchPlannerPlan.setExternalType(externalType);
        batchPlannerPlan.setExternalURL(externalURL);
        batchPlannerPlan.setInternalClassName(internalClassName);
        batchPlannerPlan.setName(name);
        batchPlannerPlan.setSize(size);
        batchPlannerPlan.setTaskItemDelegateName(taskItemDelegateName);
        batchPlannerPlan.setTemplate(template);
        batchPlannerPlan = (BatchPlannerPlan)this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
        this._resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), BatchPlannerPlan.class.getName(), batchPlannerPlan.getBatchPlannerPlanId(), false, true, false);
        return batchPlannerPlan;
    }

    public void deactivateBatchPlannerPlan(String batchEngineTaskERC) {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)batchEngineTaskERC));
        if (batchPlannerPlan == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to update batch planner plan for batch engine ", "task ERC ", batchEngineTaskERC}));
            }
            return;
        }
        batchPlannerPlan.setActive(false);
        this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
    }

    @Override
    public BatchPlannerPlan deleteBatchPlannerPlan(BatchPlannerPlan batchPlannerPlan) throws PortalException {
        return this.deleteBatchPlannerPlan(batchPlannerPlan.getBatchPlannerPlanId());
    }

    @Override
    public BatchPlannerPlan deleteBatchPlannerPlan(long batchPlannerPlanId) throws PortalException {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.remove(batchPlannerPlanId);
        this._resourceLocalService.deleteResource((AuditedModel)batchPlannerPlan, 4);
        this._batchPlannerMappingPersistence.removeByBatchPlannerPlanId(batchPlannerPlanId);
        this._batchPlannerPolicyPersistence.removeByBatchPlannerPlanId(batchPlannerPlanId);
        return batchPlannerPlan;
    }

    public BatchPlannerPlan updateBatchPlannerPlan(long batchPlannerPlanId, String externalType, String internalClassName, String name) throws PortalException {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.findByPrimaryKey(batchPlannerPlanId);
        if (!batchPlannerPlan.isTemplate()) {
            throw new RequiredBatchPlannerPlanException("Batch planner plan is not a template");
        }
        this._validateName(batchPlannerPlanId, batchPlannerPlan.getCompanyId(), name, true);
        batchPlannerPlan.setExternalType(externalType);
        batchPlannerPlan.setInternalClassName(internalClassName);
        batchPlannerPlan.setName(name);
        return (BatchPlannerPlan)this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
    }

    public BatchPlannerPlan updateStatus(long batchPlannerPlanId, int status) throws PortalException {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.findByPrimaryKey(batchPlannerPlanId);
        batchPlannerPlan.setStatus(status);
        return (BatchPlannerPlan)this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
    }

    private String _generateName(String internalClassName, String taskItemDelegateName) {
        String simpleClassName = TaskItemUtil.getSimpleClassName((String)TaskItemUtil.getInternalClassNameKey((String)internalClassName, (String)taskItemDelegateName));
        return simpleClassName + " Plan Execution " + System.currentTimeMillis();
    }

    private void _validateExternalType(String externalType) throws PortalException {
        if (ArrayUtil.contains((Object[])BatchPlannerPlanConstants.EXTERNAL_TYPES, (Object)externalType)) {
            return;
        }
        String merge = StringUtil.merge((String[])BatchPlannerPlanConstants.EXTERNAL_TYPES, (String)",");
        throw new BatchPlannerPlanExternalTypeException("Batch planner plan external type must be one of following: " + merge);
    }

    private void _validateInternalClassName(String internalClassName) throws PortalException {
        if (Validator.isNull((String)internalClassName)) {
            throw new BatchPlannerPlanInternalClassNameException();
        }
    }

    private void _validateName(long batchPlannerPlanId, long companyId, String name, boolean template) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new BatchPlannerPlanNameException("Batch planner plan name is null");
        }
        int maxLength = ModelHintsUtil.getMaxLength((String)BatchPlannerPlan.class.getName(), (String)"name");
        if (name.length() > maxLength) {
            throw new BatchPlannerPlanNameException("Batch planner plan name must not be longer than " + maxLength);
        }
        if (!template) {
            return;
        }
        List batchPlannerPlans = this.batchPlannerPlanPersistence.findByC_T(companyId, template);
        for (BatchPlannerPlan batchPlannerPlan : batchPlannerPlans) {
            if (batchPlannerPlan.getBatchPlannerPlanId() == batchPlannerPlanId || !Objects.equals(name, batchPlannerPlan.getName())) continue;
            throw new DuplicateBatchPlannerPlanException(StringBundler.concat((Object[])new Object[]{"Batch planner plan name \"", name, "\" already exists for company ", companyId}));
        }
    }
}

