/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.layout.prototype.internal.instance.lifecycle;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.DefaultLayoutPrototypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddLayoutPrototypePortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        long defaultUserId = this._userLocalService.getDefaultUserId(company.getCompanyId());
        List layoutPrototypes = this._layoutPrototypeLocalService.search(company.getCompanyId(), null, -1, -1, null);
        this.addBlogPage(company.getCompanyId(), defaultUserId, layoutPrototypes);
    }

    protected void addBlogPage(long companyId, long defaultUserId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleUtil.getResourceBundleLoader((String)"content.Language", (ClassLoader)this.getClassLoader()), LanguageResources.RESOURCE_BUNDLE_LOADER});
        Map descriptionMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, (String)"layout-prototype-blog-description");
        Map nameMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, (String)"layout-prototype-blog-title");
        Layout layout = DefaultLayoutPrototypesUtil.addLayoutPrototype((long)companyId, (long)defaultUserId, (Map)nameMap, (Map)descriptionMap, (String)"2_columns_iii", layoutPrototypes);
        if (layout == null) {
            return;
        }
        DefaultLayoutPrototypesUtil.addPortletId((Layout)layout, (String)"com_liferay_blogs_web_portlet_BlogsPortlet", (String)"column-1");
        String portletId = DefaultLayoutPrototypesUtil.addPortletId((Layout)layout, (String)"com_liferay_asset_tags_navigation_web_portlet_AssetTagsCloudPortlet", (String)"column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("classNameId", String.valueOf(this._portal.getClassNameId(BlogsEntry.class)));
        preferences.put("showAssetCount", Boolean.TRUE.toString());
        DefaultLayoutPrototypesUtil.updatePortletSetup((Layout)layout, (String)portletId, preferences);
        DefaultLayoutPrototypesUtil.addPortletId((Layout)layout, (String)"com_liferay_blogs_recent_bloggers_web_portlet_RecentBloggersPortlet", (String)"column-2");
    }

    @Reference(target="(javax.portlet.name=com_liferay_asset_tags_navigation_web_portlet_AssetTagsCloudPortlet)", unbind="-")
    protected void setAssetTagsCloudPortlet(Portlet portlet) {
    }

    @Reference(target="(javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet)", unbind="-")
    protected void setBlogsPortlet(Portlet portlet) {
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeLocalService(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(target="(javax.portlet.name=com_liferay_blogs_recent_bloggers_web_portlet_RecentBloggersPortlet)", unbind="-")
    protected void setRecentBloggersPortlet(Portlet portlet) {
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

