/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.uad.anonymizer;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.blogs.uad.constants.BlogsUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseBlogsEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<BlogsEntry> {
    @Reference
    protected BlogsEntryLocalService blogsEntryLocalService;

    public void autoAnonymize(BlogsEntry blogsEntry, long userId, User anonymousUser) throws PortalException {
        if (blogsEntry.getUserId() == userId) {
            blogsEntry.setUserId(anonymousUser.getUserId());
            blogsEntry.setUserName(anonymousUser.getFullName());
        }
        if (blogsEntry.getStatusByUserId() == userId) {
            blogsEntry.setStatusByUserId(anonymousUser.getUserId());
            blogsEntry.setStatusByUserName(anonymousUser.getFullName());
        }
        this.blogsEntryLocalService.updateBlogsEntry(blogsEntry);
    }

    public void delete(BlogsEntry blogsEntry) throws PortalException {
        this.blogsEntryLocalService.deleteBlogsEntry(blogsEntry);
    }

    public Class<BlogsEntry> getTypeClass() {
        return BlogsEntry.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.blogsEntryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return BlogsUADConstants.USER_ID_FIELD_NAMES_BLOGS_ENTRY;
    }
}

