/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BlogImagesDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(BlogImagesDisplayContext.class);
    private final LiferayPortletRequest _liferayPortletRequest;
    private final HttpServletRequest _request;

    public BlogImagesDisplayContext(LiferayPortletRequest liferayPortletRequest) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._request = this._liferayPortletRequest.getHttpServletRequest();
    }

    public void populateResults(SearchContainer searchContainer) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Folder attachmentsFolder = BlogsEntryLocalServiceUtil.addAttachmentsFolder((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId());
        int total = 0;
        ArrayList<FileEntry> results = null;
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNull((String)keywords)) {
            total = PortletFileRepositoryUtil.getPortletFileEntriesCount((long)themeDisplay.getScopeGroupId(), (long)attachmentsFolder.getFolderId());
            searchContainer.setTotal(total);
            results = PortletFileRepositoryUtil.getPortletFileEntries((long)themeDisplay.getScopeGroupId(), (long)attachmentsFolder.getFolderId(), (int)0, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
            searchContainer.setResults((List)results);
        } else {
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
            searchContext.setEnd(searchContainer.getEnd());
            searchContext.setFolderIds(new long[]{attachmentsFolder.getFolderId()});
            searchContext.setStart(searchContainer.getStart());
            String orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"title");
            String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
            Sort sort = new Sort(orderByCol, !StringUtil.equalsIgnoreCase((String)orderByType, (String)"asc"));
            searchContext.setSorts(new Sort[]{sort});
            Folder folder = DLAppLocalServiceUtil.getFolder((long)attachmentsFolder.getFolderId());
            Hits hits = PortletFileRepositoryUtil.searchPortletFileEntries((long)folder.getRepositoryId(), (SearchContext)searchContext);
            total = hits.getLength();
            Document[] docs = hits.getDocs();
            results = new ArrayList<FileEntry>();
            for (Document doc : docs) {
                long fileEntryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
                FileEntry fileEntry = null;
                try {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
                    results.add(fileEntry);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Documents and Media search index is stale ", "and contains file entry ", fileEntryId}));
                }
            }
            searchContainer.setTotal(total);
            searchContainer.setResults(results);
        }
    }
}

