/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BlogImagesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;

    public BlogImagesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request, PortletURL currentURLObj) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._currentURLObj = currentURLObj;
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteImages");
                    dropdownItem.setIcon("times");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public String getDisplayStyle() {
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = this._portalPreferences.getValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "images-display-style", "icon");
        } else {
            this._portalPreferences.setValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "images-display-style", displayStyle);
            this._request.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        return displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(BlogImagesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"title");
    }

    public String getOrderByType() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"desc");
    }

    public String getSearchActionURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/blogs/view");
        searchURL.setParameter("navigation", "images");
        searchURL.setParameter("orderByCol", this.getOrderByCol());
        searchURL.setParameter("orderByType", this.getOrderByType());
        return searchURL.toString();
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public ViewTypeItemList getViewTypes() {
        String keywords;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view");
        portletURL.setParameter("navigation", "images");
        int delta = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"delta");
        if (delta > 0) {
            portletURL.setParameter("delta", String.valueOf(delta));
        }
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        int cur = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"cur");
        if (cur > 0) {
            portletURL.setParameter("cur", String.valueOf(cur));
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("cur", "0");
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            sortingURL.setParameter("keywords", keywords);
        }
        return sortingURL;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive("title".equals(BlogImagesManagementToolbarDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(BlogImagesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "title"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._request, (String)"title"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive("size".equals(BlogImagesManagementToolbarDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(BlogImagesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "size"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._request, (String)"size"));
                }));
            }
        };
    }
}

