/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.blogs.exception.EntryContentException;
import com.liferay.blogs.exception.EntryCoverImageCropException;
import com.liferay.blogs.exception.EntryDescriptionException;
import com.liferay.blogs.exception.EntryDisplayDateException;
import com.liferay.blogs.exception.EntrySmallImageNameException;
import com.liferay.blogs.exception.EntrySmallImageScaleException;
import com.liferay.blogs.exception.EntryTitleException;
import com.liferay.blogs.exception.EntryUrlTitleException;
import com.liferay.blogs.exception.NoSuchEntryException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.blogs.web.internal.util.BlogsEntryImageSelectorHelper;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.friendly.url.exception.DuplicateFriendlyURLEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.service.TrashEntryService;
import com.liferay.upload.AttachmentContentUpdater;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet", "mvc.command.name=/blogs/edit_entry"}, service={MVCActionCommand.class})
public class EditEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditEntryMVCActionCommand.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AttachmentContentUpdater _attachmentContentUpdater;
    private BlogsEntryLocalService _blogsEntryLocalService;
    private BlogsEntryService _blogsEntryService;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    private TrashEntryService _trashEntryService;

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteEntryIds = null;
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        deleteEntryIds = entryId > 0L ? new long[]{entryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteEntryIds"), (long)0L);
        ArrayList<BlogsEntry> trashedModels = new ArrayList<BlogsEntry>();
        for (long deleteEntryId : deleteEntryIds) {
            if (moveToTrash) {
                BlogsEntry entry = this._blogsEntryService.moveEntryToTrash(deleteEntryId);
                trashedModels.add(entry);
                continue;
            }
            this._blogsEntryService.deleteEntry(deleteEntryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<BlogsEntry>> data = new HashMap<String, ArrayList<BlogsEntry>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BlogsEntry entry = null;
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            if (cmd.equals("add") || cmd.equals("update")) {
                UpdateEntryCallable updateEntryCallable = new UpdateEntryCallable(actionRequest);
                entry = (BlogsEntry)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)updateEntryCallable);
            } else if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribe(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribe(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            String portletId = this._http.getParameter(redirect, "p_p_id", false);
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)2);
            boolean ajax = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ajax");
            if (ajax) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("attributeDataImageId", "data-image-id");
                jsonObject.put("content", entry.getContent());
                jsonObject.put("coverImageFileEntryId", entry.getCoverImageFileEntryId());
                jsonObject.put("entryId", entry.getEntryId());
                jsonObject.put("redirect", redirect);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
                return;
            }
            if (entry != null && workflowAction == 2) {
                redirect = this.getSaveAndContinueRedirect(actionRequest, entry, redirect);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                String namespace;
                WindowState windowState = actionRequest.getWindowState();
                if (Validator.isNotNull((String)redirect) && cmd.equals("update")) {
                    namespace = actionResponse.getNamespace();
                    redirect = this._http.setParameter(redirect, namespace + "redirectToLastFriendlyURL", false);
                }
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (Validator.isNotNull((String)(redirect = this._portal.escapeRedirect(redirect)))) {
                    if (cmd.equals("add") && entry != null) {
                        namespace = this._portal.getPortletNamespace(portletId);
                        redirect = this._http.addParameter(redirect, namespace + "className", BlogsEntry.class.getName());
                        redirect = this._http.addParameter(redirect, namespace + "classPK", entry.getEntryId());
                    }
                    actionRequest.setAttribute("REDIRECT", (Object)redirect);
                }
            }
        }
        catch (AssetCategoryException | AssetTagException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            actionResponse.setRenderParameter("mvcRenderCommandName", "/blogs/edit_entry");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        catch (EntryContentException | EntryCoverImageCropException | EntryDescriptionException | EntryDisplayDateException | EntrySmallImageNameException | EntrySmallImageScaleException | EntryTitleException | EntryUrlTitleException | FileSizeException | DuplicateFriendlyURLEntryException | SanitizerException | LiferayFileItemException | UploadRequestSizeException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcRenderCommandName", "/blogs/edit_entry");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        catch (NoSuchEntryException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/blogs/error.jsp");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
            actionResponse.setRenderParameter("mvcPath", "/blogs/error.jsp");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, BlogsEntry entry, String redirect) throws Exception {
        PortletConfig portletConfig = (PortletConfig)actionRequest.getAttribute("javax.portlet.config");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/blogs/edit_entry");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("groupId", String.valueOf(entry.getGroupId()), false);
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryService(BlogsEntryService blogsEntryService) {
        this._blogsEntryService = blogsEntryService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected void subscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._blogsEntryService.subscribe(themeDisplay.getScopeGroupId());
    }

    protected void unsubscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._blogsEntryService.unsubscribe(themeDisplay.getScopeGroupId());
    }

    protected BlogsEntry updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String subtitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"subtitle");
        String urlTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"urlTitle");
        String description = "";
        boolean customAbstract = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"customAbstract");
        if (customAbstract && Validator.isNull((String)(description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description")))) {
            throw new EntryDescriptionException();
        }
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        int displayDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
        boolean allowTrackbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowTrackbacks");
        String[] trackbacks = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"trackbacks"));
        long coverImageFileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"coverImageFileEntryId");
        String coverImageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"coverImageURL");
        String coverImageFileEntryCropRegion = ParamUtil.getString((PortletRequest)actionRequest, (String)"coverImageFileEntryCropRegion");
        String coverImageCaption = ParamUtil.getString((PortletRequest)actionRequest, (String)"coverImageCaption");
        long oldCoverImageFileEntryId = 0L;
        String oldCoverImageURL = "";
        long oldSmallImageFileEntryId = 0L;
        long oldSmallImageId = 0L;
        String oldSmallImageURL = "";
        if (entryId != 0L) {
            BlogsEntry entry = this._blogsEntryLocalService.getEntry(entryId);
            oldCoverImageFileEntryId = entry.getCoverImageFileEntryId();
            oldCoverImageURL = entry.getCoverImageURL();
            oldSmallImageFileEntryId = entry.getSmallImageFileEntryId();
            oldSmallImageId = entry.getSmallImageId();
            oldSmallImageURL = entry.getSmallImageURL();
        }
        BlogsEntryImageSelectorHelper blogsEntryCoverImageSelectorHelper = new BlogsEntryImageSelectorHelper(0L, coverImageFileEntryId, oldCoverImageFileEntryId, coverImageFileEntryCropRegion, coverImageURL, oldCoverImageURL);
        ImageSelector coverImageImageSelector = blogsEntryCoverImageSelectorHelper.getImageSelector();
        long smallImageFileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"smallImageFileEntryId");
        String smallImageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"smallImageURL");
        BlogsEntryImageSelectorHelper blogsEntrySmallImageSelectorHelper = new BlogsEntryImageSelectorHelper(oldSmallImageId, smallImageFileEntryId, oldSmallImageFileEntryId, "", smallImageURL, oldSmallImageURL);
        ImageSelector smallImageImageSelector = blogsEntrySmallImageSelectorHelper.getImageSelector();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BlogsEntry.class.getName(), (PortletRequest)actionRequest);
        BlogsEntry entry = null;
        if (entryId <= 0L) {
            entry = this._blogsEntryService.addEntry(title, subtitle, urlTitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
            String updatedContent = this._updateContent(entry, content, themeDisplay);
            if (!content.equals(updatedContent)) {
                entry.setContent(updatedContent);
                this._blogsEntryLocalService.updateBlogsEntry(entry);
            }
        } else {
            boolean sendEmailEntryUpdated = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"sendEmailEntryUpdated");
            serviceContext.setAttribute("sendEmailEntryUpdated", (Serializable)Boolean.valueOf(sendEmailEntryUpdated));
            String emailEntryUpdatedComment = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEntryUpdatedComment");
            serviceContext.setAttribute("emailEntryUpdatedComment", (Serializable)((Object)emailEntryUpdatedComment));
            entry = this._blogsEntryLocalService.getEntry(entryId);
            content = this._updateContent(entry, content, themeDisplay);
            entry = this._blogsEntryService.updateEntry(entryId, title, subtitle, urlTitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
        }
        if (blogsEntryCoverImageSelectorHelper.isFileEntryTempFile()) {
            this._blogsEntryLocalService.addOriginalImageFileEntry(themeDisplay.getUserId(), entry.getGroupId(), entry.getEntryId(), coverImageImageSelector);
            PortletFileRepositoryUtil.deletePortletFileEntry((long)coverImageFileEntryId);
        }
        if (blogsEntrySmallImageSelectorHelper.isFileEntryTempFile()) {
            this._blogsEntryLocalService.addOriginalImageFileEntry(themeDisplay.getUserId(), entry.getGroupId(), entry.getEntryId(), smallImageImageSelector);
            PortletFileRepositoryUtil.deletePortletFileEntry((long)smallImageFileEntryId);
        }
        return entry;
    }

    private String _updateContent(BlogsEntry entry, String content, ThemeDisplay themeDisplay) throws PortalException {
        return this._attachmentContentUpdater.updateContent(content, "text/html", tempFileEntry -> this._blogsEntryLocalService.addAttachmentFileEntry(entry, themeDisplay.getUserId(), tempFileEntry.getTitle(), tempFileEntry.getMimeType(), tempFileEntry.getContentStream()));
    }

    private class UpdateEntryCallable
    implements Callable<BlogsEntry> {
        private final ActionRequest _actionRequest;

        @Override
        public BlogsEntry call() throws Exception {
            return EditEntryMVCActionCommand.this.updateEntry(this._actionRequest);
        }

        private UpdateEntryCallable(ActionRequest actionRequest) {
            this._actionRequest = actionRequest;
        }
    }
}

