/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.exception.NoSuchEntryException;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "mvc.command.name=/blogs/edit_image"}, service={MVCActionCommand.class})
public class EditImageMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditImageMVCActionCommand.class);
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference(target="(resource.name=com.liferay.blogs)")
    private PortletResourcePermission _portletResourcePermission;

    protected void deleteImages(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] deleteFileEntryIds = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        deleteFileEntryIds = fileEntryId > 0L ? new long[]{fileEntryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteFileEntryIds"), (long)0L);
        Folder folder = this._blogsEntryLocalService.addAttachmentsFolder(themeDisplay.getUserId(), themeDisplay.getScopeGroupId());
        for (long deleteFileEntryId : deleteFileEntryIds) {
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)deleteFileEntryId);
            if (fileEntry.getFolderId() != folder.getFolderId() || fileEntry.getUserId() != themeDisplay.getUserId() && !this._portletResourcePermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup(), "UPDATE")) continue;
            PortletFileRepositoryUtil.deletePortletFileEntry((long)deleteFileEntryId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteImages(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/blogs/error.jsp");
            }
            throw e;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
            actionResponse.setRenderParameter("mvcPath", "/blogs/error.jsp");
        }
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }
}

