/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.InputStream;

public class BlogsEntryImageSelectorHelper {
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryImageSelectorHelper.class);
    private Boolean _fileEntryTempFile;
    private final String _imageCropRegion;
    private final long _imageFileEntryId;
    private final String _imageURL;
    private final long _oldImageFileEntryId;
    private final String _oldImageURL;
    private final long _oldSmallImageId;

    public BlogsEntryImageSelectorHelper(long oldSmallImageId, long imageFileEntryId, long oldImageFileEntryId, String imageCropRegion, String imageURL, String oldImageURL) {
        this._oldSmallImageId = oldSmallImageId;
        this._imageFileEntryId = imageFileEntryId;
        this._oldImageFileEntryId = oldImageFileEntryId;
        this._imageCropRegion = imageCropRegion;
        this._imageURL = imageURL;
        this._oldImageURL = oldImageURL;
    }

    public ImageSelector getImageSelector() throws Exception {
        if (this._oldSmallImageId != 0L || this._imageFileEntryId != this._oldImageFileEntryId) {
            if (this._imageFileEntryId != 0L) {
                FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)this._imageFileEntryId);
                this._fileEntryTempFile = fileEntry.isRepositoryCapabilityProvided(TemporaryFileEntriesCapability.class);
                return new ImageSelector(FileUtil.getBytes((InputStream)fileEntry.getContentStream()), fileEntry.getFileName(), fileEntry.getMimeType(), this._imageCropRegion);
            }
            return new ImageSelector();
        }
        if (!this._imageURL.equals(this._oldImageURL)) {
            return new ImageSelector(this._imageURL);
        }
        return null;
    }

    public boolean isFileEntryTempFile() {
        if (this._fileEntryTempFile == null) {
            if (this._imageFileEntryId == 0L || this._imageFileEntryId == this._oldImageFileEntryId) {
                this._fileEntryTempFile = false;
            } else {
                try {
                    FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)this._imageFileEntryId);
                    this._fileEntryTempFile = fileEntry.isRepositoryCapabilityProvided(TemporaryFileEntriesCapability.class);
                }
                catch (PortalException pe) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)pe, (Throwable)pe);
                    }
                    return false;
                }
            }
        }
        return this._fileEntryTempFile;
    }
}

