/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.blogs.util.comparator.EntryTitleComparator;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.dao.search.SearchContainerResults;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;

public class BlogsUtil {
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";

    public static int getCommentsCount(BlogsEntry entry) {
        return CommentManagerUtil.getCommentsCount((String)BlogsEntry.class.getName(), (long)entry.getEntryId());
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$BLOGS_ENTRY_CONTENT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-content"));
        definitionTerms.put("[$BLOGS_ENTRY_CREATE_DATE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-date-the-blog-entry-was-created"));
        definitionTerms.put("[$BLOGS_ENTRY_DESCRIPTION$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-description"));
        definitionTerms.put("[$BLOGS_ENTRY_SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-site-where-the-blog-entry-was-created"));
        definitionTerms.put("[$BLOGS_ENTRY_STATUS_BY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-title"));
        definitionTerms.put("[$BLOGS_ENTRY_UPDATE_COMMENT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-comment-of-the-user-who-updated-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_PORTRAIT_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-portrait-url-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-public-site-url-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-url"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-blog"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-blog"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        definitionTerms.put("[$UNSUBSCRIBE_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-url-to-unsubscribe-the-user"));
        return definitionTerms;
    }

    public static Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$BLOGS_ENTRY_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-blog"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-blog"));
        return definitionTerms;
    }

    public static OrderByComparator<BlogsEntry> getOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("display-date") ? new EntryDisplayDateComparator(orderByAsc) : new EntryTitleComparator(orderByAsc);
        return orderByComparator;
    }

    public static SearchContainerResults<AssetEntry> getSearchContainerResults(SearchContainer<?> searchContainer) throws PortalException {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery(BlogsEntry.class.getName(), searchContainer);
        assetEntryQuery.setExcludeZeroViewCount(false);
        assetEntryQuery.setOrderByCol1("publishDate");
        assetEntryQuery.setVisible(Boolean.TRUE);
        int total = AssetEntryServiceUtil.getEntriesCount((AssetEntryQuery)assetEntryQuery);
        assetEntryQuery.setEnd(searchContainer.getEnd());
        assetEntryQuery.setStart(searchContainer.getStart());
        List assetEntries = AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
        return new SearchContainerResults(assetEntries, total);
    }

    public static String getUrlTitle(long entryId, String title) {
        if (title == null) {
            return String.valueOf(entryId);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(entryId) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)title);
        return ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)title);
    }
}

