/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.blogs.web.internal.security.permission.resource.BlogsPermission;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BlogEntriesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;
    private final TrashHelper _trashHelper;

    public BlogEntriesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request, PortletURL currentURLObj, TrashHelper trashHelper) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._currentURLObj = currentURLObj;
        this._trashHelper = trashHelper;
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                ThemeDisplay themeDisplay = (ThemeDisplay)BlogEntriesManagementToolbarDisplayContext.this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    boolean trashEnabled = BlogEntriesManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(themeDisplay.getScopeGroupId());
                    dropdownItem.setIcon(trashEnabled ? "trash" : "times");
                    String label = "delete";
                    if (trashEnabled) {
                        label = "move-to-recycle-bin";
                    }
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)label));
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public CreationMenu getCreationMenu() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!BlogsPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ENTRY")) {
            return null;
        }
        CreationMenu creationMenu = new CreationMenu();
        creationMenu.addDropdownItem(dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/blogs/edit_entry", "redirect", this._currentURLObj.toString()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)"add-blog-entry"));
        });
        return creationMenu;
    }

    public String getDisplayStyle() {
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = this._portalPreferences.getValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "entries-display-style", "icon");
        } else {
            this._portalPreferences.setValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "entries-display-style", displayStyle);
            this._request.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        return displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(BlogEntriesManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                }));
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(BlogEntriesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"title");
    }

    public String getOrderByType() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"desc");
    }

    public String getSearchActionURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/blogs/view");
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"entries");
        searchURL.setParameter("navigation", navigation);
        searchURL.setParameter("orderByCol", this.getOrderByCol());
        searchURL.setParameter("orderByType", this.getOrderByType());
        return searchURL.toString();
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public ViewTypeItemList getViewTypes() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view");
        int delta = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"delta");
        if (delta > 0) {
            portletURL.setParameter("delta", String.valueOf(delta));
        }
        String orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"title");
        String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        portletURL.setParameter("orderBycol", orderByCol);
        portletURL.setParameter("orderByType", orderByType);
        String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation", (String)"all");
        portletURL.setParameter("entriesNavigation", entriesNavigation);
        int cur = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"cur");
        if (cur > 0) {
            portletURL.setParameter("cur", String.valueOf(cur));
        }
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("mvcRenderCommandName", "/blogs/view");
        sortingURL.setParameter("cur", "0");
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            sortingURL.setParameter("keywords", keywords);
        }
        return sortingURL;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation", (String)"all");
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(entriesNavigation.equals("all"));
                    PortletURL navigationPortletURL = PortletURLUtil.clone((PortletURL)BlogEntriesManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)BlogEntriesManagementToolbarDisplayContext.this._liferayPortletResponse);
                    dropdownItem.setHref(navigationPortletURL, new Object[]{"entriesNavigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)"all"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(entriesNavigation.equals("mine"));
                    PortletURL navigationPortletURL = PortletURLUtil.clone((PortletURL)BlogEntriesManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)BlogEntriesManagementToolbarDisplayContext.this._liferayPortletResponse);
                    dropdownItem.setHref(navigationPortletURL, new Object[]{"entriesNavigation", "mine"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)"mine"));
                }));
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive("title".equals(BlogEntriesManagementToolbarDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(BlogEntriesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "title"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)"title"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive("display-date".equals(BlogEntriesManagementToolbarDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(BlogEntriesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "display-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this._request, (String)"display-date"));
                }));
            }
        };
    }
}

