/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.configuration.BlogsGroupServiceOverriddenConfiguration;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.BaseRSSStrutsAction;
import com.liferay.rss.util.RSSUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/blogs/rss"}, service={StrutsAction.class})
public class RSSAction
extends BaseRSSStrutsAction {
    private BlogsEntryService _blogsEntryService;
    private ConfigurationProvider _configurationProvider;

    protected byte[] getRSS(HttpServletRequest request) throws Exception {
        String feedURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        if (plid == 0L) {
            plid = themeDisplay.getPlid();
        }
        long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        long organizationId = ParamUtil.getLong((HttpServletRequest)request, (String)"organizationId");
        int status = 0;
        int max = ParamUtil.getInteger((HttpServletRequest)request, (String)"max", (int)SearchContainer.DEFAULT_DELTA);
        String type = ParamUtil.getString((HttpServletRequest)request, (String)"type", (String)RSSUtil.FORMAT_DEFAULT);
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version", (double)RSSUtil.VERSION_DEFAULT);
        String displayStyle = ParamUtil.getString((HttpServletRequest)request, (String)"displayStyle", (String)RSSUtil.DISPLAY_STYLE_DEFAULT);
        String entryURL = feedURL = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/blogs/find_entry?";
        String rss = "";
        if (companyId > 0L) {
            feedURL = "";
            rss = this._blogsEntryService.getCompanyEntriesRSS(companyId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (groupId > 0L) {
            entryURL = feedURL = feedURL + "p_l_id=" + plid;
            rss = this._blogsEntryService.getGroupEntriesRSS(groupId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (organizationId > 0L) {
            feedURL = "";
            rss = this._blogsEntryService.getOrganizationEntriesRSS(organizationId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (layout != null) {
            groupId = themeDisplay.getScopeGroupId();
            entryURL = feedURL = themeDisplay.getPathMain() + "/blogs/rss";
            rss = this._blogsEntryService.getGroupEntriesRSS(groupId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        }
        return rss.getBytes("UTF-8");
    }

    protected boolean isRSSFeedsEnabled(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        BlogsGroupServiceOverriddenConfiguration blogsGroupServiceOverriddenConfiguration = (BlogsGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(BlogsGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(themeDisplay.getSiteGroupId(), "com.liferay.blogs"));
        return blogsGroupServiceOverriddenConfiguration.enableRss();
    }

    @Reference(unbind="-")
    protected void setBlogsEntryService(BlogsEntryService blogsEntryService) {
        this._blogsEntryService = blogsEntryService;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }
}

