/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.exception.NoSuchEntryException;
import com.liferay.blogs.exception.TrackbackValidationException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.web.internal.portlet.action.ActionUtil;
import com.liferay.blogs.web.internal.trackback.Trackback;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFunction;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"auth.token.ignore.mvc.action=true", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet", "mvc.command.name=/blogs/trackback"}, service={MVCActionCommand.class})
public class TrackbackMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(TrackbackMVCActionCommand.class);
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    @Reference
    private Trackback _trackback;

    public void addTrackback(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            BlogsEntry entry = this.getBlogsEntry(actionRequest);
            this.validate(entry);
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletRequest originalRequest = this._portal.getOriginalServletRequest(request);
            String excerpt = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"excerpt");
            String url = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"url");
            String blogName = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"blog_name");
            String title = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"title");
            this.validate(actionRequest, request.getRemoteAddr(), url);
            this._trackback.addTrackback(entry, themeDisplay, excerpt, url, blogName, title, (Function<String, ServiceContext>)new ServiceContextFunction((PortletRequest)actionRequest));
        }
        catch (TrackbackValidationException tve) {
            this.sendError(actionRequest, actionResponse, tve.getMessage());
            return;
        }
        this.sendSuccess(actionRequest, actionResponse);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.addTrackback(actionRequest, actionResponse);
        }
        catch (NoSuchEntryException nsee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsee, (Throwable)nsee);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected BlogsEntry getBlogsEntry(ActionRequest actionRequest) throws Exception {
        try {
            return ActionUtil.getEntry((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            throw new TrackbackValidationException("Blog entry must have guest view permissions to enable trackbacks", (Throwable)pe);
        }
    }

    protected boolean isCommentsEnabled(ActionRequest actionRequest) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getExistingPortletSetup((PortletRequest)actionRequest);
        if (portletPreferences == null) {
            portletPreferences = actionRequest.getPreferences();
        }
        return GetterUtil.getBoolean((String)portletPreferences.getValue("enableComments", null), (boolean)true);
    }

    protected void sendError(ActionRequest actionRequest, ActionResponse actionResponse, String msg) throws Exception {
        this.sendResponse(actionRequest, actionResponse, msg, false);
    }

    protected void sendResponse(ActionRequest actionRequest, ActionResponse actionResponse, String msg, boolean success) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<response>");
        if (success) {
            sb.append("<error>0</error>");
        } else {
            sb.append("<error>1</error>");
            sb.append("<message>");
            sb.append(msg);
            sb.append("</message>");
        }
        sb.append("</response>");
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
        String s = sb.toString();
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])s.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
    }

    protected void sendSuccess(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.sendResponse(actionRequest, actionResponse, null, true);
    }

    protected void validate(ActionRequest actionRequest, String remoteIP, String url) throws Exception {
        if (!this.isCommentsEnabled(actionRequest)) {
            throw new TrackbackValidationException("Comments are disabled");
        }
        if (Validator.isNull((String)url)) {
            throw new TrackbackValidationException("Trackback requires a valid permanent URL");
        }
        String trackbackIP = this._http.getIpAddress(url);
        if (!remoteIP.equals(trackbackIP)) {
            throw new TrackbackValidationException("Remote IP does not match the trackback URL's IP");
        }
    }

    protected void validate(BlogsEntry entry) throws TrackbackValidationException {
        if (!entry.isAllowTrackbacks()) {
            throw new TrackbackValidationException("Trackbacks are not enabled");
        }
    }
}

