/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.trackback;

import com.liferay.blogs.linkback.LinkbackConsumer;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Trackback.class})
public class Trackback {
    @Reference
    private CommentManager _commentManager;
    @Reference
    private LinkbackConsumer _linkbackConsumer;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void addTrackback(BlogsEntry entry, ThemeDisplay themeDisplay, String excerpt, String url, String blogName, String title, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        long userId = this._userLocalService.getDefaultUserId(themeDisplay.getCompanyId());
        long groupId = entry.getGroupId();
        String className = BlogsEntry.class.getName();
        long classPK = entry.getEntryId();
        String body = this.buildBody(themeDisplay, excerpt, url);
        long commentId = this._commentManager.addComment(userId, groupId, className, classPK, blogName, title, body, serviceContextFunction);
        String entryURL = this.buildEntryURL(entry, themeDisplay);
        this._linkbackConsumer.addNewTrackback(commentId, url, entryURL);
    }

    protected String buildBBCodeBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        url = StringUtil.replace((String)url, (char[])new char[]{']', '['}, (String[])new String[]{"%5D", "%5B"});
        StringBundler sb = new StringBundler(7);
        sb.append("[...] ");
        sb.append(excerpt);
        sb.append(" [...] [url=");
        sb.append(url);
        sb.append("]");
        sb.append(themeDisplay.translate("read-more"));
        sb.append("[/url]");
        return sb.toString();
    }

    protected String buildBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        if (PropsValues.DISCUSSION_COMMENTS_FORMAT.equals("bbcode")) {
            return this.buildBBCodeBody(themeDisplay, excerpt, url);
        }
        return this.buildHTMLBody(themeDisplay, excerpt, url);
    }

    protected String buildEntryURL(BlogsEntry entry, ThemeDisplay themeDisplay) throws PortalException {
        StringBundler sb = new StringBundler(4);
        sb.append(this._portal.getLayoutFullURL(themeDisplay));
        sb.append("/-/");
        sb.append("blogs/");
        sb.append(entry.getUrlTitle());
        return sb.toString();
    }

    protected String buildHTMLBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        StringBundler sb = new StringBundler(7);
        sb.append("[...] ");
        sb.append(excerpt);
        sb.append(" [...] <a href=\"");
        sb.append(url);
        sb.append("\">");
        sb.append(themeDisplay.translate("read-more"));
        sb.append("</a>");
        return sb.toString();
    }
}

