/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bulk.rest.internal.resource.v1_0;

import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.bulk.rest.dto.v1_0.DocumentBulkSelection;
import com.liferay.bulk.rest.dto.v1_0.Keyword;
import com.liferay.bulk.rest.dto.v1_0.KeywordBulkSelection;
import com.liferay.bulk.rest.internal.resource.v1_0.BaseKeywordResourceImpl;
import com.liferay.bulk.rest.internal.selection.v1_0.DocumentBulkSelectionFactory;
import com.liferay.bulk.rest.resource.v1_0.KeywordResource;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.bulk.selection.BulkSelectionInputParameters;
import com.liferay.bulk.selection.BulkSelectionRunner;
import com.liferay.document.library.bulk.selection.EditTagsBulkSelectionAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/keyword.properties"}, scope=ServiceScope.PROTOTYPE, service={KeywordResource.class})
public class KeywordResourceImpl
extends BaseKeywordResourceImpl {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private BulkSelectionRunner _bulkSelectionRunner;
    @Reference
    private DocumentBulkSelectionFactory _documentBulkSelectionFactory;
    @Reference
    private EditTagsBulkSelectionAction _editTagsBulkSelectionAction;

    @Override
    public void patchKeywordBatch(KeywordBulkSelection keywordBulkSelection) throws Exception {
        this._update(true, keywordBulkSelection);
    }

    @Override
    public Page<Keyword> postKeywordsCommonPage(DocumentBulkSelection documentSelection) throws Exception {
        return Page.of(this.transform(this._getAssetTagNames(documentSelection, PermissionCheckerFactoryUtil.create((User)this.contextUser)), this::_toTag));
    }

    @Override
    public void putKeywordBatch(KeywordBulkSelection keywordBulkSelection) throws Exception {
        this._update(false, keywordBulkSelection);
    }

    private Set<String> _getAssetTagNames(DocumentBulkSelection documentSelection, PermissionChecker permissionChecker) throws Exception {
        HashSet<String> assetTagNames = new HashSet<String>();
        AtomicBoolean flag = new AtomicBoolean(true);
        BulkSelection<?> bulkSelection = this._documentBulkSelectionFactory.create(documentSelection);
        BulkSelection assetEntryBulkSelection = bulkSelection.toAssetEntryBulkSelection();
        assetEntryBulkSelection.forEach(assetEntry -> {
            if (BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE").booleanValue()) {
                String[] assetEntryAssetTagNames = this._assetTagLocalService.getTagNames(assetEntry.getClassName(), assetEntry.getClassPK());
                if (flag.get()) {
                    flag.set(false);
                    Collections.addAll(assetTagNames, assetEntryAssetTagNames);
                } else {
                    assetTagNames.retainAll(Arrays.asList(assetEntryAssetTagNames));
                }
            }
        });
        return assetTagNames;
    }

    private Keyword _toTag(final String assetTagName) {
        return new Keyword(){
            {
                this.name = assetTagName;
            }
        };
    }

    private void _update(boolean append, KeywordBulkSelection keywordBulkSelection) throws PortalException {
        BulkSelection<?> bulkSelection = this._documentBulkSelectionFactory.create(keywordBulkSelection.getDocumentBulkSelection());
        this._bulkSelectionRunner.run(this.contextUser, bulkSelection.toAssetEntryBulkSelection(), (BulkSelectionAction)this._editTagsBulkSelectionAction, (Map)HashMapBuilder.put((Object)BulkSelectionInputParameters.ASSET_ENTRY_BULK_SELECTION, (Object)true).put((Object)"append", (Object)append).put((Object)"toAddTagNames", (Object)keywordBulkSelection.getKeywordsToAdd()).put((Object)"toRemoveTagNames", (Object)keywordBulkSelection.getKeywordsToRemove()).build());
    }
}

