/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bulk.selection.internal;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.bulk.selection.BulkSelectionInputParameters;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"background.task.executor.class.name=com.liferay.bulk.selection.internal.BulkSelectionBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class BulkSelectionBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BulkSelectionBackgroundTaskExecutor.class);
    private BundleContext _bundleContext;
    @Reference
    private UserLocalService _userLocalService;

    public BulkSelectionBackgroundTaskExecutor() {
        this.setIsolationLevel(5);
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        String bulkSelectionActionClassName = (String)taskContextMap.get("bulkSelectionActionClassName");
        Optional<BulkSelectionAction> bulkSelectionActionOptional = this._getService(BulkSelectionAction.class, bulkSelectionActionClassName);
        bulkSelectionActionOptional.ifPresent(bulkSelectionAction -> {
            Map parameterMap = (Map)taskContextMap.get("bulkSelectionParameterMap");
            String bulkSelectionFactoryClassName = (String)taskContextMap.get("bulkSelectionFactoryClassName");
            Optional<BulkSelectionFactory> bulkSelectionFactoryOptional = this._getService(BulkSelectionFactory.class, bulkSelectionFactoryClassName);
            bulkSelectionFactoryOptional.ifPresent(bulkSelectionFactory -> {
                try {
                    BulkSelection bulkSelection = bulkSelectionFactory.create(parameterMap);
                    Map inputMap = (Map)taskContextMap.get("bulkSelectionActionInputMap");
                    boolean assetEntryBulkSelection = (Boolean)((Serializable)inputMap.getOrDefault(BulkSelectionInputParameters.ASSET_ENTRY_BULK_SELECTION, false));
                    if (assetEntryBulkSelection) {
                        bulkSelection = bulkSelection.toAssetEntryBulkSelection();
                    }
                    bulkSelectionAction.execute(this._userLocalService.getUser(backgroundTask.getUserId()), bulkSelection, inputMap);
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
            });
        });
        return BackgroundTaskResult.SUCCESS;
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private <T> Optional<T> _getService(Class<T> clazz, String concreteClassName) {
        try {
            Collection serviceReferences = this._bundleContext.getServiceReferences(clazz, "(objectClass=" + concreteClassName + ")");
            Iterator iterator = serviceReferences.iterator();
            if (iterator.hasNext()) {
                return Optional.of(this._bundleContext.getService((ServiceReference)iterator.next()));
            }
            return Optional.empty();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)invalidSyntaxException, (Throwable)invalidSyntaxException);
            }
            return Optional.empty();
        }
    }
}

