/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.changeset.service.impl;

import com.liferay.changeset.exception.NoSuchEntryException;
import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.base.ChangesetEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;

public class ChangesetEntryLocalServiceImpl
extends ChangesetEntryLocalServiceBaseImpl {
    public ChangesetEntry addChangesetEntry(long userId, long changesetCollectionId, long classNameId, long classPK) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        ChangesetCollection changesetCollection = this.changesetCollectionPersistence.fetchByPrimaryKey(changesetCollectionId);
        long changesetEntryId = this.counterLocalService.increment();
        ChangesetEntry changesetEntry = this.changesetEntryPersistence.create(changesetEntryId);
        changesetEntry.setGroupId(changesetCollection.getGroupId());
        changesetEntry.setCompanyId(user.getCompanyId());
        changesetEntry.setUserId(user.getUserId());
        changesetEntry.setUserName(user.getFullName());
        changesetEntry.setChangesetCollectionId(changesetCollectionId);
        changesetEntry.setClassNameId(classNameId);
        changesetEntry.setClassPK(classPK);
        return (ChangesetEntry)this.changesetEntryPersistence.update((BaseModel)changesetEntry);
    }

    public void deleteChangesetEntries(long changesetCollectionId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"changesetCollectionId", (Object)changesetCollectionId)));
        actionableDynamicQuery.setPerformActionMethod(changesetEntry -> this.changesetEntryLocalService.deleteChangesetEntry(changesetEntry));
        actionableDynamicQuery.performActions();
    }

    public void deleteEntry(long changesetId, long classNameId, long classPK) {
        ChangesetEntry changesetEntry = this.changesetEntryLocalService.fetchChangesetEntry(changesetId, classNameId, classPK);
        if (changesetEntry != null) {
            this.changesetEntryLocalService.deleteChangesetEntry(changesetEntry);
        }
    }

    public ChangesetEntry fetchChangesetEntry(long changesetCollectionId, long classNameId, long classPK) {
        return this.changesetEntryPersistence.fetchByC_C_C(changesetCollectionId, classNameId, classPK);
    }

    public ChangesetEntry fetchOrAddChangesetEntry(long changesetCollectionId, long classNameId, long classPK) throws PortalException {
        ChangesetEntry changesetEntry = this.changesetEntryLocalService.fetchChangesetEntry(changesetCollectionId, classNameId, classPK);
        if (changesetEntry != null) {
            return changesetEntry;
        }
        ChangesetCollection changesetCollection = this.changesetCollectionLocalService.getChangesetCollection(changesetCollectionId);
        User user = this.userLocalService.getDefaultUser(changesetCollection.getCompanyId());
        return this.changesetEntryLocalService.addChangesetEntry(user.getUserId(), changesetCollectionId, classNameId, classPK);
    }

    public long getChangesetEntriesCount(long changesetCollectionId) {
        return this.changesetEntryPersistence.countByChangesetCollectionId(changesetCollectionId);
    }

    public long getChangesetEntriesCount(long changesetCollectionId, long classNameId) {
        return this.changesetEntryPersistence.countByC_C(changesetCollectionId, classNameId);
    }

    public ChangesetEntry getChangesetEntry(long changesetCollectionId, long classNameId, long classPK) throws NoSuchEntryException {
        return this.changesetEntryPersistence.findByC_C_C(changesetCollectionId, classNameId, classPK);
    }
}

