/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.display.ConfigurationVisibilityController;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.definitions.ExtendedMetaTypeInformation;
import com.liferay.portal.configuration.metatype.definitions.ExtendedMetaTypeService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConfigurationModelRetriever.class})
public class ConfigurationModelRetrieverImpl
implements ConfigurationModelRetriever {
    private BundleContext _bundleContext;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private ServiceTrackerMap<String, ConfigurationVisibilityController> _configurationVisibilityControllerServiceTrackerMap;
    @Reference
    private ExtendedMetaTypeService _extendedMetaTypeService;

    @Override
    public Map<String, Set<ConfigurationModel>> categorizeConfigurationModels(Map<String, ConfigurationModel> configurationModels) {
        HashMap<String, Set<ConfigurationModel>> categorizedConfigurationModels = new HashMap<String, Set<ConfigurationModel>>();
        for (ConfigurationModel configurationModel : configurationModels.values()) {
            String configurationCategory = configurationModel.getCategory();
            TreeSet<ConfigurationModel> curConfigurationModels = (TreeSet<ConfigurationModel>)categorizedConfigurationModels.get(configurationCategory);
            if (curConfigurationModels == null) {
                curConfigurationModels = new TreeSet<ConfigurationModel>(this.getConfigurationModelComparator());
                categorizedConfigurationModels.put(configurationCategory, curConfigurationModels);
            }
            curConfigurationModels.add(configurationModel);
        }
        return categorizedConfigurationModels;
    }

    @Override
    public Configuration getConfiguration(String pid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        try {
            String pidFilter = this.getPidFilterString(pid, scope, scopePK);
            Configuration[] configurations = this._configurationAdmin.listConfigurations(pidFilter);
            if (configurations != null) {
                return configurations[0];
            }
            if (scope.equals((Object)ExtendedObjectClassDefinition.Scope.COMPANY)) {
                return this.getConfiguration(pid, ExtendedObjectClassDefinition.Scope.SYSTEM, null);
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            ReflectionUtil.throwException((Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, ConfigurationModel> getConfigurationModels(Bundle bundle, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        HashMap<String, ConfigurationModel> configurationModels = new HashMap<String, ConfigurationModel>();
        this.collectConfigurationModels(bundle, configurationModels, true, null, scope, scopePK);
        this.collectConfigurationModels(bundle, configurationModels, false, null, scope, scopePK);
        return configurationModels;
    }

    @Override
    public Map<String, ConfigurationModel> getConfigurationModels(ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        return this.getConfigurationModels((String)null, scope, scopePK);
    }

    @Override
    public Map<String, ConfigurationModel> getConfigurationModels(String locale, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        Bundle[] bundles;
        HashMap<String, ConfigurationModel> configurationModels = new HashMap<String, ConfigurationModel>();
        for (Bundle bundle : bundles = this._bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.collectConfigurationModels(bundle, configurationModels, true, locale, scope, scopePK);
            this.collectConfigurationModels(bundle, configurationModels, false, locale, scope, scopePK);
        }
        return configurationModels;
    }

    @Override
    public Set<ConfigurationModel> getConfigurationModels(String configurationCategory, String languageId, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        Map<String, ConfigurationModel> configurationModelsMap = this.getConfigurationModels(languageId, scope, scopePK);
        Map<String, Set<ConfigurationModel>> categorizedConfigurationModels = this.categorizeConfigurationModels(configurationModelsMap);
        Set<ConfigurationModel> configurationModels = categorizedConfigurationModels.get(configurationCategory);
        if (configurationModels == null) {
            configurationModels = Collections.emptySet();
        }
        return configurationModels;
    }

    @Override
    public List<ConfigurationModel> getFactoryInstances(ConfigurationModel factoryConfigurationModel, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) throws IOException {
        Configuration[] configurations = this.getFactoryConfigurations(factoryConfigurationModel.getFactoryPid());
        if (configurations == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationModel> factoryInstances = new ArrayList<ConfigurationModel>();
        for (Configuration configuration : configurations) {
            ConfigurationModel curConfigurationModel = new ConfigurationModel(factoryConfigurationModel, configuration, factoryConfigurationModel.getBundleSymbolicName(), configuration.getBundleLocation(), false);
            factoryInstances.add(curConfigurationModel);
        }
        return factoryInstances;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._configurationVisibilityControllerServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, ConfigurationVisibilityController.class, (String)"configuration.pid");
    }

    protected void collectConfigurationModels(Bundle bundle, Map<String, ConfigurationModel> configurationModels, boolean factory, String locale, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        ExtendedMetaTypeInformation extendedMetaTypeInformation = this._extendedMetaTypeService.getMetaTypeInformation(bundle);
        if (extendedMetaTypeInformation == null) {
            return;
        }
        ArrayList pids = new ArrayList();
        if (factory) {
            Collections.addAll(pids, extendedMetaTypeInformation.getFactoryPids());
        } else {
            Collections.addAll(pids, extendedMetaTypeInformation.getPids());
        }
        for (String pid : pids) {
            ConfigurationModel configurationModel = this.getConfigurationModel(bundle, pid, factory, locale, scope, scopePK);
            if (configurationModel == null) continue;
            configurationModels.put(pid, configurationModel);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._configurationVisibilityControllerServiceTrackerMap.close();
    }

    protected String getAndFilterString(String ... filterStrings) {
        StringBundler sb = new StringBundler(filterStrings.length + 3);
        sb.append("(");
        sb.append("&");
        for (String filterString : filterStrings) {
            if (Validator.isNull((String)filterString)) {
                return "";
            }
            sb.append(filterString);
        }
        sb.append(")");
        return sb.toString();
    }

    protected Configuration getCompanyDefaultConfiguration(String factoryPid) {
        Object configuration = null;
        try {
            Object[] factoryConfigurations = this.getFactoryConfigurations(factoryPid, "companyId", "0");
            if (ArrayUtil.isNotEmpty((Object[])factoryConfigurations)) {
                configuration = factoryConfigurations[0];
            }
        }
        catch (IOException ioe) {
            ReflectionUtil.throwException((Throwable)ioe);
        }
        return configuration;
    }

    protected ConfigurationModel getConfigurationModel(Bundle bundle, String pid, boolean factory, String locale, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        ExtendedMetaTypeInformation metaTypeInformation = this._extendedMetaTypeService.getMetaTypeInformation(bundle);
        if (metaTypeInformation == null) {
            return null;
        }
        ConfigurationModel configurationModel = new ConfigurationModel(metaTypeInformation.getObjectClassDefinition(pid, locale), this.getConfiguration(pid, scope, scopePK), bundle.getSymbolicName(), "?", factory);
        ConfigurationVisibilityController configurationVisibilityController = (ConfigurationVisibilityController)this._configurationVisibilityControllerServiceTrackerMap.getService((Object)pid);
        if (configurationVisibilityController != null && !configurationVisibilityController.isVisible(scope, scopePK)) {
            return null;
        }
        if (!scope.equals((Object)ExtendedObjectClassDefinition.Scope.SYSTEM) && configurationModel.isFactory()) {
            return null;
        }
        if (scope.equals((Object)ExtendedObjectClassDefinition.Scope.COMPANY) && configurationModel.isSystemScope()) {
            return null;
        }
        if (configurationModel.isCompanyFactory()) {
            Configuration configuration = this.getCompanyDefaultConfiguration(pid);
            configurationModel = new ConfigurationModel(configurationModel.getExtendedObjectClassDefinition(), configuration, bundle.getSymbolicName(), "?", configurationModel.isFactory());
        }
        return configurationModel;
    }

    protected Comparator<ConfigurationModel> getConfigurationModelComparator() {
        return new ConfigurationModelComparator();
    }

    protected Configuration[] getFactoryConfigurations(String factoryPid) throws IOException {
        return this.getFactoryConfigurations(factoryPid, null, null);
    }

    protected Configuration[] getFactoryConfigurations(String factoryPid, String property, String value) throws IOException {
        Configuration[] configurations = null;
        String filterString = this.getPropertyFilterString("service.factoryPid", factoryPid);
        String propertyFilterString = this.getPropertyFilterString(property, value);
        if (Validator.isNotNull((String)propertyFilterString)) {
            filterString = this.getAndFilterString(filterString, propertyFilterString);
        }
        try {
            configurations = this._configurationAdmin.listConfigurations(filterString);
        }
        catch (InvalidSyntaxException ise) {
            ReflectionUtil.throwException((Throwable)ise);
        }
        return configurations;
    }

    protected String getPidFilterString(String pid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        if (scope.equals((Object)ExtendedObjectClassDefinition.Scope.SYSTEM)) {
            return this.getPropertyFilterString("service.pid", pid);
        }
        return this.getAndFilterString(this.getPropertyFilterString("service.factoryPid", pid + ".scoped"), this.getPropertyFilterString(scope.getPropertyKey(), String.valueOf(scopePK)));
    }

    protected String getPropertyFilterString(String key, String value) {
        if (Validator.isNull((String)key) || Validator.isNull((String)value)) {
            return "";
        }
        return StringBundler.concat((String[])new String[]{"(", key, "=", value, ")"});
    }

    private static class ConfigurationModelComparator
    implements Comparator<ConfigurationModel> {
        private ConfigurationModelComparator() {
        }

        @Override
        public int compare(ConfigurationModel configurationModel1, ConfigurationModel configurationModel2) {
            String name1 = configurationModel1.getName();
            String name2 = configurationModel2.getName();
            return name1.compareTo(name2);
        }
    }
}

