/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.AttributeDefinitionUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.metatype.AttributeDefinition;

public class ConfigurationModelToDDMFormValuesConverter {
    private static final String[] _PASSWORD_TYPE_VALUES = new String[]{"TEMP_OBFUSCATION_VALUE"};
    private final ConfigurationModel _configurationModel;
    private final DDMForm _ddmForm;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final Locale _locale;
    private final ResourceBundle _resourceBundle;

    public ConfigurationModelToDDMFormValuesConverter(ConfigurationModel configurationModel, DDMForm ddmForm, Locale locale, ResourceBundle resourceBundle) {
        this._configurationModel = configurationModel;
        this._ddmForm = ddmForm;
        this._locale = locale;
        this._resourceBundle = resourceBundle;
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
    }

    public DDMFormValues getDDMFormValues() {
        DDMFormValues ddmFormValues = new DDMFormValues(this._ddmForm);
        ddmFormValues.addAvailableLocale(this._locale);
        ddmFormValues.setDefaultLocale(this._locale);
        this.addDDMFormFieldValues((AttributeDefinition[])this._configurationModel.getAttributeDefinitions(-1), ddmFormValues);
        return ddmFormValues;
    }

    protected void addDDMFormFieldValue(String name, String value, DDMFormValues ddmFormValues) {
        DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(name);
        this.setDDMFormFieldValueLocalizedValue(value, ddmFormFieldValue);
        ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
    }

    protected void addDDMFormFieldValues(AttributeDefinition attributeDefinition, DDMFormValues ddmFormValues) {
        String[] values = null;
        Configuration configuration = this._configurationModel.getConfiguration();
        values = attributeDefinition.getType() == 12 ? _PASSWORD_TYPE_VALUES : (this.hasConfigurationAttribute(configuration, attributeDefinition) ? AttributeDefinitionUtil.getProperty(attributeDefinition, configuration) : AttributeDefinitionUtil.getDefaultValue(attributeDefinition));
        this.addDDMFormFieldValues(attributeDefinition.getID(), values, ddmFormValues);
    }

    protected void addDDMFormFieldValues(AttributeDefinition[] attributeDefinitions, DDMFormValues ddmFormValues) {
        if (attributeDefinitions == null) {
            return;
        }
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            this.addDDMFormFieldValues(attributeDefinition, ddmFormValues);
        }
    }

    protected void addDDMFormFieldValues(String name, String[] values, DDMFormValues ddmFormValues) {
        for (String value : values) {
            this.addDDMFormFieldValue(name, value, ddmFormValues);
        }
    }

    protected DDMFormFieldValue createDDMFormFieldValue(String name) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(name);
        ddmFormFieldValue.setInstanceId(StringUtil.randomString());
        return ddmFormFieldValue;
    }

    protected String getDDMFormFieldType(String ddmFormFieldName) {
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldName);
        return ddmFormField.getType();
    }

    protected boolean hasConfigurationAttribute(Configuration configuration, AttributeDefinition attributeDefinition) {
        if (configuration == null) {
            return false;
        }
        Dictionary properties = configuration.getProperties();
        Enumeration keys = properties.keys();
        String attributeDefinitionID = attributeDefinition.getID();
        while (keys.hasMoreElements()) {
            if (!attributeDefinitionID.equals(keys.nextElement())) continue;
            return true;
        }
        return false;
    }

    protected void setDDMFormFieldValueLocalizedValue(String value, DDMFormFieldValue ddmFormFieldValue) {
        String type = this.getDDMFormFieldType(ddmFormFieldValue.getName());
        if (type.equals("select")) {
            value = "[\"" + value + "\"]";
        }
        LocalizedValue localizedValue = new LocalizedValue(this._locale);
        localizedValue.addString(this._locale, value);
        ddmFormFieldValue.setValue((Value)localizedValue);
    }
}

