/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.data.engine.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DEDataListView service. Represents a row in the &quot;DEDataListView&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.data.engine.model.impl.DEDataListViewModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.data.engine.model.impl.DEDataListViewImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DEDataListView
 * @generated
 */
@ProviderType
public interface DEDataListViewModel
	extends BaseModel<DEDataListView>, CTModel<DEDataListView>, GroupedModel,
			LocalizedModel, MVCCModel, ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a de data list view model instance should use the {@link DEDataListView} interface instead.
	 */

	/**
	 * Returns the primary key of this de data list view.
	 *
	 * @return the primary key of this de data list view
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this de data list view.
	 *
	 * @param primaryKey the primary key of this de data list view
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this de data list view.
	 *
	 * @return the mvcc version of this de data list view
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this de data list view.
	 *
	 * @param mvccVersion the mvcc version of this de data list view
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this de data list view.
	 *
	 * @return the ct collection ID of this de data list view
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this de data list view.
	 *
	 * @param ctCollectionId the ct collection ID of this de data list view
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this de data list view.
	 *
	 * @return the uuid of this de data list view
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this de data list view.
	 *
	 * @param uuid the uuid of this de data list view
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the de data list view ID of this de data list view.
	 *
	 * @return the de data list view ID of this de data list view
	 */
	public long getDeDataListViewId();

	/**
	 * Sets the de data list view ID of this de data list view.
	 *
	 * @param deDataListViewId the de data list view ID of this de data list view
	 */
	public void setDeDataListViewId(long deDataListViewId);

	/**
	 * Returns the group ID of this de data list view.
	 *
	 * @return the group ID of this de data list view
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this de data list view.
	 *
	 * @param groupId the group ID of this de data list view
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this de data list view.
	 *
	 * @return the company ID of this de data list view
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this de data list view.
	 *
	 * @param companyId the company ID of this de data list view
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this de data list view.
	 *
	 * @return the user ID of this de data list view
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this de data list view.
	 *
	 * @param userId the user ID of this de data list view
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this de data list view.
	 *
	 * @return the user uuid of this de data list view
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this de data list view.
	 *
	 * @param userUuid the user uuid of this de data list view
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this de data list view.
	 *
	 * @return the user name of this de data list view
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this de data list view.
	 *
	 * @param userName the user name of this de data list view
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this de data list view.
	 *
	 * @return the create date of this de data list view
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this de data list view.
	 *
	 * @param createDate the create date of this de data list view
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this de data list view.
	 *
	 * @return the modified date of this de data list view
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this de data list view.
	 *
	 * @param modifiedDate the modified date of this de data list view
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the applied filters of this de data list view.
	 *
	 * @return the applied filters of this de data list view
	 */
	@AutoEscape
	public String getAppliedFilters();

	/**
	 * Sets the applied filters of this de data list view.
	 *
	 * @param appliedFilters the applied filters of this de data list view
	 */
	public void setAppliedFilters(String appliedFilters);

	/**
	 * Returns the ddm structure ID of this de data list view.
	 *
	 * @return the ddm structure ID of this de data list view
	 */
	public long getDdmStructureId();

	/**
	 * Sets the ddm structure ID of this de data list view.
	 *
	 * @param ddmStructureId the ddm structure ID of this de data list view
	 */
	public void setDdmStructureId(long ddmStructureId);

	/**
	 * Returns the field names of this de data list view.
	 *
	 * @return the field names of this de data list view
	 */
	@AutoEscape
	public String getFieldNames();

	/**
	 * Sets the field names of this de data list view.
	 *
	 * @param fieldNames the field names of this de data list view
	 */
	public void setFieldNames(String fieldNames);

	/**
	 * Returns the name of this de data list view.
	 *
	 * @return the name of this de data list view
	 */
	public String getName();

	/**
	 * Returns the localized name of this de data list view in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this de data list view
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this de data list view in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this de data list view. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this de data list view in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this de data list view
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this de data list view in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this de data list view
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this de data list view.
	 *
	 * @return the locales and localized names of this de data list view
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this de data list view.
	 *
	 * @param name the name of this de data list view
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this de data list view in the language.
	 *
	 * @param name the localized name of this de data list view
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this de data list view in the language, and sets the default locale.
	 *
	 * @param name the localized name of this de data list view
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this de data list view from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this de data list view
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this de data list view from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this de data list view
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the sort field of this de data list view.
	 *
	 * @return the sort field of this de data list view
	 */
	@AutoEscape
	public String getSortField();

	/**
	 * Sets the sort field of this de data list view.
	 *
	 * @param sortField the sort field of this de data list view
	 */
	public void setSortField(String sortField);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public DEDataListView cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}