/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v1_0.util;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.data.engine.spi.dto.SPIDataDefinitionField;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Map;
import java.util.Optional;

public class DataDefinitionFieldUtil {
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionFieldUtil.class);

    public static Object getLocalizedDefaultValue(Map<String, Object> defaultValue, String languageId) {
        try {
            return JSONFactoryUtil.createJSONArray((String)MapUtil.getString(defaultValue, (String)languageId));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsonException, (Throwable)jsonException);
            }
            return MapUtil.getString(defaultValue, (String)languageId);
        }
    }

    public static DataDefinitionField toDataDefinitionField(final SPIDataDefinitionField spiDataDefinitionField) {
        return new DataDefinitionField(){
            {
                this.customProperties = spiDataDefinitionField.getCustomProperties();
                this.defaultValue = spiDataDefinitionField.getDefaultValue();
                this.fieldType = spiDataDefinitionField.getFieldType();
                this.id = spiDataDefinitionField.getId();
                this.indexable = spiDataDefinitionField.getIndexable();
                this.indexType = DataDefinitionField.IndexType.create((String)spiDataDefinitionField.getIndexType());
                this.label = spiDataDefinitionField.getLabel();
                this.localizable = spiDataDefinitionField.getLocalizable();
                this.name = spiDataDefinitionField.getName();
                this.nestedDataDefinitionFields = (DataDefinitionField[])TransformUtil.transform((Object[])spiDataDefinitionField.getNestedSPIDataDefinitionFields(), DataDefinitionFieldUtil::toDataDefinitionField, DataDefinitionField.class);
                this.readOnly = spiDataDefinitionField.getReadOnly();
                this.repeatable = spiDataDefinitionField.getRepeatable();
                this.required = spiDataDefinitionField.getRequired();
                this.showLabel = spiDataDefinitionField.getShowLabel();
                this.tip = spiDataDefinitionField.getTip();
                this.visible = spiDataDefinitionField.getVisible();
            }
        };
    }

    public static SPIDataDefinitionField toSPIDataDefinitionField(DataDefinitionField dataDefinitionField) {
        SPIDataDefinitionField spiDataDefinitionField = new SPIDataDefinitionField();
        spiDataDefinitionField.setCustomProperties(dataDefinitionField.getCustomProperties());
        spiDataDefinitionField.setDefaultValue(dataDefinitionField.getDefaultValue());
        spiDataDefinitionField.setFieldType(dataDefinitionField.getFieldType());
        spiDataDefinitionField.setId(GetterUtil.getLong((Object)dataDefinitionField.getId()));
        spiDataDefinitionField.setIndexable(GetterUtil.getBoolean((Object)dataDefinitionField.getIndexable()));
        spiDataDefinitionField.setIndexType(Optional.ofNullable(dataDefinitionField.getIndexType()).map(DataDefinitionField.IndexType::getValue).orElseGet(() -> ""));
        spiDataDefinitionField.setLabel(dataDefinitionField.getLabel());
        spiDataDefinitionField.setLocalizable(GetterUtil.getBoolean((Object)dataDefinitionField.getLocalizable()));
        spiDataDefinitionField.setName(dataDefinitionField.getName());
        if (!ArrayUtil.isEmpty((Object[])dataDefinitionField.getNestedDataDefinitionFields())) {
            spiDataDefinitionField.setNestedSPIDataDefinitionFields((SPIDataDefinitionField[])TransformUtil.transform((Object[])dataDefinitionField.getNestedDataDefinitionFields(), DataDefinitionFieldUtil::toSPIDataDefinitionField, SPIDataDefinitionField.class));
        }
        spiDataDefinitionField.setReadOnly(GetterUtil.getBoolean((Object)dataDefinitionField.getReadOnly()));
        spiDataDefinitionField.setRepeatable(GetterUtil.getBoolean((Object)dataDefinitionField.getRepeatable()));
        spiDataDefinitionField.setRequired(GetterUtil.getBoolean((Object)dataDefinitionField.getRequired()));
        spiDataDefinitionField.setShowlabel(GetterUtil.getBoolean((Object)dataDefinitionField.getShowLabel(), (boolean)true));
        spiDataDefinitionField.setTip(dataDefinitionField.getTip());
        spiDataDefinitionField.setVisible(GetterUtil.getBoolean((Object)dataDefinitionField.getVisible(), (boolean)true));
        return spiDataDefinitionField;
    }
}

