/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v1_0.util;

import com.liferay.data.engine.field.type.FieldType;
import com.liferay.data.engine.field.type.FieldTypeTracker;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionRule;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionFieldUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionRuleParameterUtil;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class DataDefinitionUtil {
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionUtil.class);

    public static JSONObject getFieldTypeMetadataJSONObject(AcceptLanguage acceptLanguage, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, DDMFormTemplateContextFactory ddmFormTemplateContextFactory, DDMFormValuesFactory ddmFormValuesFactory, FieldType fieldType, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, NPMResolver npmResolver, ResourceBundle resourceBundle) {
        Map fieldTypeProperties = fieldTypeTracker.getFieldTypeProperties(fieldType.getName());
        return JSONUtil.put((String)"description", (Object)DataDefinitionUtil._translate(MapUtil.getString((Map)fieldTypeProperties, (String)"data.engine.field.type.description"), resourceBundle)).put("group", MapUtil.getString((Map)fieldTypeProperties, (String)"data.engine.field.type.group")).put("icon", MapUtil.getString((Map)fieldTypeProperties, (String)"data.engine.field.type.icon")).put("javaScriptModule", DataDefinitionUtil._resolveModuleName(MapUtil.getString((Map)fieldTypeProperties, (String)"data.engine.field.type.js.module"), npmResolver)).put("label", DataDefinitionUtil._translate(MapUtil.getString((Map)fieldTypeProperties, (String)"data.engine.field.type.label"), resourceBundle)).put("name", fieldType.getName()).put("settingsContext", DataDefinitionUtil._createFieldContextJSONObject(ddmFormFieldTypeServicesTracker, ddmFormTemplateContextFactory, ddmFormValuesFactory, httpServletRequest, acceptLanguage.getPreferredLocale(), fieldType.getName())).put("system", MapUtil.getBoolean((Map)fieldTypeProperties, (String)"data.engine.field.type.system"));
    }

    public static DataDefinition toDataDefinition(final DDMStructure ddmStructure, final FieldTypeTracker fieldTypeTracker) throws Exception {
        final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)ddmStructure.getDefinition());
        return new DataDefinition(){
            {
                this.availableLanguageIds = DataDefinitionUtil._getAvailableLanguageIds(jsonObject);
                this.dataDefinitionFields = (DataDefinitionField[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("fields"), fieldJSONObject -> DataDefinitionUtil._toDataDefinitionField(fieldTypeTracker, fieldJSONObject), DataDefinitionField.class);
                this.dataDefinitionKey = ddmStructure.getStructureKey();
                this.dataDefinitionRules = (DataDefinitionRule[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("rules"), ruleJSONObject -> DataDefinitionUtil._toDataDefinitionRule(ruleJSONObject), DataDefinitionRule.class);
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.defaultLanguageId = jsonObject.getString("defaultLanguageId");
                this.description = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap());
                this.id = ddmStructure.getStructureId();
                this.name = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap());
                this.siteId = ddmStructure.getGroupId();
                this.storageType = ddmStructure.getStorageType();
                this.userId = ddmStructure.getUserId();
            }
        };
    }

    public static String toJSON(DataDefinition dataDefinition, FieldTypeTracker fieldTypeTracker) throws Exception {
        return JSONUtil.put((String)"availableLanguageIds", (Object)JSONUtil.toJSONArray((Object[])dataDefinition.getAvailableLanguageIds(), languageId -> languageId)).put("defaultLanguageId", dataDefinition.getDefaultLanguageId()).put("fields", JSONUtil.toJSONArray((Object[])dataDefinition.getDataDefinitionFields(), dataDefinitionField -> DataDefinitionUtil._toJSONObject(dataDefinitionField, fieldTypeTracker))).put("rules", JSONUtil.toJSONArray((Object[])dataDefinition.getDataDefinitionRules(), dataDefinitionRule -> DataDefinitionUtil._toJSONObject(dataDefinitionRule))).toString();
    }

    private static JSONObject _createFieldContextJSONObject(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, DDMFormTemplateContextFactory ddmFormTemplateContextFactory, DDMFormValuesFactory ddmFormValuesFactory, HttpServletRequest httpServletRequest, Locale locale, String type) {
        try {
            DDMFormFieldType ddmFormFieldType = ddmFormFieldTypeServicesTracker.getDDMFormFieldType(type);
            DDMForm ddmFormFieldTypeSettingsDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
            DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
            ddmFormRenderingContext.setContainerId("settings");
            DDMFormValues ddmFormValues = ddmFormValuesFactory.create(httpServletRequest, ddmFormFieldTypeSettingsDDMForm);
            DataDefinitionUtil._setTypeDDMFormFieldValue(ddmFormValues, type);
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
            ddmFormRenderingContext.setHttpServletRequest(httpServletRequest);
            ddmFormRenderingContext.setLocale(locale);
            ddmFormRenderingContext.setPortletNamespace(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"portletNamespace"));
            ddmFormRenderingContext.setReturnFullContext(true);
            return JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerializeDeep((Object)ddmFormTemplateContextFactory.create(ddmFormFieldTypeSettingsDDMForm, DDMFormLayoutFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings()), ddmFormRenderingContext)));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return null;
        }
    }

    private static String[] _getAvailableLanguageIds(JSONObject jsonObject) {
        return JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("availableLanguageIds"));
    }

    private static String _resolveModuleName(String moduleName, NPMResolver npmResolver) {
        if (Validator.isNull((String)moduleName)) {
            return "";
        }
        return npmResolver.resolveModuleName(moduleName);
    }

    private static void _setTypeDDMFormFieldValue(DDMFormValues ddmFormValues, String type) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("type");
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValue.setValue((Value)new UnlocalizedValue(type));
    }

    private static DataDefinitionField _toDataDefinitionField(FieldTypeTracker fieldTypeTracker, JSONObject jsonObject) throws Exception {
        if (jsonObject.has("type")) {
            FieldType fieldType = fieldTypeTracker.getFieldType(jsonObject.getString("type"));
            return DataDefinitionFieldUtil.toDataDefinitionField(fieldType.deserialize(fieldTypeTracker, jsonObject));
        }
        return new DataDefinitionField();
    }

    private static DataDefinitionRule _toDataDefinitionRule(final JSONObject jsonObject) {
        return new DataDefinitionRule(){
            {
                this.dataDefinitionFieldNames = JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("fields"));
                this.dataDefinitionRuleParameters = DataDefinitionRuleParameterUtil.toDataDefinitionRuleParameters(jsonObject.getJSONObject("parameters"));
                this.name = jsonObject.getString("name");
                this.ruleType = jsonObject.getString("ruleType");
            }
        };
    }

    private static JSONObject _toJSONObject(DataDefinitionField dataDefinitionField, FieldTypeTracker fieldTypeTracker) throws Exception {
        FieldType fieldType = fieldTypeTracker.getFieldType(dataDefinitionField.getFieldType());
        return fieldType.toJSONObject(fieldTypeTracker, DataDefinitionFieldUtil.toSPIDataDefinitionField(dataDefinitionField));
    }

    private static JSONObject _toJSONObject(DataDefinitionRule dataDefinitionRule) throws Exception {
        return JSONUtil.put((String)"fields", (Object)JSONFactoryUtil.createJSONArray((Object[])dataDefinitionRule.getDataDefinitionFieldNames())).put("name", dataDefinitionRule.getName()).put("parameters", DataDefinitionRuleParameterUtil.toJSONObject(dataDefinitionRule.getDataDefinitionRuleParameters())).put("ruleType", dataDefinitionRule.getRuleType());
    }

    private static String _translate(String key, ResourceBundle resourceBundle) {
        if (Validator.isNull((String)key)) {
            return "";
        }
        return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key), (String)key);
    }
}

