/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.renderer.v1_0;

import com.liferay.data.engine.field.type.FieldType;
import com.liferay.data.engine.field.type.FieldTypeTracker;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.renderer.DataLayoutRenderer;
import com.liferay.data.engine.renderer.DataLayoutRendererContext;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutRow;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionFieldUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.field.type.v1_0.FieldSetFieldType;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.servlet.taglib.DynamicIncludeUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.renderer.ComponentDescriptor;
import com.liferay.portal.template.soy.renderer.SoyComponentRenderer;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DataLayoutRenderer.class})
public class DataLayoutRendererImpl
implements DataLayoutRenderer {
    private static final String _MODULE_NAME = "dynamic-data-mapping-form-renderer/js/containers/Form/Form.es";
    private static final String _TEMPLATE_NAMESPACE = "FormRenderer.render";
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private FieldTypeTracker _fieldTypeTracker;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private SoyComponentRenderer _soyComponentRenderer;

    public String render(Long dataLayoutId, DataLayoutRendererContext dataLayoutRendererContext) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStructureLayout.getStructureVersionId());
        return this._render(DataDefinitionUtil.toDataDefinition(ddmStructureVersion.getStructure(), this._fieldTypeTracker), DataLayoutUtil.toDataLayout(ddmStructureLayout.getDefinition()), dataLayoutRendererContext);
    }

    private Object _createDataDefinitionFieldContext(DataDefinitionField dataDefinitionField, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        FieldType fieldType = fieldTypeTracker.getFieldType(dataDefinitionField.getFieldType());
        if (fieldType instanceof FieldSetFieldType) {
            Map customProperties = dataDefinitionField.getCustomProperties();
            DataDefinitionField[] nestedDataDefinitionFields = (DataDefinitionField[])customProperties.get("nestedFields");
            customProperties.put("nestedFields", Stream.of(nestedDataDefinitionFields).map(nestedDataDefinitionField -> this._createDataDefinitionFieldContext((DataDefinitionField)nestedDataDefinitionField, fieldTypeTracker, httpServletRequest, httpServletResponse)).collect(Collectors.toList()));
        }
        return fieldType.includeContext(httpServletRequest, httpServletResponse, DataDefinitionFieldUtil.toSPIDataDefinitionField(dataDefinitionField));
    }

    private List<Object> _createDataDefinitionFieldContexts(Map<String, DataDefinitionField> dataDefinitionFields, String[] fieldNames, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return Stream.of(fieldNames).map(fieldName -> this._createDataDefinitionFieldContext((DataDefinitionField)dataDefinitionFields.get(fieldName), fieldTypeTracker, httpServletRequest, httpServletResponse)).collect(Collectors.toList());
    }

    private List<Object> _createDataLayoutColumnContexts(final Map<String, DataDefinitionField> dataDefinitionFields, DataLayoutColumn[] dataLayoutColumns, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return Stream.of(dataLayoutColumns).map(dataLayoutColumn -> new HashMap((DataLayoutColumn)dataLayoutColumn, fieldTypeTracker, httpServletRequest, httpServletResponse){
            final /* synthetic */ DataLayoutColumn val$dataLayoutColumn;
            final /* synthetic */ FieldTypeTracker val$fieldTypeTracker;
            final /* synthetic */ HttpServletRequest val$httpServletRequest;
            final /* synthetic */ HttpServletResponse val$httpServletResponse;
            {
                this.val$dataLayoutColumn = dataLayoutColumn;
                this.val$fieldTypeTracker = fieldTypeTracker;
                this.val$httpServletRequest = httpServletRequest;
                this.val$httpServletResponse = httpServletResponse;
                this.put("fields", DataLayoutRendererImpl.this._createDataDefinitionFieldContexts(dataDefinitionFields, this.val$dataLayoutColumn.getFieldNames(), this.val$fieldTypeTracker, this.val$httpServletRequest, this.val$httpServletResponse));
                this.put("size", this.val$dataLayoutColumn.getColumnSize());
            }
        }).collect(Collectors.toList());
    }

    private List<Object> _createDataLayoutPageContexts(Map<String, DataDefinitionField> dataDefinitionFields, DataLayoutPage[] dataLayoutPages, FieldTypeTracker fieldTypeTracker, final HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return Stream.of(dataLayoutPages).map(dataLayoutPage -> new HashMap((DataLayoutPage)dataLayoutPage, dataDefinitionFields, fieldTypeTracker, httpServletResponse){
            final /* synthetic */ DataLayoutPage val$dataLayoutPage;
            final /* synthetic */ Map val$dataDefinitionFields;
            final /* synthetic */ FieldTypeTracker val$fieldTypeTracker;
            final /* synthetic */ HttpServletResponse val$httpServletResponse;
            {
                this.val$dataLayoutPage = dataLayoutPage;
                this.val$dataDefinitionFields = map;
                this.val$fieldTypeTracker = fieldTypeTracker;
                this.val$httpServletResponse = httpServletResponse;
                this.put("description", GetterUtil.getString((Object)LocalizedValueUtil.getLocalizedValue((Locale)httpServletRequest.getLocale(), (Map)this.val$dataLayoutPage.getDescription())));
                this.put("rows", DataLayoutRendererImpl.this._createDataLayoutRowContexts(this.val$dataDefinitionFields, this.val$dataLayoutPage.getDataLayoutRows(), this.val$fieldTypeTracker, httpServletRequest, this.val$httpServletResponse));
                this.put("title", GetterUtil.getString((Object)LocalizedValueUtil.getLocalizedValue((Locale)httpServletRequest.getLocale(), (Map)this.val$dataLayoutPage.getTitle())));
            }
        }).collect(Collectors.toList());
    }

    private List<Object> _createDataLayoutRowContexts(final Map<String, DataDefinitionField> dataDefinitionFields, DataLayoutRow[] dataLayoutRows, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return Stream.of(dataLayoutRows).map(dataLayoutRow -> new HashMap((DataLayoutRow)dataLayoutRow, fieldTypeTracker, httpServletRequest, httpServletResponse){
            final /* synthetic */ DataLayoutRow val$dataLayoutRow;
            final /* synthetic */ FieldTypeTracker val$fieldTypeTracker;
            final /* synthetic */ HttpServletRequest val$httpServletRequest;
            final /* synthetic */ HttpServletResponse val$httpServletResponse;
            {
                this.val$dataLayoutRow = dataLayoutRow;
                this.val$fieldTypeTracker = fieldTypeTracker;
                this.val$httpServletRequest = httpServletRequest;
                this.val$httpServletResponse = httpServletResponse;
                this.put("columns", DataLayoutRendererImpl.this._createDataLayoutColumnContexts(dataDefinitionFields, this.val$dataLayoutRow.getDataLayoutColumns(), this.val$fieldTypeTracker, this.val$httpServletRequest, this.val$httpServletResponse));
            }
        }).collect(Collectors.toList());
    }

    private Map<String, DataDefinitionField> _getDataDefinitionFieldsMap(DataDefinition dataDefinition, Map<String, Object> dataRecordValues) {
        List<DataDefinitionField> dataDefinitionFields = Arrays.asList(dataDefinition.getDataDefinitionFields());
        Stream stream = dataDefinitionFields.stream();
        return stream.collect(Collectors.toMap(dataDefinitionField -> dataDefinitionField.getName(), definitionField -> {
            if (MapUtil.isEmpty((Map)dataRecordValues)) {
                return definitionField;
            }
            Map customProperties = definitionField.getCustomProperties();
            customProperties.put("value", dataRecordValues.get(definitionField.getName()));
            return definitionField;
        }));
    }

    private Set<String> _getDependencies() {
        Collection fieldTypes = this._fieldTypeTracker.getFieldTypes();
        Stream stream = fieldTypes.stream();
        return stream.filter(this::_hasJavascriptModule).map(this::_resolveFieldTypeModule).collect(Collectors.toSet());
    }

    private String _getJavaScriptModule(String moduleName) {
        if (Validator.isNull((String)moduleName)) {
            return "";
        }
        return this._npmResolver.resolveModuleName(moduleName);
    }

    private String _getSpriteMap(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String pathThemeImages = themeDisplay.getPathThemeImages();
        return pathThemeImages.concat("/clay/icons.svg");
    }

    private boolean _hasJavascriptModule(FieldType fieldType) {
        Map fieldTypeProperties = this._fieldTypeTracker.getFieldTypeProperties(fieldType.getName());
        return fieldTypeProperties.containsKey("data.engine.field.type.js.module");
    }

    private String _render(final DataDefinition dataDefinition, final DataLayout dataLayout, final DataLayoutRendererContext dataLayoutRendererContext) throws Exception {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        this._soyComponentRenderer.renderSoyComponent(dataLayoutRendererContext.getHttpServletRequest(), (Writer)writer, new ComponentDescriptor(_TEMPLATE_NAMESPACE, this._npmResolver.resolveModuleName(_MODULE_NAME), dataLayoutRendererContext.getContainerId(), this._getDependencies()), (Map)new HashMap(){
            {
                this.put("pages", DataLayoutRendererImpl.this._createDataLayoutPageContexts(DataLayoutRendererImpl.this._getDataDefinitionFieldsMap(dataDefinition, dataLayoutRendererContext.getDataRecordValues()), dataLayout.getDataLayoutPages(), DataLayoutRendererImpl.this._fieldTypeTracker, dataLayoutRendererContext.getHttpServletRequest(), dataLayoutRendererContext.getHttpServletResponse()));
                this.put("paginationMode", GetterUtil.getString((String)dataLayout.getPaginationMode(), (String)"single-page"));
                this.put("portletNamespace", dataLayoutRendererContext.getPortletNamespace());
                this.put("showSubmitButton", false);
                this.put("spritemap", DataLayoutRendererImpl.this._getSpriteMap(dataLayoutRendererContext.getHttpServletRequest()));
            }
        });
        DynamicIncludeUtil.include((HttpServletRequest)dataLayoutRendererContext.getHttpServletRequest(), (HttpServletResponse)dataLayoutRendererContext.getHttpServletResponse(), (String)(DDMFormRenderer.class.getName() + "#formRendered"), (boolean)true);
        return writer.toString();
    }

    private String _resolveFieldTypeModule(FieldType fieldType) {
        return this._getJavaScriptModule(MapUtil.getString((Map)this._fieldTypeTracker.getFieldTypeProperties(fieldType.getName()), (String)"data.engine.field.type.js.module"));
    }
}

