/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutPermission;
import com.liferay.data.engine.rest.resource.v1_0.DataLayoutResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseDataLayoutResourceImpl
implements DataLayoutResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<DataLayout> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseDataLayoutResourceImpl.class);

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public Page<DataLayout> getDataDefinitionDataLayoutsPage(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public DataLayout postDataDefinitionDataLayout(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, DataLayout dataLayout) throws Exception {
        return new DataLayout();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="DataLayout")})
    public Response postDataDefinitionDataLayoutBatch(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(DataLayout.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Path(value="/data-layouts/{dataLayoutId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public void deleteDataLayout(@NotNull @Parameter(hidden=true) @PathParam(value="dataLayoutId") Long dataLayoutId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/data-layouts/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="DataLayout")})
    public Response deleteDataLayoutBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(DataLayout.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Path(value="/data-layouts/{dataLayoutId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public DataLayout getDataLayout(@NotNull @Parameter(hidden=true) @PathParam(value="dataLayoutId") Long dataLayoutId) throws Exception {
        return new DataLayout();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Path(value="/data-layouts/{dataLayoutId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="DataLayout")})
    public DataLayout putDataLayout(@NotNull @Parameter(hidden=true) @PathParam(value="dataLayoutId") Long dataLayoutId, DataLayout dataLayout) throws Exception {
        return new DataLayout();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/data-layouts/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="DataLayout")})
    public Response putDataLayoutBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(DataLayout.class.getName(), callbackURL, object)).build();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId"), @Parameter(in=ParameterIn.QUERY, name="operation")})
    @Path(value="/data-layouts/{dataLayoutId}/data-layout-permissions")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public void postDataLayoutDataLayoutPermission(@NotNull @Parameter(hidden=true) @PathParam(value="dataLayoutId") Long dataLayoutId, @NotNull @Parameter(hidden=true) @QueryParam(value="operation") String operation, DataLayoutPermission dataLayoutPermission) throws Exception {
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="operation")})
    @Path(value="/sites/{siteId}/data-layout-permissions")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public void postSiteDataLayoutPermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @QueryParam(value="operation") String operation, DataLayoutPermission dataLayoutPermission) throws Exception {
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/data-layouts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public Page<DataLayout> getSiteDataLayoutsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="dataLayoutKey")})
    @Path(value="/sites/{siteId}/data-layouts/{dataLayoutKey}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataLayout")})
    public DataLayout getSiteDataLayout(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="dataLayoutKey") String dataLayoutKey) throws Exception {
        return new DataLayout();
    }

    public void create(Collection<DataLayout> dataLayouts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer dataLayoutUnsafeConsumer = dataLayout -> this.postDataDefinitionDataLayout(Long.parseLong((String)parameters.get("dataDefinitionId")), (DataLayout)dataLayout);
        for (DataLayout dataLayout2 : dataLayouts) {
            dataLayoutUnsafeConsumer.accept((Object)dataLayout2);
        }
    }

    public void delete(Collection<DataLayout> dataLayouts, Map<String, Serializable> parameters) throws Exception {
        for (DataLayout dataLayout : dataLayouts) {
            this.deleteDataLayout(dataLayout.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<DataLayout> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteId")) {
            return this.getSiteDataLayoutsPage((Long)parameters.get("siteId"), (String)((Object)parameters.get("keywords")), pagination, sorts);
        }
        return this.getDataDefinitionDataLayoutsPage(Long.parseLong((String)((Object)parameters.get("dataDefinitionId"))), (String)((Object)parameters.get("keywords")), pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<DataLayout> dataLayouts, Map<String, Serializable> parameters) throws Exception {
        for (DataLayout dataLayout : dataLayouts) {
            this.putDataLayout(dataLayout.getId() != null ? dataLayout.getId() : Long.parseLong((String)((Object)parameters.get("dataLayoutId"))), dataLayout);
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid filter " + filterString), (Throwable)exception);
            }
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

