/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.rest.dto.v1_0.DataListView;
import com.liferay.data.engine.rest.internal.odata.entity.v1_0.DataDefinitionEntityModel;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataListViewResourceImpl;
import com.liferay.data.engine.rest.resource.v1_0.DataListViewResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.data.engine.util.comparator.DEDataListViewCreateDateComparator;
import com.liferay.data.engine.util.comparator.DEDataListViewModifiedDateComparator;
import com.liferay.data.engine.util.comparator.DEDataListViewNameComparator;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-list-view.properties"}, scope=ServiceScope.PROTOTYPE, service={DataListViewResource.class})
public class DataListViewResourceImpl
extends BaseDataListViewResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new DataDefinitionEntityModel();
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    @Override
    public void deleteDataListView(Long dataListViewId) throws Exception {
        this._deDataListViewLocalService.deleteDEDataListView(dataListViewId.longValue());
    }

    @Override
    public Page<DataListView> getDataDefinitionDataListViewsPage(Long dataDefinitionId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._deDataListViewLocalService.getDEDataListViews(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), ddmStructure.getStructureId(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataListView), (Pagination)pagination, (long)this._deDataListViewLocalService.getDEDataListViewsCount(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), ddmStructure.getStructureId()));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DEDataListView.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setAttribute("ddmStructureId", (Serializable)dataDefinitionId);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{ddmStructure.getGroupId()});
        }, document -> this._toDataListView(this._deDataListViewLocalService.getDEDataListView(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public DataListView getDataListView(Long dataListViewId) throws Exception {
        return this._toDataListView(this._deDataListViewLocalService.getDEDataListView(dataListViewId.longValue()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataListView postDataDefinitionDataListView(Long dataDefinitionId, DataListView dataListView) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        dataListView = this._toDataListView(this._deDataListViewLocalService.addDEDataListView(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), PrincipalThreadLocal.getUserId(), MapUtil.toString((Map)dataListView.getAppliedFilters()), dataDefinitionId.longValue(), Arrays.toString(dataListView.getFieldNames()), LocalizedValueUtil.toLocaleStringMap((Map)dataListView.getName()), dataListView.getSortField()));
        for (String fieldName : dataListView.getFieldNames()) {
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(dataListView.getSiteId().longValue(), this._portal.getClassNameId(DEDataListView.class), dataListView.getId().longValue(), ddmStructure.getStructureId(), fieldName);
        }
        return dataListView;
    }

    @Override
    public DataListView putDataListView(Long dataListViewId, DataListView dataListView) throws Exception {
        return this._toDataListView(this._deDataListViewLocalService.updateDEDataListView(dataListViewId.longValue(), MapUtil.toString((Map)dataListView.getAppliedFilters()), Arrays.toString(dataListView.getFieldNames()), LocalizedValueUtil.toLocaleStringMap((Map)dataListView.getName()), dataListView.getSortField()));
    }

    private DataListView _toDataListView(final DEDataListView deDataListView) throws Exception {
        return new DataListView(){
            {
                this.appliedFilters = DataListViewResourceImpl.this._toMap(deDataListView.getAppliedFilters());
                this.dataDefinitionId = deDataListView.getDdmStructureId();
                this.dateCreated = deDataListView.getCreateDate();
                this.dateModified = deDataListView.getModifiedDate();
                this.fieldNames = JSONUtil.toStringArray((JSONArray)DataListViewResourceImpl.this._jsonFactory.createJSONArray(deDataListView.getFieldNames()));
                this.id = deDataListView.getPrimaryKey();
                this.name = LocalizedValueUtil.toStringObjectMap((Map)deDataListView.getNameMap());
                this.siteId = deDataListView.getGroupId();
                this.sortField = deDataListView.getSortField();
                this.userId = deDataListView.getUserId();
            }
        };
    }

    private Map<String, Object> _toMap(String json) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        Set keySet = jsonObject.keySet();
        for (String key : keySet) {
            map.put(key, jsonObject.get(key));
        }
        return map;
    }

    private OrderByComparator<DEDataListView> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new DEDataListViewCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new DEDataListViewNameComparator(ascending);
        }
        return new DEDataListViewModifiedDateComparator(ascending);
    }
}

