/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.content.type;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DataDefinitionContentTypeTracker.class})
public class DataDefinitionContentTypeTracker {
    private final Map<Long, DataDefinitionContentType> _dataDefinitionContentTypesByClassNameId = new TreeMap<Long, DataDefinitionContentType>();
    private final Map<String, DataDefinitionContentType> _dataDefinitionContentTypesByContentType = new TreeMap<String, DataDefinitionContentType>();
    @Reference
    private Portal _portal;

    public DataDefinitionContentType getDataDefinitionContentType(long classNameId) {
        return this._dataDefinitionContentTypesByClassNameId.get(classNameId);
    }

    public DataDefinitionContentType getDataDefinitionContentType(String contentType) {
        return this._dataDefinitionContentTypesByContentType.get(contentType);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDataDefinitionContentType(DataDefinitionContentType dataDefinitionContentType, Map<String, Object> properties) {
        if (!properties.containsKey("content.type")) {
            return;
        }
        this._dataDefinitionContentTypesByClassNameId.put(dataDefinitionContentType.getClassNameId(), dataDefinitionContentType);
        this._dataDefinitionContentTypesByContentType.put(MapUtil.getString(properties, (String)"content.type"), dataDefinitionContentType);
    }

    @Deactivate
    protected void deactivate() {
        this._dataDefinitionContentTypesByContentType.clear();
    }

    protected void removeDataDefinitionContentType(DataDefinitionContentType dataDefinitionContentType, Map<String, Object> properties) {
        this._dataDefinitionContentTypesByClassNameId.remove(dataDefinitionContentType.getClassNameId());
        this._dataDefinitionContentTypesByContentType.remove(MapUtil.getString(properties, (String)"content.type"));
    }
}

