/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v2_0.util;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ClassUtils;

public class DataRecordValuesUtil {
    public static DDMFormValues toDDMFormValues(Map<String, Object> dataRecordValues, DDMForm ddmForm, Locale locale) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        if (locale == null) {
            Set availableLocales = ddmForm.getAvailableLocales();
            Stream stream = availableLocales.stream();
            stream.forEach(arg_0 -> ((DDMFormValues)ddmFormValues).addAvailableLocale(arg_0));
            ddmFormValues.setDefaultLocale(ddmForm.getDefaultLocale());
        } else {
            ddmFormValues.addAvailableLocale(locale);
            ddmFormValues.setDefaultLocale(locale);
        }
        Map ddmFormFields = ddmForm.getDDMFormFieldsMap(true);
        for (Map.Entry entry : ddmFormFields.entrySet()) {
            List<DDMFormFieldValue> ddmFormFieldValues = DataRecordValuesUtil.createDDMFormFieldValues(dataRecordValues, (DDMFormField)entry.getValue(), locale);
            Stream stream = ddmFormFieldValues.stream();
            stream.forEach(arg_0 -> ((DDMFormValues)ddmFormValues).addDDMFormFieldValue(arg_0));
        }
        return ddmFormValues;
    }

    public static String toJSON(DataDefinition dataDefinition, Map<String, ?> dataRecordValues) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map dataDefinitionFields = Stream.of(dataDefinition.getDataDefinitionFields()).collect(Collectors.toMap(dataDefinitionField -> dataDefinitionField.getName(), Function.identity()));
        for (Map.Entry entry : dataDefinitionFields.entrySet()) {
            if (!dataRecordValues.containsKey(entry.getKey())) continue;
            DataDefinitionField dataDefinitionField2 = (DataDefinitionField)entry.getValue();
            if (dataDefinitionField2.getRepeatable().booleanValue()) {
                jsonObject.put(entry.getKey(), JSONFactoryUtil.createJSONArray((Object[])((Object[])dataRecordValues.get(entry.getKey()))));
                continue;
            }
            jsonObject.put(entry.getKey(), dataRecordValues.get(entry.getKey()));
        }
        return jsonObject.toString();
    }

    protected static List<DDMFormFieldValue> createDDMFormFieldValues(Map<String, Object> dataRecordValues, DDMFormField ddmFormField, Locale locale) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        String name = ddmFormField.getName();
        ddmFormFieldValue.setName(name);
        if (dataRecordValues == null || !dataRecordValues.containsKey(name)) {
            return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{ddmFormFieldValue});
        }
        if (ddmFormField.isRepeatable()) {
            Object[] instancesValue = null;
            if (ddmFormField.isLocalizable()) {
                Object value = dataRecordValues.get(name);
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("Field value is not a map");
                }
                Object[] localizedValues = (Object[])value;
                instancesValue = (Object[])localizedValues.get(LanguageUtil.getLanguageId((Locale)locale));
            } else {
                instancesValue = (Object[])dataRecordValues.get(name);
            }
            if (instancesValue == null) {
                return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{ddmFormFieldValue});
            }
            ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>(instancesValue.length);
            for (Object instanceValue : instancesValue) {
                ddmFormFieldValue = new DDMFormFieldValue();
                ddmFormFieldValue.setName(ddmFormField.getName());
                LocalizedValue localizedValue = new LocalizedValue();
                localizedValue.addString(locale, String.valueOf(instanceValue));
                ddmFormFieldValue.setValue((Value)localizedValue);
                ddmFormFieldValues.add(ddmFormFieldValue);
            }
            return ddmFormFieldValues;
        }
        ddmFormFieldValue.setValue(DataRecordValuesUtil.createValue(ddmFormField, locale, dataRecordValues.get(name)));
        if (ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) {
            for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                List<DDMFormFieldValue> ddmFormFieldValues = DataRecordValuesUtil.createDDMFormFieldValues(dataRecordValues, nestedDDMFormField, locale);
                Stream stream = ddmFormFieldValues.stream();
                stream.forEach(arg_0 -> ((DDMFormFieldValue)ddmFormFieldValue).addNestedDDMFormFieldValue(arg_0));
            }
        }
        return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{ddmFormFieldValue});
    }

    protected static LocalizedValue createLocalizedValue(Locale locale, Object value) {
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Field's value must be a map");
        }
        LocalizedValue localizedValue = new LocalizedValue();
        Map localizedValues = (Map)value;
        if (locale == null) {
            for (Map.Entry entry : localizedValues.entrySet()) {
                if (entry.getValue() instanceof Object[]) {
                    JSONArray jsonArray = JSONUtil.putAll((Object[])((Object[])entry.getValue()));
                    localizedValue.addString(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), jsonArray.toString());
                    continue;
                }
                localizedValue.addString(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), MapUtil.getString((Map)((Map)value), (String)((String)entry.getKey())));
            }
        } else {
            String languageId = LanguageUtil.getLanguageId((Locale)locale);
            if (!localizedValues.containsKey(languageId)) {
                return localizedValue;
            }
            if (localizedValues.get(languageId) instanceof Object[]) {
                JSONArray jsonArray = JSONUtil.putAll((Object[])((Object[])localizedValues.get(languageId)));
                localizedValue.addString(locale, jsonArray.toString());
            } else {
                localizedValue.addString(locale, MapUtil.getString((Map)((Map)value), (String)languageId));
            }
        }
        return localizedValue;
    }

    protected static Value createValue(DDMFormField ddmFormField, Locale locale, Object value) {
        if (value instanceof Object[]) {
            JSONArray jsonArray = JSONUtil.putAll((Object[])((Object[])value));
            value = jsonArray.toString();
        }
        if (ddmFormField.isLocalizable()) {
            return DataRecordValuesUtil.createLocalizedValue(locale, value);
        }
        if (!(value instanceof String) && ClassUtils.wrapperToPrimitive(value.getClass()) == null) {
            throw new IllegalArgumentException("Field's value must be a primitive value");
        }
        return new UnlocalizedValue(GetterUtil.getString((Object)value));
    }
}

