/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRow;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataDefinitionEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataDefinitionResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.data.engine.spi.resource.SPIDataLayoutResource;
import com.liferay.data.engine.spi.resource.SPIDataRecordCollectionResource;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.dynamic.data.mapping.util.comparator.StructureCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionResource.class})
public class DataDefinitionResourceImpl
extends BaseDataDefinitionResourceImpl
implements EntityModelResource {
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionResourceImpl.class);
    private static final EntityModel _entityModel = new DataDefinitionEntityModel();
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _ddmFormSerializer;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;

    @Override
    public void deleteDataDefinition(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "DELETE");
        this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(dataDefinitionId.longValue());
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        spiDataLayoutResource.deleteDataLayoutDataDefinition(dataDefinitionId.longValue());
        this._ddmStructureLocalService.deleteDDMStructure(dataDefinitionId.longValue());
        List ddmStructureVersions = this._ddmStructureVersionLocalService.getStructureVersions(dataDefinitionId.longValue());
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            this._ddmStructureVersionLocalService.deleteDDMStructureVersion(ddmStructureVersion);
        }
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(dataDefinitionId.longValue());
        this._deDataListViewLocalService.deleteDEDataListViews(dataDefinitionId.longValue());
    }

    @Override
    public DataDefinition getDataDefinition(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()));
    }

    @Override
    public Page<DataDefinition> getDataDefinitionByContentTypeContentTypePage(String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getSiteDataDefinitionByContentTypeContentTypePage(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, keywords, pagination, sorts);
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldFieldTypes() throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        Set ddmFormFieldTypeNames = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeNames();
        Stream stream = ddmFormFieldTypeNames.stream();
        stream.map(ddmFormFieldTypeName -> this._getFieldTypeMetadataJSONObject(this.contextAcceptLanguage, (String)ddmFormFieldTypeName, this.contextHttpServletRequest, this._getResourceBundle((String)ddmFormFieldTypeName, this.contextAcceptLanguage.getPreferredLocale()))).filter(jsonObject -> !jsonObject.getBoolean("system")).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray.toJSONString();
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldLinks(Long dataDefinitionId, String fieldName) throws Exception {
        return JSONUtil.put((String)"dataLayouts", this.transformToArray(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._getClassNameId(dataDefinitionId), dataDefinitionId.longValue(), fieldName), deDataDefinitionFieldLink -> {
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getDDMStructureLayout(deDataDefinitionFieldLink.getClassPK());
            return ddmStructureLayout.getName(ddmStructureLayout.getDefaultLanguageId());
        }, String.class)).put("dataListViews", this.transformToArray(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId.longValue(), fieldName), deDataDefinitionFieldLink -> {
            DEDataListView deDataListView = this._deDataListViewLocalService.getDEDataListView(deDataDefinitionFieldLink.getClassPK());
            return deDataListView.getName(deDataListView.getDefaultLanguageId());
        }, String.class)).toString();
    }

    @Override
    public Page<Permission> getDataDefinitionPermissionsPage(Long dataDefinitionId, String roleNames) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataDefinitionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataDefinition getSiteDataDefinitionByContentTypeByDataDefinitionKey(Long siteId, String contentType, String dataDefinitionKey) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(contentType);
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(siteId.longValue(), dataDefinitionContentType.getClassNameId(), dataDefinitionKey));
    }

    @Override
    public Page<DataDefinition> getSiteDataDefinitionByContentTypeContentTypePage(Long siteId, String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(contentType);
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLocalService.getStructures(siteId.longValue(), dataDefinitionContentType.getClassNameId(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataDefinition), (Pagination)pagination, (long)this._ddmStructureLocalService.getStructuresCount(siteId.longValue(), dataDefinitionContentType.getClassNameId()));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, DDMStructure.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"classNameId", "entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(dataDefinitionContentType.getClassNameId()));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, (Sort[])sorts, document -> DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public DataDefinition postDataDefinitionByContentType(String contentType, DataDefinition dataDefinition) throws Exception {
        return this.postSiteDataDefinitionByContentType(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, dataDefinition);
    }

    @Override
    public DataDefinition postSiteDataDefinitionByContentType(Long siteId, String contentType, DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), contentType, (long)siteId, "ADD_DATA_DEFINITION");
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(contentType);
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)DataDefinitionUtil.toDDMForm(dataDefinition, this._ddmFormFieldTypeServicesTracker));
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(PrincipalThreadLocal.getUserId(), siteId.longValue(), 0L, dataDefinitionContentType.getClassNameId(), dataDefinition.getDataDefinitionKey(), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), GetterUtil.getString((String)dataDefinition.getStorageType(), (String)"json"), new ServiceContext());
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            dataLayout.setDataLayoutKey(ddmStructure.getStructureKey());
            SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
            dataLayout = (DataLayout)spiDataLayoutResource.addDataLayout(ddmStructure.getStructureId(), DataLayoutUtil.serialize(dataLayout, this._ddmFormLayoutSerializer), dataLayout.getDataLayoutKey(), dataLayout.getDescription(), dataLayout.getName());
            dataDefinition.setDefaultDataLayout(dataLayout);
        }
        dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, ddmStructure);
        this._resourceLocalService.addResources(this.contextCompany.getCompanyId(), siteId.longValue(), PrincipalThreadLocal.getUserId(), ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(dataDefinitionContentType.getClassNameId()), DDMStructure.class.getName()}), dataDefinition.getId().longValue(), false, false, false);
        SPIDataRecordCollectionResource spiDataRecordCollectionResource = new SPIDataRecordCollectionResource(this._ddlRecordSetLocalService, this._ddmStructureLocalService, this._portal, this._resourceLocalService, DataRecordCollectionUtil::toDataRecordCollection);
        spiDataRecordCollectionResource.addDataRecordCollection(dataDefinition.getId().longValue(), dataDefinition.getDataDefinitionKey(), dataDefinition.getDescription(), dataDefinition.getName());
        return dataDefinition;
    }

    @Override
    public DataDefinition putDataDefinition(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "UPDATE");
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
            dataLayout = (DataLayout)spiDataLayoutResource.updateDataLayout(Optional.ofNullable(dataLayout.getId()).orElse(this._getDefaultDataLayoutId(dataDefinitionId, (SPIDataLayoutResource<DataLayout>)spiDataLayoutResource)).longValue(), DataLayoutUtil.serialize(dataLayout, this._ddmFormLayoutSerializer), dataLayout.getDescription(), dataLayout.getName());
            dataDefinition.setDefaultDataLayout(dataLayout);
        }
        this._updateFieldNames(dataDefinitionId, dataDefinition);
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)DataDefinitionUtil.toDDMForm(dataDefinition, this._ddmFormFieldTypeServicesTracker));
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.updateStructure(PrincipalThreadLocal.getUserId(), dataDefinitionId.longValue(), 0L, LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), new ServiceContext()));
    }

    @Override
    public void putDataDefinitionPermission(Long dataDefinitionId, Permission[] permissions) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), 0L, resourceName, String.valueOf(dataDefinitionId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)dataDefinitionId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ddmStructure.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDMStructure.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject _createFieldContextJSONObject(DDMFormFieldType ddmFormFieldType, HttpServletRequest httpServletRequest, Locale locale, String type) {
        Locale originalThemeDisplayLocale = LocaleThreadLocal.getThemeDisplayLocale();
        LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
        try {
            DDMForm ddmFormFieldTypeSettingsDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
            DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
            ddmFormRenderingContext.setContainerId("settings");
            DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create(httpServletRequest, ddmFormFieldTypeSettingsDDMForm);
            this._setTypeDDMFormFieldValue(ddmFormValues, type);
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
            ddmFormRenderingContext.setHttpServletRequest(httpServletRequest);
            ddmFormRenderingContext.setLocale(locale);
            ddmFormRenderingContext.setPortletNamespace(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"portletNamespace"));
            ddmFormRenderingContext.setReturnFullContext(true);
            JSONObject jSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerializeDeep((Object)this._ddmFormTemplateContextFactory.create(ddmFormFieldTypeSettingsDDMForm, DDMFormLayoutFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings()), ddmFormRenderingContext)));
            return jSONObject;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        finally {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)originalThemeDisplayLocale);
        }
        return null;
    }

    private long _getClassNameId(long dataDefinitionId) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId);
        return ddmStructure.getClassNameId();
    }

    private long _getDefaultDataLayoutId(long dataDefinitionId, SPIDataLayoutResource<DataLayout> spiDataLayoutResource) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId);
        DataLayout dataLayout = (DataLayout)spiDataLayoutResource.getDataLayout(ddmStructure.getClassNameId(), ddmStructure.getStructureKey(), ddmStructure.getGroupId());
        return dataLayout.getId();
    }

    private JSONObject _getFieldTypeMetadataJSONObject(AcceptLanguage acceptLanguage, String ddmFormFieldName, HttpServletRequest httpServletRequest, ResourceBundle resourceBundle) {
        Map ddmFormFieldTypeProperties = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeProperties(ddmFormFieldName);
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldName);
        return JSONUtil.put((String)"description", (Object)this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.description"), resourceBundle)).put("displayOrder", MapUtil.getInteger((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.display.order", (int)Integer.MAX_VALUE)).put("group", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.group")).put("icon", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.icon")).put("javaScriptModule", this._resolveModuleName(ddmFormFieldType)).put("label", this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.label"), resourceBundle)).put("name", ddmFormFieldName).put("scope", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.scope")).put("settingsContext", this._createFieldContextJSONObject(ddmFormFieldType, httpServletRequest, acceptLanguage.getPreferredLocale(), ddmFormFieldName)).put("system", MapUtil.getBoolean((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.system"));
    }

    private String[] _getRemovedFieldNames(DataDefinition dataDefinition, DDMStructure ddmStructure) throws Exception {
        DataDefinition existingDataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, ddmStructure);
        return this._removeFieldNames((String[])this.transform(existingDataDefinition.getDataDefinitionFields(), dataDefinitionField -> dataDefinitionField.getName(), String.class), (String[])this.transform(dataDefinition.getDataDefinitionFields(), dataDefinitionField -> dataDefinitionField.getName(), String.class));
    }

    private ResourceBundle _getResourceBundle(String ddmFormFieldTypeName, Locale locale) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldTypeName);
        return new AggregateResourceBundle(new ResourceBundle[]{ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass()), ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ddmFormFieldType.getClass()), this._portal.getResourceBundle(locale)});
    }

    private SPIDataLayoutResource _getSPIDataLayoutResource() {
        return new SPIDataLayoutResource(this._ddmStructureLayoutLocalService, this._ddmStructureLocalService, this._ddmStructureVersionLocalService, this._deDataDefinitionFieldLinkLocalService, DataLayoutUtil::toDataLayout);
    }

    private String[] _removeFieldNames(String[] currentFieldNames, String[] removedFieldNames) {
        return (String[])ArrayUtil.filter((Object[])currentFieldNames, fieldName -> !ArrayUtil.contains((Object[])removedFieldNames, (Object)fieldName));
    }

    private String _resolveModuleName(DDMFormFieldType ddmFormFieldType) {
        if (Validator.isNull((String)ddmFormFieldType.getModuleName())) {
            return "";
        }
        if (ddmFormFieldType.isCustomDDMFormFieldType()) {
            return ddmFormFieldType.getModuleName();
        }
        return this._npmResolver.resolveModuleName(ddmFormFieldType.getModuleName());
    }

    private void _setTypeDDMFormFieldValue(DDMFormValues ddmFormValues, String type) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("type");
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValue.setValue((Value)new UnlocalizedValue(type));
    }

    private DataDefinition _toDataDefinition(DDMStructure ddmStructure) throws Exception {
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, ddmStructure);
    }

    private OrderByComparator<DDMStructure> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureNameComparator(ascending);
        }
        return new StructureModifiedDateComparator(ascending);
    }

    private String _translate(String key, ResourceBundle resourceBundle) {
        if (Validator.isNull((String)key)) {
            return "";
        }
        return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key), (String)key);
    }

    private void _updateDataLayoutFieldNames(DataLayout dataLayout, String[] removedFieldNames) {
        Stream<DataLayoutPage> dataLayoutPages = Arrays.stream(dataLayout.getDataLayoutPages());
        dataLayoutPages.forEach(dataLayoutPage -> {
            Stream<DataLayoutRow> dataLayoutRows = Arrays.stream(dataLayoutPage.getDataLayoutRows());
            dataLayoutRows.forEach(dataLayoutRow -> {
                Stream<DataLayoutColumn> dataLayoutColumns = Arrays.stream(dataLayoutRow.getDataLayoutColumns());
                dataLayoutColumns.forEach(dataLayoutColumn -> dataLayoutColumn.setFieldNames(this._removeFieldNames(dataLayoutColumn.getFieldNames(), removedFieldNames)));
                dataLayoutRow.setDataLayoutColumns((DataLayoutColumn[])ArrayUtil.filter((Object[])dataLayoutRow.getDataLayoutColumns(), column -> !ArrayUtil.isEmpty((Object[])column.getFieldNames())));
            });
            dataLayoutPage.setDataLayoutRows((DataLayoutRow[])ArrayUtil.filter((Object[])dataLayoutPage.getDataLayoutRows(), row -> !ArrayUtil.isEmpty((Object[])row.getDataLayoutColumns())));
        });
    }

    private void _updateDataLayouts(Set<Long> ddmStructureLayoutIds, String[] removedFieldNames) throws Exception {
        for (Long ddmStructureLayoutId : ddmStructureLayoutIds) {
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(ddmStructureLayoutId.longValue());
            DataLayout dataLayout = DataLayoutUtil.toDataLayout(ddmStructureLayout.getDDMFormLayout());
            this._updateDataLayoutFieldNames(dataLayout, removedFieldNames);
            DDMFormLayout ddmFormLayout = DataLayoutUtil.toDDMFormLayout(dataLayout);
            DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
            DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(builder.build());
            ddmStructureLayout.setDefinition(ddmFormLayoutSerializerSerializeResponse.getContent());
            this._ddmStructureLayoutLocalService.updateDDMStructureLayout(ddmStructureLayout);
        }
    }

    private void _updateDataListViews(Set<Long> deDataListViewIds, String[] removedFieldNames) throws PortalException {
        for (Long deDataListViewId : deDataListViewIds) {
            DEDataListView deDataListView = this._deDataListViewLocalService.getDEDataListView(deDataListViewId.longValue());
            String[] fieldNames = JSONUtil.toStringArray((JSONArray)this._jsonFactory.createJSONArray(deDataListView.getFieldNames()));
            deDataListView.setFieldNames(Arrays.toString(this._removeFieldNames(fieldNames, removedFieldNames)));
            this._deDataListViewLocalService.updateDEDataListView(deDataListView);
        }
    }

    private void _updateFieldNames(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        String[] removedFieldNames = this._getRemovedFieldNames(dataDefinition, ddmStructure);
        HashSet<Long> ddmStructureLayoutIds = new HashSet<Long>();
        HashSet<Long> deDataListViewIds = new HashSet<Long>();
        for (String removedFieldName : removedFieldNames) {
            ddmStructureLayoutIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._getClassNameId(dataDefinitionId), ddmStructure.getStructureId(), removedFieldName), deDataDefinitionFieldLink -> deDataDefinitionFieldLink.getClassPK()));
            deDataListViewIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), ddmStructure.getStructureId(), removedFieldName), deDataDefinitionFieldLink -> deDataDefinitionFieldLink.getClassPK()));
            this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._getClassNameId(dataDefinitionId), ddmStructure.getStructureId(), removedFieldName);
            this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), ddmStructure.getStructureId(), removedFieldName);
        }
        this._updateDataLayouts(ddmStructureLayoutIds, removedFieldNames);
        this._updateDataListViews(deDataListViewIds, removedFieldNames);
    }
}

