/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataLayoutEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataLayoutResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.resource.v2_0.DataLayoutResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.data.engine.spi.resource.SPIDataLayoutResource;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-layout.properties"}, scope=ServiceScope.PROTOTYPE, service={DataLayoutResource.class})
public class DataLayoutResourceImpl
extends BaseDataLayoutResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new DataLayoutEntityModel();
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;

    @Override
    public void deleteDataLayout(Long dataLayoutId) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DDMStructure ddmStructure = ddmStructureLayout.getDDMStructure();
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructure.getStructureId(), "DELETE");
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        spiDataLayoutResource.deleteDataLayout(dataLayoutId.longValue(), ddmStructure);
    }

    @Override
    public Page<DataLayout> getDataDefinitionDataLayoutsPage(Long dataDefinitionId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        return spiDataLayoutResource.getDataLayouts(dataDefinitionId.longValue(), keywords, this.contextAcceptLanguage.getPreferredLocale(), pagination, sorts);
    }

    @Override
    public DataLayout getDataLayout(Long dataLayoutId) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructureLayout.getDDMStructureId(), "VIEW");
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        return (DataLayout)spiDataLayoutResource.getDataLayout(dataLayoutId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataLayout getSiteDataLayoutByContentTypeByDataLayoutKey(Long siteId, String contentType, String dataLayoutKey) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(contentType);
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(siteId.longValue(), dataDefinitionContentType.getClassNameId(), dataLayoutKey);
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructureLayout.getDDMStructureId(), "VIEW");
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        return (DataLayout)spiDataLayoutResource.getDataLayout(dataDefinitionContentType.getClassNameId(), dataLayoutKey, siteId.longValue());
    }

    @Override
    public DataLayout postDataDefinitionDataLayout(Long dataDefinitionId, DataLayout dataLayout) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), ddmStructure, "ADD_DATA_DEFINITION");
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        return (DataLayout)spiDataLayoutResource.addDataLayout(dataDefinitionId.longValue(), DataLayoutUtil.serialize(dataLayout, this._ddmFormLayoutSerializer), dataLayout.getDataLayoutKey(), dataLayout.getDescription(), dataLayout.getName());
    }

    @Override
    public DataLayout putDataLayout(Long dataLayoutId, DataLayout dataLayout) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructureLayout.getDDMStructureId(), "UPDATE");
        SPIDataLayoutResource spiDataLayoutResource = this._getSPIDataLayoutResource();
        return (DataLayout)spiDataLayoutResource.updateDataLayout(dataLayoutId.longValue(), DataLayoutUtil.serialize(dataLayout, this._ddmFormLayoutSerializer), dataLayout.getDescription(), dataLayout.getName());
    }

    private SPIDataLayoutResource _getSPIDataLayoutResource() {
        return new SPIDataLayoutResource(this._ddmStructureLayoutLocalService, this._ddmStructureLocalService, this._ddmStructureVersionLocalService, this._deDataDefinitionFieldLinkLocalService, DataLayoutUtil::toDataLayout);
    }
}

