/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataRecordCollectionResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataRecordCollectionModelResourcePermission;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordCollectionResource;
import com.liferay.data.engine.spi.resource.SPIDataRecordCollectionResource;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-record-collection.properties"}, scope=ServiceScope.PROTOTYPE, service={DataRecordCollectionResource.class})
public class DataRecordCollectionResourceImpl
extends BaseDataRecordCollectionResourceImpl {
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference
    private DataRecordCollectionModelResourcePermission _dataRecordCollectionModelResourcePermission;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;

    @Override
    public void deleteDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "DELETE");
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        spiDataRecordCollectionResource.deleteDataRecordCollection(dataRecordCollectionId);
    }

    @Override
    public DataRecordCollection getDataDefinitionDataRecordCollection(Long dataDefinitionId) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(ddmStructure.getGroupId(), ddmStructure.getStructureKey()));
    }

    @Override
    public Page<DataRecordCollection> getDataDefinitionDataRecordCollectionsPage(Long dataDefinitionId, String keywords, Pagination pagination) throws Exception {
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        return spiDataRecordCollectionResource.getDataRecordCollections(dataDefinitionId.longValue(), keywords, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public DataRecordCollection getDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "VIEW");
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        return (DataRecordCollection)spiDataRecordCollectionResource.getDataRecordCollection(dataRecordCollectionId.longValue());
    }

    @Override
    public String getDataRecordCollectionPermissionByCurrentUser(Long dataRecordCollectionId) throws Exception {
        JSONArray actionIdsJSONArray = JSONFactoryUtil.createJSONArray();
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        String resourceName = this._getResourceName(ddlRecordSet);
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        for (ResourceAction resourceAction : resourceActions) {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (!permissionChecker.hasPermission(ddlRecordSet.getGroupId(), resourceName, dataRecordCollectionId.longValue(), resourceAction.getActionId())) continue;
            actionIdsJSONArray.put(resourceAction.getActionId());
        }
        return actionIdsJSONArray.toString();
    }

    @Override
    public Page<Permission> getDataRecordCollectionPermissionsPage(Long dataRecordCollectionId, String roleNames) throws Exception {
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        DataRecordCollection dataRecordCollection = (DataRecordCollection)spiDataRecordCollectionResource.getDataRecordCollection(dataRecordCollectionId.longValue());
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollection.getDataDefinitionId(), "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataRecordCollectionId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataRecordCollectionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @Override
    public DataRecordCollection getSiteDataRecordCollectionByDataRecordCollectionKey(Long siteId, String dataRecordCollectionKey) throws Exception {
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        return (DataRecordCollection)spiDataRecordCollectionResource.getSiteDataRecordCollection(dataRecordCollectionKey, siteId.longValue());
    }

    @Override
    public DataRecordCollection postDataDefinitionDataRecordCollection(Long dataDefinitionId, DataRecordCollection dataRecordCollection) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), ddmStructure, "ADD_DATA_RECORD_COLLECTION");
        String dataRecordCollectionKey = dataRecordCollection.getDataRecordCollectionKey();
        if (Validator.isNull((String)dataRecordCollectionKey)) {
            dataRecordCollectionKey = ddmStructure.getStructureKey();
        }
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        return (DataRecordCollection)spiDataRecordCollectionResource.addDataRecordCollection(dataDefinitionId.longValue(), dataRecordCollectionKey, dataRecordCollection.getDescription(), dataRecordCollection.getName());
    }

    @Override
    public DataRecordCollection putDataRecordCollection(Long dataRecordCollectionId, DataRecordCollection dataRecordCollection) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "UPDATE");
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        return (DataRecordCollection)spiDataRecordCollectionResource.updateDataRecordCollection(dataRecordCollectionId.longValue(), dataRecordCollection.getDescription(), dataRecordCollection.getName());
    }

    @Override
    public void putDataRecordCollectionPermission(Long dataRecordCollectionId, Permission[] permissions) throws Exception {
        SPIDataRecordCollectionResource<DataRecordCollection> spiDataRecordCollectionResource = this._getSPIDataRecordCollectionResource();
        DataRecordCollection dataRecordCollection = (DataRecordCollection)spiDataRecordCollectionResource.getDataRecordCollection(dataRecordCollectionId.longValue());
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollection.getDataDefinitionId(), "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataRecordCollectionId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), 0L, resourceName, String.valueOf(dataRecordCollectionId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)dataRecordCollectionId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(((Long)id).longValue());
        return ddlRecordSet.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(((Long)id).longValue());
        return this._getResourceName(ddlRecordSet);
    }

    private String _getResourceName(DDLRecordSet ddlRecordSet) throws PortalException {
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDLRecordSet.class.getName()});
    }

    private SPIDataRecordCollectionResource<DataRecordCollection> _getSPIDataRecordCollectionResource() {
        return new SPIDataRecordCollectionResource(this._ddlRecordSetLocalService, this._ddmStructureLocalService, this._portal, this._resourceLocalService, DataRecordCollectionUtil::toDataRecordCollection);
    }
}

