/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.security.permission.resource;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={DataDefinitionModelResourcePermission.class})
public class DataDefinitionModelResourcePermission
implements ModelResourcePermission<DDMStructure> {
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public void check(PermissionChecker permissionChecker, DDMStructure ddmStructure, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ddmStructure, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._getModelResourceName(ddmStructure), ddmStructure.getStructureId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, this._ddmStructureLocalService.getDDMStructure(primaryKey), actionId);
    }

    public void checkPortletPermission(PermissionChecker permissionChecker, DDMStructure ddmStructure, String actionId) throws PortalException {
        this.checkPortletPermission(permissionChecker, this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId()), ddmStructure.getGroupId(), actionId);
    }

    public void checkPortletPermission(PermissionChecker permissionChecker, String contentType, long groupId, String actionId) throws PortalException {
        this.checkPortletPermission(permissionChecker, this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(contentType), groupId, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, DDMStructure ddmStructure, String actionId) throws PortalException {
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId());
        if (dataDefinitionContentType == null) {
            return false;
        }
        return dataDefinitionContentType.hasPermission(permissionChecker, ddmStructure.getCompanyId(), ddmStructure.getGroupId(), this._getModelResourceName(ddmStructure), ddmStructure.getStructureId(), ddmStructure.getUserId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ddmStructureLocalService.getDDMStructure(primaryKey), actionId);
    }

    public String getModelName() {
        return DDMStructure.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }

    protected void checkPortletPermission(PermissionChecker permissionChecker, DataDefinitionContentType dataDefinitionContentType, long groupId, String actionId) throws PortalException {
        if (dataDefinitionContentType == null) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{actionId});
        }
        if (!dataDefinitionContentType.hasPortletPermission(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, dataDefinitionContentType.getContentType(), groupId, new String[]{actionId});
        }
    }

    private String _getModelResourceName(DDMStructure ddmStructure) {
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), this.getModelName()});
    }
}

