/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage;

import com.liferay.data.engine.storage.DataStorage;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DataStorageTracker.class})
public class DataStorageTracker {
    private final Map<String, DataStorage> _dataStorages = new TreeMap<String, DataStorage>();

    public DataStorage getDataStorage(String dataStorageType) {
        return this._dataStorages.get(dataStorageType);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDataStorage(DataStorage dataStorage, Map<String, Object> properties) {
        String dataStorageType = MapUtil.getString(properties, (String)"data.storage.type");
        this._dataStorages.put(dataStorageType, dataStorage);
    }

    @Deactivate
    protected void deactivate() {
        this._dataStorages.clear();
    }

    protected void removeDataStorage(DataStorage dataStorage, Map<String, Object> properties) {
        String dataStorageType = MapUtil.getString(properties, (String)"data.storage.type");
        this._dataStorages.remove(dataStorageType);
    }
}

