/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v2_0.util;

import com.google.gson.Gson;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRow;
import com.liferay.data.engine.rest.dto.v2_0.DataRule;
import com.liferay.dynamic.data.mapping.form.builder.rule.DDMFormRuleDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRule;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataLayoutUtil {
    public static String serialize(DataLayout dataLayout, DDMForm ddmForm, DDMFormLayoutSerializer ddmFormLayoutSerializer, DDMFormRuleDeserializer ddmFormRuleDeserializer) throws Exception {
        DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)DataLayoutUtil.toDDMFormLayout(dataLayout, ddmForm, ddmFormRuleDeserializer));
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = ddmFormLayoutSerializer.serialize(builder.build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    public static DataLayout toDataLayout(final DDMFormLayout ddmFormLayout, final SPIDDMFormRuleConverter spiDDMFormRuleConverter) throws Exception {
        return new DataLayout(){
            {
                this.dataLayoutPages = DataLayoutUtil._toDataLayoutPages(ddmFormLayout.getDDMFormLayoutPages());
                this.dataRules = DataLayoutUtil._toDataRules(ddmFormLayout.getDDMFormRules(), spiDDMFormRuleConverter);
                this.paginationMode = ddmFormLayout.getPaginationMode();
            }
        };
    }

    public static DataLayout toDataLayout(DDMStructureLayout ddmStructureLayout, SPIDDMFormRuleConverter spiDDMFormRuleConverter) throws Exception {
        if (ddmStructureLayout == null) {
            return null;
        }
        DataLayout dataLayout = DataLayoutUtil.toDataLayout(ddmStructureLayout.getDDMFormLayout(), spiDDMFormRuleConverter);
        dataLayout.setDateCreated(ddmStructureLayout.getCreateDate());
        dataLayout.setDataDefinitionId(Long.valueOf(ddmStructureLayout.getDDMStructureId()));
        dataLayout.setDataLayoutKey(ddmStructureLayout.getStructureLayoutKey());
        dataLayout.setDateModified(ddmStructureLayout.getModifiedDate());
        dataLayout.setDescription(LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getDescriptionMap()));
        dataLayout.setId(Long.valueOf(ddmStructureLayout.getStructureLayoutId()));
        dataLayout.setName(LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getNameMap()));
        dataLayout.setSiteId(Long.valueOf(ddmStructureLayout.getGroupId()));
        dataLayout.setUserId(Long.valueOf(ddmStructureLayout.getUserId()));
        return dataLayout;
    }

    public static DDMFormLayout toDDMFormLayout(DataLayout dataLayout, DDMForm ddmForm, DDMFormRuleDeserializer ddmFormRuleDeserializer) throws Exception {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        ddmFormLayout.setDDMFormLayoutPages(DataLayoutUtil._toDDMFormLayoutPages(dataLayout.getDataLayoutPages(), ddmForm.getDefaultLocale()));
        ddmFormLayout.setDefaultLocale(ddmForm.getDefaultLocale());
        ddmFormLayout.setPaginationMode(dataLayout.getPaginationMode());
        ddmFormLayout.setDDMFormRules(ddmFormRuleDeserializer.deserialize(ddmForm, JSONUtil.toJSONArray((Object[])dataLayout.getDataRules(), rule -> DataLayoutUtil._serializeRule(rule))));
        return ddmFormLayout;
    }

    private static JSONObject _serializeRule(DataRule dataRule) throws JSONException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Gson gson = new Gson();
        return jsonObject.put("actions", (Object)dataRule.getActions()).put("conditions", (Object)dataRule.getConditions()).put("logical-operator", dataRule.getLogicalOperator()).put("name", JSONFactoryUtil.createJSONObject((String)gson.toJson((Object)dataRule.getName())));
    }

    private static DataLayoutColumn _toDataLayoutColumn(final DDMFormLayoutColumn ddmFormLayoutColumn) {
        return new DataLayoutColumn(){
            {
                this.columnSize = ddmFormLayoutColumn.getSize();
                this.fieldNames = ArrayUtil.toStringArray((Collection)ddmFormLayoutColumn.getDDMFormFieldNames());
            }
        };
    }

    private static DataLayoutColumn[] _toDataLayoutColumns(List<DDMFormLayoutColumn> ddmFormLayoutColumns) {
        if (ListUtil.isEmpty(ddmFormLayoutColumns)) {
            return new DataLayoutColumn[0];
        }
        Stream stream = ddmFormLayoutColumns.stream();
        return stream.map(DataLayoutUtil::_toDataLayoutColumn).collect(Collectors.toList()).toArray(new DataLayoutColumn[0]);
    }

    private static DataLayoutPage _toDataLayoutPage(final DDMFormLayoutPage ddmFormLayoutPage) {
        return new DataLayoutPage(){
            {
                this.dataLayoutRows = DataLayoutUtil._toDataLayoutRows(ddmFormLayoutPage.getDDMFormLayoutRows());
                this.description = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormLayoutPage.getDescription());
                this.title = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormLayoutPage.getTitle());
            }
        };
    }

    private static DataLayoutPage[] _toDataLayoutPages(List<DDMFormLayoutPage> ddmFormLayoutPages) {
        if (ListUtil.isEmpty(ddmFormLayoutPages)) {
            return new DataLayoutPage[0];
        }
        Stream stream = ddmFormLayoutPages.stream();
        return stream.map(DataLayoutUtil::_toDataLayoutPage).collect(Collectors.toList()).toArray(new DataLayoutPage[0]);
    }

    private static DataLayoutRow _toDataLayoutRow(final DDMFormLayoutRow ddmFormLayoutRow) {
        return new DataLayoutRow(){
            {
                this.dataLayoutColumns = DataLayoutUtil._toDataLayoutColumns(ddmFormLayoutRow.getDDMFormLayoutColumns());
            }
        };
    }

    private static DataLayoutRow[] _toDataLayoutRows(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        Stream stream = ddmFormLayoutRows.stream();
        return stream.map(DataLayoutUtil::_toDataLayoutRow).collect(Collectors.toList()).toArray(new DataLayoutRow[0]);
    }

    private static DataRule[] _toDataRules(List<DDMFormRule> ddmFormRules, SPIDDMFormRuleConverter spiDDMFormRuleConverter) {
        Object[] dataRules = new DataRule[]{};
        for (SPIDDMFormRule spiDDMFormRule : spiDDMFormRuleConverter.convert(ddmFormRules)) {
            DataRule dataRule = new DataRule();
            Gson gson = new Gson();
            dataRule.setActions((Map[])Stream.of(spiDDMFormRule.getSPIDDMFormRuleActions()).flatMap(Collection::stream).map(spiDDMFormRuleAction -> (Map)gson.fromJson(JSONFactoryUtil.looseSerializeDeep((Object)spiDDMFormRuleAction), Map.class)).toArray(Map[]::new));
            dataRule.setConditions((Map[])Stream.of(spiDDMFormRule.getSPIDDMFormRuleConditions()).flatMap(Collection::stream).map(spiDDMFormRuleCondition -> (Map)gson.fromJson(JSONFactoryUtil.looseSerializeDeep((Object)spiDDMFormRuleCondition), Map.class)).toArray(Map[]::new));
            dataRule.setLogicalOperator(spiDDMFormRule.getLogicalOperator());
            dataRule.setName(LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)spiDDMFormRule.getName()));
            dataRules = (DataRule[])ArrayUtil.append((Object[])dataRules, (Object)dataRule);
        }
        return dataRules;
    }

    private static DDMFormLayoutColumn _toDDMFormLayoutColumn(DataLayoutColumn dataLayoutColumn) {
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn();
        ddmFormLayoutColumn.setDDMFormFieldNames(Arrays.asList(dataLayoutColumn.getFieldNames()));
        ddmFormLayoutColumn.setSize(dataLayoutColumn.getColumnSize().intValue());
        return ddmFormLayoutColumn;
    }

    private static List<DDMFormLayoutColumn> _toDDMFormLayoutColumns(DataLayoutColumn[] dataLayoutColumns) {
        if (ArrayUtil.isEmpty((Object[])dataLayoutColumns)) {
            return Collections.emptyList();
        }
        return Stream.of(dataLayoutColumns).map(DataLayoutUtil::_toDDMFormLayoutColumn).collect(Collectors.toList());
    }

    private static DDMFormLayoutPage _toDDMFormLayoutPage(DataLayoutPage dataLayoutPage, Locale locale) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        ddmFormLayoutPage.setDDMFormLayoutRows(DataLayoutUtil._toDDMFormLayoutRows(dataLayoutPage.getDataLayoutRows()));
        ddmFormLayoutPage.setDescription(LocalizedValueUtil.toLocalizedValue((Map)dataLayoutPage.getDescription(), (Locale)locale));
        ddmFormLayoutPage.setTitle(LocalizedValueUtil.toLocalizedValue((Map)dataLayoutPage.getTitle(), (Locale)locale));
        return ddmFormLayoutPage;
    }

    private static List<DDMFormLayoutPage> _toDDMFormLayoutPages(DataLayoutPage[] dataLayoutPages, Locale locale) {
        if (ArrayUtil.isEmpty((Object[])dataLayoutPages)) {
            return Collections.emptyList();
        }
        return Stream.of(dataLayoutPages).map(dataLayoutPage -> DataLayoutUtil._toDDMFormLayoutPage(dataLayoutPage, locale)).collect(Collectors.toList());
    }

    private static DDMFormLayoutRow _toDDMFormLayoutRow(DataLayoutRow dataLayoutRow) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        ddmFormLayoutRow.setDDMFormLayoutColumns(DataLayoutUtil._toDDMFormLayoutColumns(dataLayoutRow.getDataLayoutColumns()));
        return ddmFormLayoutRow;
    }

    private static List<DDMFormLayoutRow> _toDDMFormLayoutRows(DataLayoutRow[] dataLayoutRows) {
        if (ArrayUtil.isEmpty((Object[])dataLayoutRows)) {
            return Collections.emptyList();
        }
        return Stream.of(dataLayoutRows).map(DataLayoutUtil::_toDDMFormLayoutRow).collect(Collectors.toList());
    }
}

