/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataRecordCollectionResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataRecordCollectionModelResourcePermission;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordCollectionResource;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.validation.ValidationException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-record-collection.properties"}, scope=ServiceScope.PROTOTYPE, service={DataRecordCollectionResource.class})
public class DataRecordCollectionResourceImpl
extends BaseDataRecordCollectionResourceImpl {
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference
    private DataRecordCollectionModelResourcePermission _dataRecordCollectionModelResourcePermission;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;

    @Override
    public void deleteDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "DELETE");
        this._deleteDataRecordCollection(dataRecordCollectionId);
    }

    @Override
    public DataRecordCollection getDataDefinitionDataRecordCollection(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "VIEW");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(ddmStructure.getGroupId(), ddmStructure.getStructureKey()));
    }

    @Override
    public Page<DataRecordCollection> getDataDefinitionDataRecordCollectionsPage(Long dataDefinitionId, String keywords, Pagination pagination) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "VIEW");
        return this._getDataRecordCollections(dataDefinitionId, keywords, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public DataRecordCollection getDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "VIEW");
        return this._getDataRecordCollection(dataRecordCollectionId);
    }

    @Override
    public String getDataRecordCollectionPermissionByCurrentUser(Long dataRecordCollectionId) throws Exception {
        JSONArray actionIdsJSONArray = JSONFactoryUtil.createJSONArray();
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        String resourceName = this._getResourceName(ddlRecordSet);
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        for (ResourceAction resourceAction : resourceActions) {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (!permissionChecker.hasPermission(ddlRecordSet.getGroupId(), resourceName, dataRecordCollectionId.longValue(), resourceAction.getActionId())) continue;
            actionIdsJSONArray.put(resourceAction.getActionId());
        }
        return actionIdsJSONArray.toString();
    }

    @Override
    public Page<Permission> getDataRecordCollectionPermissionsPage(Long dataRecordCollectionId, String roleNames) throws Exception {
        DataRecordCollection dataRecordCollection = this._getDataRecordCollection(dataRecordCollectionId);
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollection.getDataDefinitionId(), "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataRecordCollectionId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataRecordCollectionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @Override
    public DataRecordCollection getSiteDataRecordCollectionByDataRecordCollectionKey(Long siteId, String dataRecordCollectionKey) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(siteId.longValue(), dataRecordCollectionKey);
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddlRecordSet.getRecordSetId(), "VIEW");
        return this._getSiteDataRecordCollection(dataRecordCollectionKey, siteId);
    }

    @Override
    public DataRecordCollection postDataDefinitionDataRecordCollection(Long dataDefinitionId, DataRecordCollection dataRecordCollection) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), ddmStructure, "ADD_DATA_RECORD_COLLECTION");
        String dataRecordCollectionKey = dataRecordCollection.getDataRecordCollectionKey();
        if (Validator.isNull((String)dataRecordCollectionKey)) {
            dataRecordCollectionKey = ddmStructure.getStructureKey();
        }
        return this._addDataRecordCollection(dataDefinitionId, dataRecordCollectionKey, dataRecordCollection.getDescription(), dataRecordCollection.getName());
    }

    @Override
    public DataRecordCollection putDataRecordCollection(Long dataRecordCollectionId, DataRecordCollection dataRecordCollection) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "UPDATE");
        return this._updateDataRecordCollection(dataRecordCollectionId, dataRecordCollection.getDescription(), dataRecordCollection.getName());
    }

    @Override
    public Page<Permission> putDataRecordCollectionPermissionsPage(Long dataRecordCollectionId, Permission[] permissions) throws Exception {
        DataRecordCollection dataRecordCollection = this._getDataRecordCollection(dataRecordCollectionId);
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollection.getDataDefinitionId(), "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataRecordCollectionId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), 0L, resourceName, String.valueOf(dataRecordCollectionId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)dataRecordCollectionId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDataRecordCollectionPermissionsPage", resourceName, dataRecordCollectionId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDataRecordCollectionPermissionsPage", resourceName, dataRecordCollectionId)).build(), dataRecordCollectionId, resourceName, null);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(((Long)id).longValue());
        return ddlRecordSet.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(((Long)id).longValue());
        return this._getResourceName(ddlRecordSet);
    }

    private DataRecordCollection _addDataRecordCollection(long dataDefinitionId, String dataRecordCollectionKey, Map<String, Object> description, Map<String, Object> name) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId);
        ServiceContext serviceContext = new ServiceContext();
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.addRecordSet(PrincipalThreadLocal.getUserId(), ddmStructure.getGroupId(), dataDefinitionId, dataRecordCollectionKey, LocalizedValueUtil.toLocaleStringMap(name), LocalizedValueUtil.toLocaleStringMap(description), 0, 3, serviceContext);
        if (this._isDataRecordCollectionPermissionCheckingEnabled(ddmStructure)) {
            this._resourceLocalService.addModelResources(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), PrincipalThreadLocal.getUserId(), this._getResourceName(ddlRecordSet), ddlRecordSet.getPrimaryKey(), serviceContext.getModelPermissions());
        }
        return DataRecordCollectionUtil.toDataRecordCollection(ddlRecordSet);
    }

    private void _deleteDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._ddlRecordSetLocalService.deleteRecordSet(dataRecordCollectionId.longValue());
    }

    private DataRecordCollection _getDataRecordCollection(long dataRecordCollectionId) throws Exception {
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId));
    }

    private Page<DataRecordCollection> _getDataRecordCollections(long dataDefinitionId, String keywords, Locale locale, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)locale, (String)"page-size-is-greater-than-x", (Object)250));
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId);
        if (Validator.isNull((String)keywords)) {
            return Page.of((Collection)TransformUtil.transform((Collection)this._ddlRecordSetLocalService.search(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), keywords, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), DataRecordCollectionUtil::toDataRecordCollection), (Pagination)pagination, (long)this._ddlRecordSetLocalService.searchCount(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), keywords, 3));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DDLRecordSet.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setAttribute("DDMStructureId", (Serializable)Long.valueOf(ddmStructure.getStructureId()));
            searchContext.setAttribute("scope", (Serializable)Integer.valueOf(3));
            searchContext.setCompanyId(ddmStructure.getCompanyId());
            searchContext.setGroupIds(new long[]{ddmStructure.getGroupId()});
        }, document -> DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(GetterUtil.getLong((String)document.get("entryClassPK")))), null);
    }

    private String _getResourceName(DDLRecordSet ddlRecordSet) throws Exception {
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDLRecordSet.class.getName()});
    }

    private DataRecordCollection _getSiteDataRecordCollection(String dataRecordCollectionKey, long siteId) throws Exception {
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(siteId, dataRecordCollectionKey));
    }

    private boolean _isDataRecordCollectionPermissionCheckingEnabled(DDMStructure ddmStructure) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId());
        return dataDefinitionContentType.isDataRecordCollectionPermissionCheckingEnabled();
    }

    private DataRecordCollection _updateDataRecordCollection(long dataRecordCollectionId, Map<String, Object> description, Map<String, Object> name) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(PrincipalThreadLocal.getUserId());
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.updateRecordSet(dataRecordCollectionId, ddlRecordSet.getDDMStructureId(), LocalizedValueUtil.toLocaleStringMap(name), LocalizedValueUtil.toLocaleStringMap(description), 0, serviceContext));
    }
}

