/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage.util;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataStorageUtil {
    private static final Log _log = LogFactoryUtil.getLog(DataStorageUtil.class);

    public static Map<String, Object> toDataRecordValues(DDMFormValues ddmFormValues, DDMStructure ddmStructure) throws PortalException {
        if (ddmFormValues == null) {
            return Collections.emptyMap();
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DataStorageUtil._addMissingDDMFormFieldValues(ddmForm.getDDMFormFields(), ddmFormValues);
        Map ddmFormFields = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        HashMap<String, Object> values = new HashMap<String, Object>(ddmFormFields.size());
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            DataStorageUtil._addValues(ddmFormFields, ddmFormFieldValue, values);
        }
        return values;
    }

    public static String toJSON(DataDefinition dataDefinition, Map<String, ?> dataRecordValues) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map dataDefinitionFields = Stream.of(dataDefinition.getDataDefinitionFields()).collect(Collectors.toMap(dataDefinitionField -> dataDefinitionField.getName(), Function.identity()));
        for (Map.Entry entry : dataDefinitionFields.entrySet()) {
            if (!dataRecordValues.containsKey(entry.getKey())) continue;
            DataDefinitionField dataDefinitionField2 = (DataDefinitionField)entry.getValue();
            if (dataDefinitionField2.getRepeatable().booleanValue()) {
                jsonObject.put(entry.getKey(), JSONFactoryUtil.createJSONArray((Collection)((List)dataRecordValues.get(entry.getKey()))));
                continue;
            }
            jsonObject.put(entry.getKey(), dataRecordValues.get(entry.getKey()));
        }
        return jsonObject.toString();
    }

    private static void _addMissingDDMFormFieldValues(List<DDMFormField> ddmFormFields, DDMFormValues ddmFormValues) {
        Map ddmFormFieldValues = ddmFormValues.getDDMFormFieldValuesMap(false);
        for (final DDMFormField ddmFormField : ddmFormFields) {
            if (ddmFormFieldValues.containsKey(ddmFormField.getName()) || DataStorageUtil._isFieldSet(ddmFormField)) continue;
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setInstanceId(StringUtil.randomString());
                    this.setName(ddmFormField.getName());
                }
            };
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            if (!ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
            DataStorageUtil._addMissingDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, ddmFormFieldValue);
        }
    }

    private static void _addMissingDDMFormFieldValues(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValues, DDMFormFieldValue parentDDMFormFieldValue) {
        for (final DDMFormField ddmFormField : ddmFormFields) {
            if (ddmFormFieldValues.containsKey(ddmFormField.getName())) continue;
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setInstanceId(StringUtil.randomString());
                    this.setName(ddmFormField.getName());
                }
            };
            parentDDMFormFieldValue.addNestedDDMFormFieldValue(ddmFormFieldValue);
            if (!ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
            DataStorageUtil._addMissingDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, ddmFormFieldValue);
        }
    }

    private static void _addValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        if (ddmFormField == null) {
            return;
        }
        String name = ddmFormField.getName();
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            values.put(name, null);
            return;
        }
        if (ddmFormField.isRepeatable()) {
            if (ddmFormField.isLocalizable()) {
                Map localizedValues = values.getOrDefault(name, new HashMap());
                LocalizedValue localizedValue = (LocalizedValue)value;
                Set availableLocales = localizedValue.getAvailableLocales();
                for (Locale locale : availableLocales) {
                    String languageId = LanguageUtil.getLanguageId((Locale)locale);
                    List list = localizedValues.getOrDefault(languageId, new ArrayList());
                    list.add(localizedValue.getString(locale));
                    localizedValues.put(languageId, list);
                }
                values.put(name, localizedValues);
            } else {
                List list = values.getOrDefault(name, new ArrayList());
                list.add(value.getString(value.getDefaultLocale()));
                values.put(name, list);
            }
        } else if (ddmFormField.isLocalizable()) {
            values.put(name, DataStorageUtil._toLocalizedMap(ddmFormField.getType(), (LocalizedValue)value));
        } else {
            values.put(name, value.getString(value.getDefaultLocale()));
        }
    }

    private static void _addValues(Map<String, DDMFormField> ddmFormFields, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        DDMFormField ddmFormField = ddmFormFields.get(ddmFormFieldValue.getName());
        if (ddmFormField != null && StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            Map fieldSetInstanceValues;
            if (ListUtil.isEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) {
                return;
            }
            if (!values.containsKey(ddmFormField.getName())) {
                values.put(ddmFormField.getName(), new HashMap());
            }
            if (!(fieldSetInstanceValues = (Map)values.get(ddmFormField.getName())).containsKey(ddmFormFieldValue.getInstanceId())) {
                fieldSetInstanceValues.put(ddmFormFieldValue.getInstanceId(), new HashMap());
            }
            for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                DataStorageUtil._addValues(ddmFormFields, nestedDDMFormFieldValue, (Map)fieldSetInstanceValues.get(ddmFormFieldValue.getInstanceId()));
            }
        } else {
            DataStorageUtil._addValue(ddmFormField, ddmFormFieldValue, values);
        }
    }

    private static boolean _isFieldSet(DDMFormField ddmFormField) {
        return GetterUtil.getBoolean((Object)ddmFormField.getProperty("upgradedStructure")) || Validator.isNotNull((Object)ddmFormField.getProperty("ddmStructureId"));
    }

    private static Map<String, Object> _toLocalizedMap(String fieldType, LocalizedValue localizedValue) {
        Set availableLocales = localizedValue.getAvailableLocales();
        Stream stream = availableLocales.stream();
        if (fieldType.equals("checkbox_multiple") || fieldType.equals("select")) {
            return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, locale -> DataStorageUtil._toStringList(locale, localizedValue)));
        }
        return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, arg_0 -> ((LocalizedValue)localizedValue).getString(arg_0)));
    }

    private static List<String> _toStringList(Locale locale, LocalizedValue localizedValue) {
        try {
            return JSONUtil.toStringList((JSONArray)JSONFactoryUtil.createJSONArray((String)localizedValue.getString(locale)));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return Collections.emptyList();
        }
    }
}

