/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.strategy;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;

public interface MapToDDMFormValuesConverterStrategy {
    default public LocalizedValue createLocalizedValue(Locale locale, Object value) {
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Field's value must be a map");
        }
        LocalizedValue localizedValue = new LocalizedValue();
        Map localizedValues = (Map)value;
        if (locale == null) {
            for (Map.Entry entry : localizedValues.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((Map)((Map)entry.getValue()));
                    localizedValue.addString(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), jsonObject.toString());
                    continue;
                }
                if (entry.getValue() instanceof Object[]) {
                    JSONArray jsonArray = JSONUtil.putAll((Object[])((Object[])entry.getValue()));
                    localizedValue.addString(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), jsonArray.toString());
                    continue;
                }
                localizedValue.addString(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), MapUtil.getString((Map)((Map)value), (String)((String)entry.getKey())));
            }
        } else {
            String languageId = LanguageUtil.getLanguageId((Locale)locale);
            if (!localizedValues.containsKey(languageId)) {
                return localizedValue;
            }
            if (localizedValues.get(languageId) instanceof Object[]) {
                JSONArray jsonArray = JSONUtil.putAll((Object[])((Object[])localizedValues.get(languageId)));
                localizedValue.addString(locale, jsonArray.toString());
            } else {
                localizedValue.addString(locale, MapUtil.getString((Map)((Map)value), (String)languageId));
            }
        }
        return localizedValue;
    }

    default public Value createValue(DDMFormField ddmFormField, Locale locale, Object value) {
        if (value instanceof Object[]) {
            value = JSONUtil.putAll((Object[])((Object[])value)).toString();
        }
        if (ddmFormField.isLocalizable()) {
            return this.createLocalizedValue(locale, value);
        }
        if (!(value instanceof String) && ClassUtils.wrapperToPrimitive(value.getClass()) == null) {
            throw new IllegalArgumentException("Field's value must be a primitive value");
        }
        return new UnlocalizedValue(GetterUtil.getString((Object)value));
    }

    public void setDDMFormFieldValues(Map<String, Object> var1, DDMForm var2, DDMFormValues var3, Locale var4);
}

