/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.content.type;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.resource.exception.DataDefinitionValidationException;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DataDefinitionContentTypeRegistryUtil {
    private static final ServiceTrackerMap<String, DataDefinitionContentType> _serviceTrackerMap;

    public static Long getClassNameId(String contentType) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(contentType);
        Long id = dataDefinitionContentType.getClassNameId();
        if (id == null) {
            throw new DataDefinitionValidationException.MustSetValidContentType(contentType);
        }
        return id;
    }

    public static DataDefinitionContentType getDataDefinitionContentType(long classNameId) {
        for (DataDefinitionContentType dataDefinitionContentType : _serviceTrackerMap.values()) {
            if (dataDefinitionContentType.getClassNameId() != classNameId) continue;
            return dataDefinitionContentType;
        }
        return null;
    }

    public static DataDefinitionContentType getDataDefinitionContentType(String contentType) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = (DataDefinitionContentType)_serviceTrackerMap.getService((Object)contentType);
        if (dataDefinitionContentType == null) {
            throw new DataDefinitionValidationException.MustSetValidContentType(contentType);
        }
        return dataDefinitionContentType;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(DataDefinitionContentTypeRegistryUtil.class);
        BundleContext bundleContext = bundle.getBundleContext();
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DataDefinitionContentType.class, (String)"content.type");
    }
}

