/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v2_0.util;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.util.SettingsDDMFormFieldsUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataDefinitionFieldUtil {
    private static final String[] _PREDEFINED_PROPERTIES = new String[]{"indexType", "label", "localizable", "name", "predefinedValue", "readOnly", "repeatable", "required", "showLabel", "tip", "type"};
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionFieldUtil.class);

    public static Object getEditorConfig(String ddmFormFieldType, HttpServletRequest httpServletRequest) throws Exception {
        if (httpServletRequest == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            ServicePreAction servicePreAction = new ServicePreAction();
            DummyHttpServletResponse httpServletResponse = new DummyHttpServletResponse();
            servicePreAction.servicePre(httpServletRequest, (HttpServletResponse)httpServletResponse, false);
            ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
            themeServicePreAction.run(httpServletRequest, (HttpServletResponse)httpServletResponse);
            themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay == null) {
                return null;
            }
        }
        EditorConfiguration editorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)"", (String)ddmFormFieldType, (String)"ckeditor_classic", new HashMap(), (ThemeDisplay)themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest));
        Map data = editorConfiguration.getData();
        return data.get("editorConfig");
    }

    public static DataDefinitionField toDataDefinitionField(final DDMFormField ddmFormField, final DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry, final DDMStructureLayoutLocalService ddmStructureLayoutLocalService, final HttpServletRequest httpServletRequest) throws Exception {
        return new DataDefinitionField(){
            {
                this.setCustomProperties(() -> DataDefinitionFieldUtil._getCustomProperties(ddmFormField.getProperties(), ddmFormField.getType(), ddmFormField.getProperty("ddmStructureLayoutId"), ddmStructureLayoutLocalService, httpServletRequest, SettingsDDMFormFieldsUtil.getSettingsDDMFormFields((DDMFormFieldTypeServicesRegistry)ddmFormFieldTypeServicesRegistry, (String)ddmFormField.getType())));
                this.setDefaultValue(() -> LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getPredefinedValue()));
                this.setFieldType(() -> ((DDMFormField)ddmFormField).getType());
                this.setIndexable(() -> Validator.isNotNull((String)ddmFormField.getIndexType()));
                this.setIndexType(() -> DataDefinitionField.IndexType.create((String)ddmFormField.getIndexType()));
                this.setLabel(() -> LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getLabel()));
                this.setLocalizable(() -> ((DDMFormField)ddmFormField).isLocalizable());
                this.setName(() -> ((DDMFormField)ddmFormField).getName());
                this.setNestedDataDefinitionFields(() -> (DataDefinitionField[])TransformUtil.transformToArray((Collection)ddmFormField.getNestedDDMFormFields(), ddmFormField -> DataDefinitionFieldUtil.toDataDefinitionField(ddmFormField, ddmFormFieldTypeServicesRegistry, ddmStructureLayoutLocalService, httpServletRequest), DataDefinitionField.class));
                this.setReadOnly(() -> ((DDMFormField)ddmFormField).isReadOnly());
                this.setRepeatable(() -> ((DDMFormField)ddmFormField).isRepeatable());
                this.setRequired(() -> ((DDMFormField)ddmFormField).isRequired());
                this.setShowLabel(() -> ((DDMFormField)ddmFormField).isShowLabel());
                this.setTip(() -> LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getTip()));
            }
        };
    }

    private static Map<String, Object> _getCustomProperties(Map<String, Object> ddmFormFieldProperties, String ddmFormFieldType, Object ddmStructureLayoutId, DDMStructureLayoutLocalService ddmStructureLayoutLocalService, HttpServletRequest httpServletRequest, Map<String, DDMFormField> settingsDDMFormFieldsMap) throws Exception {
        HashMap<String, Object> customProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : ddmFormFieldProperties.entrySet()) {
            DDMFormField settingsDDMFormField;
            if (ArrayUtil.contains((Object[])_PREDEFINED_PROPERTIES, (Object)entry.getKey()) || (settingsDDMFormField = settingsDDMFormFieldsMap.get(entry.getKey())) == null) continue;
            if (settingsDDMFormField.isLocalizable()) {
                customProperties.put(entry.getKey(), LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)((LocalizedValue)entry.getValue())));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getDataType(), "boolean")) {
                customProperties.put(entry.getKey(), GetterUtil.getBoolean((Object)entry.getValue()));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getDataType(), "ddm-options")) {
                DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)entry.getValue();
                if (ddmFormFieldOptions == null || SetUtil.isEmpty((Set)ddmFormFieldOptions.getOptionsValues())) {
                    customProperties.put(entry.getKey(), Collections.emptyMap());
                    continue;
                }
                HashMap<String, List> options = new HashMap<String, List>();
                for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
                    LocalizedValue localizedValue = ddmFormFieldOptions.getOptionLabels(optionValue);
                    for (Locale locale : localizedValue.getAvailableLocales()) {
                        List values = options.computeIfAbsent(LanguageUtil.getLanguageId((Locale)locale), languageId -> new ArrayList());
                        values.add(JSONUtil.put((String)"label", (Object)localizedValue.getString(locale)).put("reference", ddmFormFieldOptions.getOptionReference(optionValue)).put("value", optionValue));
                    }
                }
                customProperties.put(entry.getKey(), options);
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getType(), "select") || Objects.equals(ddmFormFieldType, "fieldset") && Objects.equals(settingsDDMFormField.getName(), "rows")) {
                JSONArray jsonArray;
                block16: {
                    jsonArray = JSONFactoryUtil.createJSONArray();
                    try {
                        jsonArray = JSONFactoryUtil.createJSONArray((String)String.valueOf(entry.getValue()));
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block16;
                        _log.debug((Throwable)exception);
                    }
                }
                customProperties.put(entry.getKey(), jsonArray);
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getType(), "validation")) {
                DDMFormFieldValidation ddmFormFieldValidation = (DDMFormFieldValidation)entry.getValue();
                if (ddmFormFieldValidation == null) {
                    customProperties.put(entry.getKey(), Collections.emptyMap());
                    continue;
                }
                customProperties.put(entry.getKey(), HashMapBuilder.put((Object)"errorMessage", (Object)LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormFieldValidation.getErrorMessageLocalizedValue())).put((Object)"expression", () -> {
                    DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
                    if (ddmFormFieldValidationExpression == null) {
                        return Collections.emptyMap();
                    }
                    return HashMapBuilder.put((Object)"name", (Object)ddmFormFieldValidationExpression.getName()).put((Object)"value", (Object)ddmFormFieldValidationExpression.getValue()).build();
                }).put((Object)"parameter", (Object)LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormFieldValidation.getParameterLocalizedValue())).build());
                continue;
            }
            customProperties.put(entry.getKey(), entry.getValue());
        }
        if (Validator.isNotNull((Object)ddmStructureLayoutId)) {
            String rows;
            block17: {
                rows = "";
                try {
                    DDMStructureLayout ddmStructureLayout = ddmStructureLayoutLocalService.getStructureLayout(GetterUtil.getLong((Object)ddmStructureLayoutId));
                    rows = String.valueOf(JSONUtil.getValueAsJSONArray((Object)JSONFactoryUtil.createJSONObject((String)StringUtil.replace((String)ddmStructureLayout.getDefinition(), (String)"fieldNames", (String)"fields")), (String[])new String[]{"JSONArray/pages", "Object/0", "JSONArray/rows"}));
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block17;
                    _log.debug((Throwable)portalException);
                }
            }
            customProperties.put("rows", rows);
        }
        if (StringUtil.equals((String)ddmFormFieldType, (String)"rich_text")) {
            customProperties.put("editorConfig", DataDefinitionFieldUtil.getEditorConfig(ddmFormFieldType, httpServletRequest));
        }
        return customProperties;
    }
}

