/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v2_0.util;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistryUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionFieldUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DataDefinitionUtil {
    public static DataDefinition toDataDefinition(final DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry, final DDMStructure ddmStructure, final DDMStructureLayoutLocalService ddmStructureLayoutLocalService, final HttpServletRequest httpServletRequest, final SPIDDMFormRuleConverter spiDDMFormRuleConverter) throws Exception {
        final DDMForm ddmForm = ddmStructure.getDDMForm();
        return new DataDefinition(){
            {
                this.setAvailableLanguageIds(() -> (String[])TransformUtil.transformToArray((Collection)ddmForm.getAvailableLocales(), LanguageUtil::getLanguageId, String.class));
                this.setContentType(() -> {
                    DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId());
                    if (dataDefinitionContentType == null) {
                        return null;
                    }
                    return dataDefinitionContentType.getContentType();
                });
                this.setDataDefinitionFields(() -> (DataDefinitionField[])TransformUtil.transformToArray((Collection)ddmForm.getDDMFormFields(), ddmFormField -> DataDefinitionFieldUtil.toDataDefinitionField(ddmFormField, ddmFormFieldTypeServicesRegistry, ddmStructureLayoutLocalService, httpServletRequest), DataDefinitionField.class));
                this.setDataDefinitionKey(() -> ((DDMStructure)ddmStructure).getStructureKey());
                this.setDateCreated(() -> ((DDMStructure)ddmStructure).getCreateDate());
                this.setDateModified(() -> ((DDMStructure)ddmStructure).getModifiedDate());
                this.setDefaultDataLayout(() -> DataLayoutUtil.toDataLayout(ddmFormFieldTypeServicesRegistry, ddmStructure.fetchDDMStructureLayout(), spiDDMFormRuleConverter));
                this.setDefaultLanguageId(() -> LanguageUtil.getLanguageId((Locale)ddmForm.getDefaultLocale()));
                this.setDescription(() -> LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap()));
                this.setId(() -> ((DDMStructure)ddmStructure).getStructureId());
                this.setName(() -> LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap()));
                this.setSiteId(() -> ((DDMStructure)ddmStructure).getGroupId());
                this.setStorageType(() -> ((DDMStructure)ddmStructure).getStorageType());
                this.setUserId(() -> ((DDMStructure)ddmStructure).getUserId());
            }
        };
    }
}

