/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.google.gson.Gson;
import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.model.DEDataDefinitionFieldLinkModel;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRow;
import com.liferay.data.engine.rest.dto.v2_0.DataListView;
import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.dto.v2_0.util.DataDefinitionDDMFormUtil;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistryUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionFieldUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataDefinitionEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataDefinitionResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.util.DataDefinitionPermissionUtil;
import com.liferay.data.engine.rest.resource.exception.DataDefinitionValidationException;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionResource;
import com.liferay.data.engine.rest.resource.v2_0.DataLayoutResource;
import com.liferay.data.engine.rest.resource.v2_0.DataListViewResource;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordCollectionResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.exception.RequiredStructureException;
import com.liferay.dynamic.data.mapping.form.builder.rule.DDMFormRuleDeserializer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.dynamic.data.mapping.util.comparator.StructureCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionResource.class})
public class DataDefinitionResourceImpl
extends BaseDataDefinitionResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionResourceImpl.class);
    private static final EntityModel _entityModel = new DataDefinitionEntityModel();
    @Reference
    private DataLayoutResource.Factory _dataLayoutResourceFactory;
    @Reference
    private DataListViewResource.Factory _dataListViewResourceFactory;
    @Reference
    private DataRecordCollectionResource.Factory _dataRecordCollectionResourceFactory;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference
    private DDMFormRuleDeserializer _ddmFormRuleDeserializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _ddmFormSerializer;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DDMFormValidator _ddmFormValidator;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    @Override
    public void deleteDataDefinition(Long dataDefinitionId) throws Exception {
        DataDefinitionPermissionUtil.check(PermissionThreadLocal.getPermissionChecker(), this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue()), "DELETE");
        List ddmStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(dataDefinitionId.longValue());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId());
        List deDataDefinitionFieldLinks = ListUtil.filter((List)this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(dataDefinitionId.longValue()), deDataDefinitionFieldLink -> StringUtil.equals((String)deDataDefinitionFieldLink.getClassName(), (String)DDMStructure.class.getName()));
        if (ddmStructureLinks.size() > 1 || !dataDefinitionContentType.allowReferencedDataDefinitionDeletion() && !deDataDefinitionFieldLinks.isEmpty()) {
            throw new RequiredStructureException.MustNotDeleteStructureReferencedByStructureLinks(dataDefinitionId.longValue());
        }
        List ddmTemplates = this._ddmTemplateLocalService.getTemplates(dataDefinitionId.longValue());
        if (!ddmTemplates.isEmpty()) {
            throw new RequiredStructureException.MustNotDeleteStructureReferencedByTemplates(dataDefinitionId.longValue());
        }
        List ddmStructures = this._ddmStructureLocalService.getChildrenStructures(dataDefinitionId.longValue());
        if (!ddmStructures.isEmpty()) {
            throw new RequiredStructureException.MustNotDeleteStructureThatHasChild(dataDefinitionId.longValue());
        }
        DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
        dataLayoutResource.deleteDataDefinitionDataLayout(dataDefinitionId);
        DataListViewResource.Builder dataListViewResourceBuilder = this._dataListViewResourceFactory.create();
        DataListViewResource dataListViewResource = dataListViewResourceBuilder.checkPermissions(false).user(this.contextUser).build();
        dataListViewResource.deleteDataDefinitionDataListView(dataDefinitionId);
        this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(dataDefinitionId.longValue());
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue());
        for (DEDataDefinitionFieldLink deDataDefinitionFieldLink2 : deDataDefinitionFieldLinks) {
            this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLink(deDataDefinitionFieldLink2);
            if (deDataDefinitionFieldLink2.getClassNameId() != this._portal.getClassNameId(DDMStructure.class)) continue;
            DataDefinition dataDefinition = this._toDataDefinition(this._ddmStructureLocalService.getStructure(deDataDefinitionFieldLink2.getClassPK()));
            dataDefinition.setDataDefinitionFields((DataDefinitionField[])ArrayUtil.filter((Object[])dataDefinition.getDataDefinitionFields(), dataDefinitionField -> !StringUtil.equals((String)dataDefinitionField.getName(), (String)deDataDefinitionFieldLink2.getFieldName())));
            this._removeFieldsFromDataLayoutsAndDataListViews(deDataDefinitionFieldLink2.getClassPK(), this._getRemovedFieldNames(dataDefinition, dataDefinition.getId()));
            this._updateDataDefinition(dataDefinition, dataDefinition.getId(), DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry));
        }
        this._ddmStructureLocalService.deleteStructure(dataDefinitionId.longValue());
    }

    @Override
    public DataDefinition getDataDefinition(Long dataDefinitionId) throws Exception {
        DataDefinitionPermissionUtil.check(PermissionThreadLocal.getPermissionChecker(), this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue()), "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
    }

    @Override
    public Page<DataDefinition> getDataDefinitionByContentTypeContentTypePage(String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getSiteDataDefinitionByContentTypeContentTypePage(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, keywords, pagination, sorts);
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldFieldTypes() throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String ddmFormFieldTypeName : this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldTypeNames()) {
            jsonArray.put(this._getFieldTypeMetadataJSONObject(ddmFormFieldTypeName, this._getResourceBundle(ddmFormFieldTypeName, this.contextAcceptLanguage.getPreferredLocale())));
        }
        return jsonArray.toString();
    }

    @Override
    public Page<Permission> getDataDefinitionPermissionsPage(Long dataDefinitionId, String roleNames) throws Exception {
        DataDefinitionPermissionUtil.check(PermissionThreadLocal.getPermissionChecker(), this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue()), "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataDefinitionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataDefinition getSiteDataDefinitionByContentTypeByDataDefinitionKey(Long siteId, String contentType, String dataDefinitionKey) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(siteId.longValue(), DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType).longValue(), dataDefinitionKey);
        DataDefinitionPermissionUtil.check(PermissionThreadLocal.getPermissionChecker(), ddmStructure, "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, ddmStructure, this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
    }

    @Override
    public Page<DataDefinition> getSiteDataDefinitionByContentTypeContentTypePage(Long siteId, String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLocalService.getStructures(siteId.longValue(), DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType).longValue(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataDefinition), (Pagination)pagination, (long)this._ddmStructureLocalService.getStructuresCount(siteId.longValue(), DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType).longValue()));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DDMStructure.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"classNameId", "entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, (Sort[])sorts, document -> DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)document.get("entryClassPK"))), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter));
    }

    @Override
    public DataDefinition postDataDefinitionByContentType(String contentType, DataDefinition dataDefinition) throws Exception {
        return this.postSiteDataDefinitionByContentType(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, dataDefinition);
    }

    @Override
    public DataDefinition postDataDefinitionCopy(Long dataDefinitionId) throws Exception {
        DataDefinition dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
        this._uniquifyDataDefinitionFields(dataDefinition);
        dataDefinition.setDataDefinitionKey("");
        return this._postSiteDataDefinitionByContentType(dataDefinition.getSiteId(), dataDefinition.getContentType(), dataDefinition, true);
    }

    @Override
    public DataDefinition postSiteDataDefinitionByContentType(Long siteId, String contentType, DataDefinition dataDefinition) throws Exception {
        return this._postSiteDataDefinitionByContentType(siteId, contentType, dataDefinition, false);
    }

    @Override
    public DataDefinition putDataDefinition(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        DataDefinitionPermissionUtil.check(PermissionThreadLocal.getPermissionChecker(), this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue()), "UPDATE");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId());
        this._normalizeDataDefinitionFields(dataDefinitionContentType.getContentType(), dataDefinition.getDataDefinitionFields(), ddmStructure.getGroupId(), this._journalArticleLocalService.getStructureArticlesCount(ddmStructure.getGroupId(), ddmStructure.getStructureId()));
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
            dataDefinition.setDefaultDataLayout(dataLayoutResource.putDataLayout(Long.valueOf(this._getDefaultDataLayoutId(dataDefinitionId, dataLayout)), dataLayout));
        }
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(ddmStructure.getDefinition());
        DDMForm ddmForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry);
        ddmForm.setAllowInvalidAvailableLocalesForProperty(dataDefinitionContentType.allowInvalidAvailableLocalesForProperty());
        ddmForm.setDefinitionSchemaVersion(definitionJSONObject.getString("definitionSchemaVersion"));
        this._validate(dataDefinition, dataDefinitionContentType, ddmForm);
        this._removeFieldsFromDataLayoutsAndDataListViews(dataDefinitionId, this._getRemovedFieldNames(dataDefinition, dataDefinitionId));
        this._sortNestedDDMFormFields(ddmForm.getDDMFormFields());
        dataDefinition = this._updateDataDefinition(dataDefinition, dataDefinitionId, ddmForm);
        Iterator iterator = this._deDataDefinitionFieldLinkLocalService.getClassPKS(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue()).iterator();
        while (iterator.hasNext()) {
            long classPK = (Long)iterator.next();
            DataDefinition existingDataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getStructure(classPK), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
            this.putDataDefinition(existingDataDefinition.getId(), existingDataDefinition);
        }
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue());
        Long id = dataDefinition.getSiteId();
        if (id == null) {
            id = this.getPermissionCheckerGroupId(dataDefinitionId);
        }
        this._addDataDefinitionFieldLinks(dataDefinitionContentType.getContentType(), dataDefinitionId, ddmForm.getDDMFormFields(), id);
        return dataDefinition;
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ddmStructure.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDMStructure.class.getName()});
    }

    private void _addDataDefinitionFieldLinks(String contentType, long dataDefinitionId, List<DDMFormField> ddmFormFields, long groupId) throws Exception {
        for (DDMFormField ddmFormField : ddmFormFields) {
            DDMStructure ddmStructure = this._getDDMStructure(contentType, groupId, ddmFormField.getProperties());
            if (ddmStructure != null) {
                this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(groupId, this._portal.getClassNameId(DDMStructure.class), dataDefinitionId, ddmStructure.getStructureId(), ddmFormField.getName());
            }
            this._addDataDefinitionFieldLinks(contentType, dataDefinitionId, ddmFormField.getNestedDDMFormFields(), groupId);
        }
    }

    private void _createDataDefinitionFieldsMap(String contentType, DataDefinitionField[] dataDefinitionFields, Map<Long, DataDefinitionField[]> dataDefinitionFieldsMap, long groupId) throws Exception {
        if (dataDefinitionFields == null) {
            return;
        }
        for (DataDefinitionField dataDefinitionField : dataDefinitionFields) {
            DDMStructure ddmStructure;
            this._createDataDefinitionFieldsMap(contentType, dataDefinitionField.getNestedDataDefinitionFields(), dataDefinitionFieldsMap, groupId);
            Map customProperties = dataDefinitionField.getCustomProperties();
            if (customProperties == null || (ddmStructure = this._getDDMStructure(contentType, groupId, customProperties)) == null) continue;
            long ddmStructureId = ddmStructure.getStructureId();
            dataDefinitionFieldsMap.put(ddmStructureId, (DataDefinitionField[])ArrayUtil.append((Object[])dataDefinitionFieldsMap.computeIfAbsent(ddmStructureId, key -> new DataDefinitionField[0]), (Object)dataDefinitionField));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject _createFieldContextJSONObject(DDMFormFieldType ddmFormFieldType, Locale locale, String type) {
        Locale originalThemeDisplayLocale = LocaleThreadLocal.getThemeDisplayLocale();
        LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
        try {
            DDMForm ddmFormFieldTypeSettingsDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
            Set<Locale> availableLocales = null;
            DDMForm ddmForm = this._getDDMForm();
            if (ddmForm != null) {
                availableLocales = ddmForm.getAvailableLocales();
            } else {
                Locale defaultLocal = LocaleThreadLocal.getSiteDefaultLocale();
                if (defaultLocal == null) {
                    defaultLocal = LocaleThreadLocal.getDefaultLocale();
                }
                availableLocales = Collections.singleton(defaultLocal);
            }
            ddmFormFieldTypeSettingsDDMForm.setAvailableLocales((Set)availableLocales);
            ddmFormFieldTypeSettingsDDMForm.setDefaultLocale(this._getDefaultLocale());
            DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
            ddmFormRenderingContext.setContainerId("settings");
            DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create(this.contextHttpServletRequest, ddmFormFieldTypeSettingsDDMForm);
            this._setTypeDDMFormFieldValue(ddmFormValues, type);
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
            ddmFormRenderingContext.setHttpServletRequest(this.contextHttpServletRequest);
            ddmFormRenderingContext.setLocale(this._getDefaultLocale());
            ddmFormRenderingContext.setPortletNamespace(this._portal.getPortletNamespace(this._portal.getPortletId(this.contextHttpServletRequest)));
            ddmFormRenderingContext.setReturnFullContext(true);
            JSONObject jSONObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep((Object)this._ddmFormTemplateContextFactory.create(ddmFormFieldTypeSettingsDDMForm, DDMFormLayoutFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings()), ddmFormRenderingContext)));
            return jSONObject;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
        }
        finally {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)originalThemeDisplayLocale);
        }
        return null;
    }

    private DataLayoutResource _getDataLayoutResource(boolean checkPermission) {
        DataLayoutResource.Builder dataLayoutResourceBuilder = this._dataLayoutResourceFactory.create();
        return dataLayoutResourceBuilder.checkPermissions(checkPermission).user(this.contextUser).build();
    }

    private DataRecordCollectionResource _getDataRecordCollectionResource(boolean checkPermission) {
        DataRecordCollectionResource.Builder dataRecordCollectionResourceBuilder = this._dataRecordCollectionResourceFactory.create();
        return dataRecordCollectionResourceBuilder.checkPermissions(checkPermission).user(this.contextUser).build();
    }

    private DDMForm _getDDMForm() {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ParamUtil.getLong((HttpServletRequest)this.contextHttpServletRequest, (String)"ddmStructureId"));
        if (ddmStructure == null) {
            return null;
        }
        return ddmStructure.getDDMForm();
    }

    private DDMStructure _getDDMStructure(String contentType, long groupId, Map<String, Object> properties) throws Exception {
        String ddmStructureKey;
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(MapUtil.getLong(properties, (String)"ddmStructureId"));
        if (ddmStructure != null) {
            return ddmStructure;
        }
        long classNameId = DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType);
        ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId, ddmStructureKey = MapUtil.getString(properties, (String)"ddmStructureKey"));
        if (ddmStructure != null) {
            return ddmStructure;
        }
        return this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), classNameId, ddmStructureKey);
    }

    private long _getDefaultDataLayoutId(long dataDefinitionId, DataLayout dataLayout) {
        Long dataLayoutId = dataLayout.getId();
        if (dataLayoutId != null) {
            return dataLayoutId;
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(dataDefinitionId);
        if (ddmStructure == null) {
            return 0L;
        }
        return ddmStructure.getDefaultDDMStructureLayoutId();
    }

    private Locale _getDefaultLocale() {
        DDMForm ddmForm = this._getDDMForm();
        if (ddmForm != null) {
            return ddmForm.getDefaultLocale();
        }
        String i18nLanguageId = (String)this.contextHttpServletRequest.getAttribute("I18N_LANGUAGE_ID");
        if (Validator.isNotNull((String)i18nLanguageId)) {
            return LocaleUtil.fromLanguageId((String)i18nLanguageId);
        }
        Locale locale = LocaleThreadLocal.getSiteDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return LocaleThreadLocal.getDefaultLocale();
    }

    private JSONObject _getFieldTypeMetadataJSONObject(String ddmFormFieldName, ResourceBundle resourceBundle) throws Exception {
        Map ddmFormFieldTypeProperties = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldTypeProperties(ddmFormFieldName);
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldType(ddmFormFieldName);
        JSONObject jsonObject = JSONUtil.put((String)"description", (Object)this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.description"), resourceBundle)).put("displayOrder", MapUtil.getInteger((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.display.order", (int)Integer.MAX_VALUE)).put("group", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.group")).put("icon", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.icon")).put("javaScriptModule", this._resolveModuleName(ddmFormFieldType)).put("label", this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.label"), resourceBundle)).put("name", ddmFormFieldName).put("scope", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.scope")).put("settingsContext", this._createFieldContextJSONObject(ddmFormFieldType, this.contextAcceptLanguage.getPreferredLocale(), ddmFormFieldName)).put("system", MapUtil.getBoolean((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.system"));
        if (StringUtil.equals((String)ddmFormFieldType.getName(), (String)"rich_text")) {
            jsonObject.put("editorConfig", DataDefinitionFieldUtil.getEditorConfig(ddmFormFieldType.getName(), this.contextHttpServletRequest));
        }
        return jsonObject;
    }

    private String[] _getRemovedFieldNames(DataDefinition dataDefinition, long dataDefinitionId) throws Exception {
        ArrayList removedFieldNames = new ArrayList();
        DDMForm ddmForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Object[] fieldNames = ArrayUtil.toStringArray(ddmFormFieldsMap.keySet());
        DataDefinition existingDataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getStructure(dataDefinitionId), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
        DDMForm existingDDMForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)existingDataDefinition, (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry);
        Map existingDDMFormFieldsMap = existingDDMForm.getDDMFormFieldsMap(true);
        for (Map.Entry entry : existingDDMFormFieldsMap.entrySet()) {
            long ddmStructureId;
            DDMStructure fieldSetDDMStructure;
            if (ArrayUtil.contains((Object[])fieldNames, entry.getKey())) continue;
            removedFieldNames.add(entry.getKey());
            DDMFormField ddmFormField = (DDMFormField)entry.getValue();
            if (!Objects.equals(ddmFormField.getType(), "fieldset") || (fieldSetDDMStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId = MapUtil.getLong((Map)ddmFormField.getProperties(), (String)"ddmStructureId"))) == null) continue;
            Map map = fieldSetDDMStructure.getFullHierarchyDDMFormFieldsMap(false);
            removedFieldNames.addAll(map.keySet());
        }
        return removedFieldNames.toArray(new String[0]);
    }

    private ResourceBundle _getResourceBundle(String ddmFormFieldTypeName, Locale locale) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldType(ddmFormFieldTypeName);
        return new AggregateResourceBundle(new ResourceBundle[]{ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass()), ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ddmFormFieldType.getClass()), this._portal.getResourceBundle(locale)});
    }

    private void _normalizeDataDefinitionFields(String contentType, DataDefinitionField[] dataDefinitionFields, long groupId, long structureArticlesCount) throws Exception {
        HashMap<Long, DataDefinitionField[]> dataDefinitionFieldsMap = new HashMap<Long, DataDefinitionField[]>();
        this._createDataDefinitionFieldsMap(contentType, dataDefinitionFields, dataDefinitionFieldsMap, groupId);
        if (MapUtil.isEmpty(dataDefinitionFieldsMap)) {
            return;
        }
        block0: for (Map.Entry entry : dataDefinitionFieldsMap.entrySet()) {
            DataDefinition dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getDDMStructure(((Long)entry.getKey()).longValue()), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.fetchDDMStructureLayout(this._getDefaultDataLayoutId(GetterUtil.getLong((Object)dataDefinition.getId()), dataDefinition.getDefaultDataLayout()));
            if (ddmStructureLayout == null) continue;
            int dataDefinitionFieldsCount = 0;
            for (DataDefinitionField dataDefinitionField : (DataDefinitionField[])entry.getValue()) {
                Map customProperties = dataDefinitionField.getCustomProperties();
                customProperties.put("rows", this._normalizeRowsJSONArray(dataDefinitionFieldsCount, JSONUtil.getValueAsJSONArray((Object)this._jsonFactory.createJSONObject(StringUtil.replace((String)ddmStructureLayout.getDefinition(), (String[])new String[]{"fieldNames"}, (String[])new String[]{"fields"})), (String[])new String[]{"JSONArray/pages", "Object/0", "JSONArray/rows"})));
                Gson gson = new Gson();
                DataDefinitionField[] nestedDataDefinitionFields = (DataDefinitionField[])gson.fromJson(this._jsonFactory.looseSerializeDeep((Object)dataDefinition.getDataDefinitionFields()), DataDefinitionField[].class);
                this._normalizeNestedDataDefinitionFields(dataDefinitionFieldsCount, nestedDataDefinitionFields);
                dataDefinitionField.setNestedDataDefinitionFields(nestedDataDefinitionFields);
                if (structureArticlesCount > 0L && !GetterUtil.getBoolean(customProperties.get("normalizedStructure"))) continue block0;
                customProperties.put("normalizedStructure", true);
                ++dataDefinitionFieldsCount;
            }
        }
    }

    private String _normalizeFieldName(String fieldName, int index) {
        return StringBundler.concat((Object[])new Object[]{fieldName, "_", index});
    }

    private void _normalizeNestedDataDefinitionFields(int dataDefinitionFieldsCount, DataDefinitionField[] nestedDataDefinitionFields) throws Exception {
        if (dataDefinitionFieldsCount == 0 || nestedDataDefinitionFields == null) {
            return;
        }
        for (DataDefinitionField nestedDataDefinitionField : nestedDataDefinitionFields) {
            nestedDataDefinitionField.setName(this._normalizeFieldName(nestedDataDefinitionField.getName(), dataDefinitionFieldsCount));
            Map customProperties = nestedDataDefinitionField.getCustomProperties();
            customProperties.put("fieldReference", this._normalizeFieldName((String)customProperties.get("fieldReference"), dataDefinitionFieldsCount));
            Object rows = customProperties.get("rows");
            if (!(rows instanceof String)) {
                rows = this._jsonFactory.looseSerializeDeep(rows);
            }
            customProperties.put("rows", this._normalizeRowsJSONArray(dataDefinitionFieldsCount, this._jsonFactory.createJSONArray((String)rows)));
            this._normalizeNestedDataDefinitionFields(dataDefinitionFieldsCount, nestedDataDefinitionField.getNestedDataDefinitionFields());
        }
    }

    private String _normalizeRowsJSONArray(int dataDefinitionFieldsCount, JSONArray rowsJSONArray) {
        if (dataDefinitionFieldsCount == 0) {
            return rowsJSONArray.toString();
        }
        for (int i = 0; i < rowsJSONArray.length(); ++i) {
            JSONArray columnsJSONArray = JSONUtil.getValueAsJSONArray((Object)rowsJSONArray.getJSONObject(i), (String[])new String[]{"JSONArray/columns"});
            for (int j = 0; j < columnsJSONArray.length(); ++j) {
                JSONArray normalizedFieldsJSONArray = this._jsonFactory.createJSONArray();
                JSONObject columnJSONObject = columnsJSONArray.getJSONObject(j);
                JSONArray fieldsJSONArray = columnJSONObject.getJSONArray("fields");
                for (int k = 0; k < fieldsJSONArray.length(); ++k) {
                    normalizedFieldsJSONArray.put(this._normalizeFieldName(fieldsJSONArray.getString(k), dataDefinitionFieldsCount));
                }
                columnJSONObject.put("fields", normalizedFieldsJSONArray);
            }
        }
        return rowsJSONArray.toString();
    }

    private DataDefinition _postSiteDataDefinitionByContentType(Long siteId, String contentType, DataDefinition dataDefinition, boolean copyPermissions) throws Exception {
        DataDefinitionPermissionUtil.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), contentType, siteId, "ADD_DATA_DEFINITION");
        this._normalizeDataDefinitionFields(contentType, dataDefinition.getDataDefinitionFields(), GetterUtil.getLong((Object)siteId), 0L);
        DDMForm ddmForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry);
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(contentType);
        ddmForm.setAllowInvalidAvailableLocalesForProperty(dataDefinitionContentType.allowInvalidAvailableLocalesForProperty());
        ddmForm.setDefinitionSchemaVersion("2.0");
        this._validate(dataDefinition, dataDefinitionContentType, ddmForm);
        this._sortNestedDDMFormFields(ddmForm.getDDMFormFields());
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        final DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(PrincipalThreadLocal.getUserId(), siteId.longValue(), 0L, DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType).longValue(), dataDefinition.getDataDefinitionKey(), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), GetterUtil.getString((String)dataDefinition.getStorageType(), (String)StorageType.DEFAULT.getValue()), new ServiceContext());
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            dataLayout.setDataLayoutKey(ddmStructure.getStructureKey());
            if (Validator.isNull((Object)dataLayout.getName())) {
                dataLayout.setName(dataDefinition.getName());
            }
            DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
            try {
                dataDefinition.setDefaultDataLayout(dataLayoutResource.postDataDefinitionDataLayout(Long.valueOf(ddmStructure.getStructureId()), dataLayout));
            }
            catch (Exception exception) {
                this._ddmStructureLocalService.deleteStructure(ddmStructure);
                throw exception;
            }
        }
        this._addDataDefinitionFieldLinks(contentType, ddmStructure.getStructureId(), ddmForm.getDDMFormFields(), ddmStructure.getGroupId());
        Long oldDataDefinitionId = dataDefinition.getId();
        dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, ddmStructure, this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
        if (copyPermissions) {
            this._resourceLocalService.copyModelResources(ddmStructure.getCompanyId(), this._ddmPermissionSupport.getStructureModelResourceName(ddmStructure.getClassName()), oldDataDefinitionId.longValue(), ddmStructure.getPrimaryKey());
        } else {
            this._resourceLocalService.addResources(this.contextCompany.getCompanyId(), siteId.longValue(), PrincipalThreadLocal.getUserId(), ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(DataDefinitionContentTypeRegistryUtil.getClassNameId(contentType).longValue()), DDMStructure.class.getName()}), dataDefinition.getId().longValue(), false, false, false);
        }
        DataRecordCollectionResource dataRecordCollectionResource = this._getDataRecordCollectionResource(false);
        dataRecordCollectionResource.postDataDefinitionDataRecordCollection(dataDefinition.getId(), new DataRecordCollection(){
            {
                this.setDataDefinitionId(() -> ((DDMStructure)ddmStructure).getStructureId());
                this.setDataRecordCollectionKey(() -> ((DDMStructure)ddmStructure).getStructureKey());
                this.setDescription(() -> LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap()));
                this.setName(() -> LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap()));
            }
        });
        return dataDefinition;
    }

    private void _removeFieldsFromDataLayout(DataLayout dataLayout, String[] fieldNames) {
        Map dataLayoutFields = dataLayout.getDataLayoutFields();
        Set dataLayoutFieldNames = dataLayoutFields.keySet();
        dataLayoutFieldNames.removeIf(dataLayoutFieldName -> ArrayUtil.contains((Object[])fieldNames, (Object)dataLayoutFieldName));
        for (DataLayoutPage dataLayoutPage : dataLayout.getDataLayoutPages()) {
            for (DataLayoutRow dataLayoutRow : dataLayoutPage.getDataLayoutRows()) {
                for (DataLayoutColumn dataLayoutColumn : dataLayoutRow.getDataLayoutColumns()) {
                    dataLayoutColumn.setFieldNames((String[])ArrayUtil.filter((Object[])dataLayoutColumn.getFieldNames(), fieldName -> !ArrayUtil.contains((Object[])fieldNames, (Object)fieldName)));
                }
                dataLayoutRow.setDataLayoutColumns((DataLayoutColumn[])ArrayUtil.filter((Object[])dataLayoutRow.getDataLayoutColumns(), column -> !ArrayUtil.isEmpty((Object[])column.getFieldNames()) || column.getColumnSize() != 12));
            }
            dataLayoutPage.setDataLayoutRows((DataLayoutRow[])ArrayUtil.filter((Object[])dataLayoutPage.getDataLayoutRows(), row -> !ArrayUtil.isEmpty((Object[])row.getDataLayoutColumns())));
        }
    }

    private void _removeFieldsFromDataLayouts(Set<Long> ddmStructureLayoutIds, String[] fieldNames) throws Exception {
        for (Long ddmStructureLayoutId : ddmStructureLayoutIds) {
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(ddmStructureLayoutId.longValue());
            DataLayout dataLayout = DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesRegistry, ddmStructureLayout.getDDMFormLayout(), this._spiDDMFormRuleConverter);
            this._removeFieldsFromDataLayout(dataLayout, fieldNames);
            DDMStructure ddmStructure = ddmStructureLayout.getDDMStructure();
            DDMFormLayout ddmFormLayout = ddmStructureLayout.getDDMFormLayout();
            String definitionSchemaVersion = ddmFormLayout.getDefinitionSchemaVersion();
            ddmFormLayout = DataLayoutUtil.toDDMFormLayout(dataLayout, ddmStructure.getDDMForm(), this._ddmFormFieldTypeServicesRegistry, this._ddmFormRuleDeserializer);
            ddmFormLayout.setDefinitionSchemaVersion(definitionSchemaVersion);
            DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
            DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(builder.build());
            ddmStructureLayout.setDefinition(ddmFormLayoutSerializerSerializeResponse.getContent());
            this._ddmStructureLayoutLocalService.updateDDMStructureLayout(ddmStructureLayout);
        }
    }

    private void _removeFieldsFromDataLayoutsAndDataListViews(long dataDefinitionId, String[] fieldNames) throws Exception {
        HashSet<Long> ddmStructureLayoutIds = new HashSet<Long>();
        HashSet<Long> deDataListViewIds = new HashSet<Long>();
        ddmStructureLayoutIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId, fieldNames), DEDataDefinitionFieldLinkModel::getClassPK));
        deDataListViewIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId, fieldNames), DEDataDefinitionFieldLinkModel::getClassPK));
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId, fieldNames);
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId, fieldNames);
        this._removeFieldsFromDataLayouts(ddmStructureLayoutIds, fieldNames);
        this._removeFieldsFromDataListViews(deDataListViewIds, fieldNames);
    }

    private void _removeFieldsFromDataListViews(Set<Long> deDataListViewIds, String[] removedFieldNames) throws Exception {
        DataListViewResource.Builder dataListViewResourceBuilder = this._dataListViewResourceFactory.create();
        DataListViewResource dataListViewResource = dataListViewResourceBuilder.checkPermissions(false).user(this.contextUser).build();
        for (Long deDataListViewId : deDataListViewIds) {
            DataListView dataListView = dataListViewResource.getDataListView(deDataListViewId);
            dataListView.setFieldNames((String[])ArrayUtil.filter((Object[])JSONUtil.toStringArray((JSONArray)this._jsonFactory.createJSONArray((Object[])dataListView.getFieldNames())), fieldName -> !ArrayUtil.contains((Object[])removedFieldNames, (Object)fieldName)));
            dataListViewResource.putDataListView(dataListView.getId(), dataListView);
        }
    }

    private String _resolveModuleName(DDMFormFieldType ddmFormFieldType) {
        if (Validator.isNull((String)ddmFormFieldType.getModuleName())) {
            return "";
        }
        if (ddmFormFieldType.isCustomDDMFormFieldType()) {
            return ddmFormFieldType.getModuleName();
        }
        return this._npmResolver.resolveModuleName(ddmFormFieldType.getModuleName());
    }

    private void _setTypeDDMFormFieldValue(DDMFormValues ddmFormValues, String type) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("type");
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValue.setValue((Value)new UnlocalizedValue(type));
    }

    private void _sortNestedDDMFormFields(List<DDMFormField> ddmFormFields) throws Exception {
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) continue;
            JSONArray rowsJSONArray = null;
            rowsJSONArray = ddmFormField.getProperty("rows") instanceof String ? this._jsonFactory.createJSONArray(GetterUtil.getString((Object)ddmFormField.getProperty("rows"))) : this._jsonFactory.createJSONArray(this._jsonFactory.looseSerializeDeep(ddmFormField.getProperty("rows")));
            Map nestedDDMFormFieldsMap = ddmFormField.getNestedDDMFormFieldsMap();
            ArrayList<DDMFormField> sortedNestedDDMFormFields = new ArrayList<DDMFormField>();
            for (int i = 0; i < rowsJSONArray.length(); ++i) {
                JSONObject rowJSONObject = rowsJSONArray.getJSONObject(i);
                if (rowJSONObject == null) {
                    rowJSONObject = this._jsonFactory.createJSONObject((String)rowsJSONArray.get(i));
                }
                JSONArray columnsJSONArray = rowJSONObject.getJSONArray("columns");
                for (int j = 0; j < columnsJSONArray.length(); ++j) {
                    JSONObject columnJSONObject = columnsJSONArray.getJSONObject(j);
                    for (String fieldName : JSONUtil.toStringList((JSONArray)columnJSONObject.getJSONArray("fields"))) {
                        DDMFormField nestedDDMFormField = (DDMFormField)nestedDDMFormFieldsMap.get(fieldName);
                        if (StringUtil.equals((String)nestedDDMFormField.getType(), (String)"fieldset")) {
                            this._sortNestedDDMFormFields(ListUtil.toList((Object)nestedDDMFormField));
                        }
                        sortedNestedDDMFormFields.add(nestedDDMFormField);
                    }
                }
            }
            ddmFormField.setNestedDDMFormFields(sortedNestedDDMFormFields);
        }
    }

    private DataDefinition _toDataDefinition(DDMStructure ddmStructure) throws Exception {
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, ddmStructure, this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
    }

    private DataDefinitionValidationException _toDataDefinitionValidationException(DDMFormValidationException ddmFormValidationException) {
        if (ddmFormValidationException instanceof DDMFormValidationException.MustNotDuplicateFieldName) {
            DDMFormValidationException.MustNotDuplicateFieldName mustNotDuplicateFieldName = (DDMFormValidationException.MustNotDuplicateFieldName)ddmFormValidationException;
            return new DataDefinitionValidationException.MustNotDuplicateFieldName(mustNotDuplicateFieldName.getDuplicatedFieldNames());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustNotDuplicateFieldReference) {
            DDMFormValidationException.MustNotDuplicateFieldReference mustNotDuplicateFieldReference = (DDMFormValidationException.MustNotDuplicateFieldReference)ddmFormValidationException;
            return new DataDefinitionValidationException.MustNotDuplicateFieldReference(mustNotDuplicateFieldReference.getDuplicatedFieldReferences());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetAvailableLocales) {
            return new DataDefinitionValidationException.MustSetAvailableLocales();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetDefaultLocale) {
            return new DataDefinitionValidationException.MustSetDefaultLocale();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale) {
            DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale mustSetDefaultLocaleAsAvailableLocale = (DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetDefaultLocaleAsAvailableLocale(mustSetDefaultLocaleAsAvailableLocale.getDefaultLocale());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldsForForm) {
            return new DataDefinitionValidationException.MustSetFields();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldType) {
            DDMFormValidationException.MustSetFieldType mustSetFieldType = (DDMFormValidationException.MustSetFieldType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetFieldType(mustSetFieldType.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetOptionsForField) {
            DDMFormValidationException.MustSetOptionsForField mustSetOptionsForField = (DDMFormValidationException.MustSetOptionsForField)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetOptionsForField(mustSetOptionsForField.getFieldLabel(), mustSetOptionsForField.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidAvailableLocalesForProperty) {
            DDMFormValidationException.MustSetValidAvailableLocalesForProperty mustSetValidAvailableLocalesForProperty = (DDMFormValidationException.MustSetValidAvailableLocalesForProperty)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidAvailableLocalesForProperty(mustSetValidAvailableLocalesForProperty.getFieldName(), mustSetValidAvailableLocalesForProperty.getProperty());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidCharactersForFieldName) {
            DDMFormValidationException.MustSetValidCharactersForFieldName mustSetValidCharactersForFieldName = (DDMFormValidationException.MustSetValidCharactersForFieldName)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidCharactersForFieldName(mustSetValidCharactersForFieldName.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidCharactersForFieldType) {
            DDMFormValidationException.MustSetValidCharactersForFieldType mustSetValidCharactersForFieldType = (DDMFormValidationException.MustSetValidCharactersForFieldType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidCharactersForFieldType(mustSetValidCharactersForFieldType.getFieldType());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidDefaultLocaleForProperty) {
            DDMFormValidationException.MustSetValidDefaultLocaleForProperty mustSetValidDefaultLocaleForProperty = (DDMFormValidationException.MustSetValidDefaultLocaleForProperty)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidDefaultLocaleForProperty(mustSetValidDefaultLocaleForProperty.getFieldName(), mustSetValidDefaultLocaleForProperty.getProperty());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidFormRuleExpression) {
            DDMFormValidationException.MustSetValidFormRuleExpression mustSetValidFormRuleExpression = (DDMFormValidationException.MustSetValidFormRuleExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidRuleExpression(mustSetValidFormRuleExpression.getExpression(), mustSetValidFormRuleExpression.getMessage());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidIndexType) {
            DDMFormValidationException.MustSetValidIndexType mustSetValidIndexType = (DDMFormValidationException.MustSetValidIndexType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidIndexType(mustSetValidIndexType.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidType) {
            DDMFormValidationException.MustSetValidType mustSetValidType = (DDMFormValidationException.MustSetValidType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidType(mustSetValidType.getFieldType());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidValidationExpression) {
            DDMFormValidationException.MustSetValidValidationExpression mustSetValidValidationExpression = (DDMFormValidationException.MustSetValidValidationExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidValidationExpression(mustSetValidValidationExpression.getFieldName(), mustSetValidValidationExpression.getExpression());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidVisibilityExpression) {
            DDMFormValidationException.MustSetValidVisibilityExpression mustSetValidVisibilityExpression = (DDMFormValidationException.MustSetValidVisibilityExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidVisibilityExpression(mustSetValidVisibilityExpression.getFieldName(), mustSetValidVisibilityExpression.getExpression());
        }
        return new DataDefinitionValidationException(ddmFormValidationException.getCause());
    }

    private OrderByComparator<DDMStructure> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureNameComparator(ascending);
        }
        return new StructureModifiedDateComparator(ascending);
    }

    private String _translate(String key, ResourceBundle resourceBundle) {
        if (Validator.isNull((String)key)) {
            return "";
        }
        return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key), (String)key);
    }

    private void _uniquifyDataDefinitionFields(DataDefinition dataDefinition) {
        for (DataDefinitionField dataDefinitionField : dataDefinition.getDataDefinitionFields()) {
            this._uniquifyDataDefinitionFields(dataDefinitionField);
        }
        this._updateDataLayout(dataDefinition.getDefaultDataLayout());
    }

    private void _uniquifyDataDefinitionFields(DataDefinitionField dataDefinitionField) {
        dataDefinitionField.setName("CopyOf" + dataDefinitionField.getName());
        Map customProperties = dataDefinitionField.getCustomProperties();
        if (customProperties.containsKey("fieldReference")) {
            customProperties.put("fieldReference", "CopyOf" + customProperties.get("fieldReference"));
        }
        if (!customProperties.containsKey("structureId") && !Objects.equals(dataDefinitionField.getFieldType(), "fieldset")) {
            for (DataDefinitionField nestedDataDefinitionField : dataDefinitionField.getNestedDataDefinitionFields()) {
                this._uniquifyDataDefinitionFields(nestedDataDefinitionField);
            }
        }
    }

    private DataDefinition _updateDataDefinition(DataDefinition dataDefinition, Long dataDefinitionId, DDMForm ddmForm) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.updateStructure(PrincipalThreadLocal.getUserId(), dataDefinitionId.longValue(), GetterUtil.getLong((Object)ddmStructure.getParentStructureId(), (long)0L), dataDefinition.getDataDefinitionKey(), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), new ServiceContext()), this._ddmStructureLayoutLocalService, this.contextHttpServletRequest, this._spiDDMFormRuleConverter);
    }

    private void _updateDataLayout(DataLayout dataLayout) {
        for (DataLayoutPage dataLayoutPage : dataLayout.getDataLayoutPages()) {
            this._updateDataLayoutRows(dataLayoutPage.getDataLayoutRows());
        }
    }

    private void _updateDataLayoutRows(DataLayoutRow[] dataLayoutRows) {
        for (DataLayoutRow dataLayoutRow : dataLayoutRows) {
            for (DataLayoutColumn dataLayoutColumn : dataLayoutRow.getDataLayoutColumns()) {
                String[] dataLayoutColumnFieldNames = dataLayoutColumn.getFieldNames();
                for (int i = 0; i < dataLayoutColumnFieldNames.length; ++i) {
                    dataLayoutColumnFieldNames[i] = "CopyOf" + dataLayoutColumnFieldNames[i];
                }
            }
        }
    }

    private void _validate(DataDefinition dataDefinition, DataDefinitionContentType dataDefinitionContentType, DDMForm ddmForm) throws Exception {
        try {
            Map name = dataDefinition.getName();
            Locale defaultLocale = ddmForm.getDefaultLocale();
            if (name == null || Validator.isNull(name.get(LocaleUtil.toLanguageId((Locale)defaultLocale)))) {
                throw new DataDefinitionValidationException.MustSetValidName("Name is null for locale " + defaultLocale.getDisplayName());
            }
            this._ddmFormValidator.validate(ddmForm);
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldsForForm && dataDefinitionContentType.allowEmptyDataDefinition()) {
                return;
            }
            throw this._toDataDefinitionValidationException(ddmFormValidationException);
        }
        catch (DataDefinitionValidationException dataDefinitionValidationException) {
            throw dataDefinitionValidationException;
        }
        catch (Exception exception) {
            throw new DataDefinitionValidationException((Throwable)exception);
        }
    }
}

